/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.util.StringTokenizer;
import java.util.Vector;
import org.droiddraw.property.StringProperty;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.LinearLayout;
import org.droiddraw.widget.TableRow;
import org.droiddraw.widget.Widget;

public class TableLayout
extends LinearLayout {
    public static final String TAG_NAME = "TableLayout";
    Vector<Integer> max_widths;
    Vector<Integer> stretchColumns;
    boolean stretchAll;
    StringProperty stretch;

    public TableLayout() {
        this.setTagName(TAG_NAME);
        this.max_widths = new Vector();
        this.stretch = new StringProperty("Stretchable Column", "android:stretchColumns", "");
        this.props.add(this.stretch);
        this.stretchColumns = new Vector();
        this.stretchAll = false;
        this.apply();
    }

    protected void calculateMaxWidths() {
        block12: {
            this.max_widths.clear();
            for (Widget wt : this.widgets) {
                if (!(wt instanceof TableRow)) continue;
                int ix = 0;
                TableRow row = (TableRow)wt;
                for (Widget w : row.getWidgets()) {
                    if (w.getPropertyByAttName("android:layout_column") != null) {
                        ix = Integer.parseInt(w.getPropertyByAttName("android:layout_column").getValue().toString());
                    }
                    w.apply();
                    int wd = w.getPadding(1) + w.getWidth() + w.getPadding(3);
                    if (ix >= this.max_widths.size()) {
                        while (this.max_widths.size() < ix) {
                            this.max_widths.add(0);
                        }
                        this.max_widths.add(wd);
                    } else if (this.max_widths.get(ix) < wd) {
                        this.max_widths.set(ix, wd);
                    }
                    ++ix;
                }
            }
            int total = 0;
            for (int i : this.max_widths) {
                total += i;
            }
            int extra = this.getWidth() - total;
            if (extra <= 0 || this.stretchColumns.size() <= 0 && !this.stretchAll) break block12;
            if (this.stretchAll) {
                int share = extra / this.max_widths.size();
                int i = 0;
                while (i < this.max_widths.size()) {
                    this.max_widths.set(i, this.max_widths.get(i) + share);
                    ++i;
                }
            } else {
                int share = extra / this.stretchColumns.size();
                for (int col : this.stretchColumns) {
                    if (col >= this.max_widths.size()) continue;
                    this.max_widths.set(col, this.max_widths.get(col) + share);
                }
            }
        }
    }

    public void apply() {
        if (this.stretch != null) {
            String cols = this.stretch.getStringValue();
            this.stretchColumns.clear();
            if (cols != null) {
                if (cols.equals("*")) {
                    this.stretchAll = true;
                } else {
                    StringTokenizer toks = new StringTokenizer(cols, ",");
                    while (toks.hasMoreTokens()) {
                        this.stretchColumns.add(new Integer(toks.nextToken()));
                    }
                }
            }
        }
        super.apply();
    }

    public void resizeForRendering() {
        this.calculateMaxWidths();
        for (Widget w : this.widgets) {
            if (w instanceof TableRow) {
                ((TableRow)w).setWidths(this.max_widths);
                continue;
            }
            w.setSizeInternal(this.getWidth() - w.getPadding(1) - w.getPadding(3), w.getHeight());
            if (!(w instanceof Layout)) continue;
            ((Layout)w).resizeForRendering();
        }
    }
}

