/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.util.Vector;
import org.droiddraw.property.StringProperty;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.LinearLayout;
import org.droiddraw.widget.TableLayout;
import org.droiddraw.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRow
extends LinearLayout {
    public static final String TAG_NAME = "TableRow";
    Vector<Integer> widths;

    public TableRow() {
        this.setTagName(TAG_NAME);
        this.orientation.setStringValue("horizontal");
        this.orientation.setEditable(false);
        this.widthProp.setStringValue("fill_parent");
        this.widthProp.setEditable(false);
        this.apply();
    }

    @Override
    public void positionWidget(Widget w) {
        super.positionWidget(w);
        if (this.parent instanceof TableLayout) {
            this.parent.positionWidget(this);
        }
    }

    @Override
    protected void repositionAllWidgetsInternal() {
        StringProperty prop;
        int y = 0;
        int x = 0;
        Vector<Widget> with_weight = new Vector<Widget>();
        int max_base = 0;
        for (Widget w : this.widgets) {
            if (!this.vertical && !(w instanceof Layout) && w.getBaseline() > max_base) {
                max_base = w.getBaseline();
            }
            if ((prop = (StringProperty)w.getPropertyByAttName("android:layout_weight")) != null && "1".equals(prop.getStringValue())) {
                with_weight.add(w);
            }
            if (this.vertical) {
                y += w.getPadding(0) + w.getHeight() + w.getPadding(2);
                continue;
            }
            x += w.getPadding(1) + w.getWidth() + w.getPadding(3);
        }
        if (with_weight.size() > 0) {
            if (this.vertical) {
                int extra = this.getHeight() - y;
                this.share = extra / with_weight.size();
            } else {
                int extra = this.getWidth() - x;
                this.share = extra / with_weight.size();
            }
        }
        y = 0;
        x = 0;
        for (Widget w : this.widgets) {
            prop = (StringProperty)w.getPropertyByAttName("android:layout_column");
            if (prop != null && this.widths != null) {
                int col = Integer.parseInt(prop.getStringValue());
                int ix = this.widgets.indexOf(w);
                while (ix < col) {
                    x += this.widths.get(ix++).intValue();
                }
            }
            String gravity = "left";
            prop = (StringProperty)w.getPropertyByAttName("android:layout_gravity");
            if (prop != null) {
                gravity = prop.getStringValue();
            }
            if (this.vertical) {
                int width_w_pad = w.getPadding(1) + w.getWidth() + w.getPadding(3);
                x = "right".equals(gravity) ? this.getWidth() - width_w_pad : ("center_horizontal".equals(gravity) || "center".equals(gravity) ? this.getWidth() / 2 - width_w_pad / 2 : w.getPadding(1));
            } else {
                int height_w_pad = w.getPadding(0) + w.getHeight() + w.getPadding(2);
                y = "bottom".equals(gravity) ? this.getHeight() - height_w_pad : ("center_vertical".equals(gravity) || "center".equals(gravity) ? (this.getHeight() - height_w_pad) / 2 : (w instanceof Layout ? w.getPadding(0) : max_base - w.getBaseline() + w.getPadding(0)));
            }
            if (this.vertical) {
                y += w.getPadding(0);
            } else {
                x += w.getPadding(1);
            }
            w.setPosition(x, y);
            if (this.vertical) {
                y += w.getHeight() + w.getPadding(2);
                continue;
            }
            x += w.getWidth() + w.getPadding(3);
        }
    }

    public void setWidths(Vector<Integer> widths) {
        int ix = 0;
        for (Widget w : this.widgets) {
            StringProperty prop = (StringProperty)w.getPropertyByAttName("android:layout_column");
            if (prop != null) {
                ix = Integer.parseInt(prop.getStringValue());
            }
            prop = (StringProperty)w.getPropertyByAttName("android:layout_span");
            int wd = widths.get(ix++);
            if (prop != null) {
                int span = Integer.parseInt(prop.getStringValue());
                int i = 1;
                while (i < span) {
                    wd += widths.get(ix++).intValue();
                    ++i;
                }
            }
            w.setSizeInternal(wd - w.getPadding(1) - w.getPadding(3), w.getHeight());
        }
        this.widths = widths;
        this.repositionAllWidgetsInternal();
    }

    @Override
    public int getContentWidth() {
        if (this.widths != null && this.widths.size() > 0) {
            int res = 0;
            for (int w : this.widths) {
                res += w;
            }
            return res;
        }
        return super.getContentWidth();
    }

    @Override
    public void addEditableProperties(Widget w) {
        w.addProperty(new StringProperty("Column Span", "android:layout_span", "1"));
        super.addEditableProperties(w);
    }

    @Override
    public void removeEditableProperties(Widget w) {
        w.removeProperty(new StringProperty("Column Span", "android:layout_span", "1"));
        super.removeEditableProperties(w);
    }
}

