/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.PropertiesPanel;
import org.droiddraw.property.ColorProperty;
import org.droiddraw.property.Property;
import org.droiddraw.property.SelectProperty;
import org.droiddraw.property.StringProperty;
import org.droiddraw.util.DisplayMetrics;
import org.droiddraw.widget.AbstractWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextView
extends AbstractWidget {
    public static final String TAG_NAME = "TextView";
    public static final int START = 0;
    public static final int CENTER = 1;
    public static final int END = 2;
    int fontSize = 14;
    StringProperty text = new StringProperty("Text", "android:text", "");
    StringProperty hint;
    StringProperty fontSz;
    SelectProperty face;
    SelectProperty style;
    SelectProperty align;
    ColorProperty textColor;
    int pad_x = 6;
    int pad_y = 4;
    PropertiesPanel p;
    Font f;
    BufferedImage bg;
    boolean osx;
    public static final String[] propertyNames = new String[]{"android:hint", "android:textSize", "android:textStyle", "android:typeface", "android:textColor"};

    public TextView(String str) {
        super(TAG_NAME);
        if (str != null) {
            this.text.setStringValue(str);
        }
        this.hint = new StringProperty("Default Text", "android:hint", "");
        this.fontSz = new StringProperty("Font Size", "android:textSize", String.valueOf(this.fontSize) + "sp");
        this.face = new SelectProperty("Font Face", "android:typeface", new String[]{"normal", "sans", "serif", "monospace"}, 0);
        this.style = new SelectProperty("Font Style", "android:textStyle", new String[]{"normal", "bold", "italic", "bold|italic"}, 0);
        this.textColor = new ColorProperty("Text Color", "android:textColor", null);
        this.align = new SelectProperty("Text Alignment", "android:gravity", new String[]{"left", "center", "right"}, 2);
        this.props.add(this.text);
        this.props.add(this.hint);
        this.props.add(this.fontSz);
        this.props.add(this.face);
        this.props.add(this.style);
        this.props.add(this.textColor);
        this.props.add(this.align);
        this.osx = System.getProperty("os.name").toLowerCase().contains("mac os x");
        this.buildFont();
        this.bg = new BufferedImage(1, 1, 10);
        this.apply();
    }

    protected void buildFont() {
        this.f = this.osx ? new Font("Arial", 0, this.fontSize) : new Font(this.face.getStringValue(), 0, this.fontSize);
        if (this.style.getStringValue() != null && this.style.getStringValue().contains("bold")) {
            this.f = this.f.deriveFont(this.f.getStyle() | 1);
        }
        if (this.style.getStringValue() != null && this.style.getStringValue().contains("italic")) {
            this.f = this.f.deriveFont(this.f.getStyle() | 2);
        }
    }

    @Override
    public void apply() {
        super.apply();
        if (this.fontSz.getStringValue() != null && this.fontSz.getStringValue().length() > 0) {
            this.fontSize = DisplayMetrics.readSize(this.fontSz);
        }
        this.buildFont();
        this.readWidthHeight();
        this.baseline = this.fontSize + this.pad_y / 2;
    }

    protected Vector<String> buildLineBreaks(String textVal) {
        int ix;
        Vector<String> res = new Vector<String>();
        String str = textVal;
        do {
            int width;
            ix = str.indexOf(10);
            String txt = str;
            if (ix != -1) {
                txt = str.substring(0, ix);
                str = str.substring(ix + 1);
            }
            if ((width = this.getWidth()) < 0) {
                res.add(txt);
                return res;
            }
            int l = this.stringLength(txt);
            while (l > width) {
                int bk = 1;
                while (this.stringLength(txt.substring(0, bk)) < width) {
                    ++bk;
                }
                if (--bk == 0) {
                    return res;
                }
                String sub = txt.substring(0, bk);
                res.add(sub);
                txt = txt.substring(bk);
                l = this.stringLength(txt);
            }
            res.add(txt);
        } while (ix != -1);
        return res;
    }

    protected int stringLength(String str) {
        if (str == null) {
            return 0;
        }
        return this.bg.getGraphics().getFontMetrics(this.f).stringWidth(str);
    }

    protected String getText() {
        String txt = this.text.getStringValue();
        if (txt == null || txt.length() == 0) {
            txt = this.hint.getStringValue();
        }
        return txt;
    }

    @Override
    protected int getContentWidth() {
        int l = this.stringLength(this.getText()) + this.pad_x;
        if (l > AndroidEditor.instance().getScreenX()) {
            l = AndroidEditor.instance().getScreenX() - this.getX();
        }
        return l;
    }

    @Override
    protected int getContentHeight() {
        Vector<String> texts = this.buildLineBreaks(this.getText());
        if (texts.size() == 0) {
            return this.fontSize + this.pad_y;
        }
        int h = texts.size() * (this.fontSize + 1) + this.pad_y;
        return h;
    }

    protected void drawText(Graphics g, int x, int h) {
        int aln = 0;
        if (this.align.getStringValue().equals("end")) {
            aln = 2;
        } else if (this.align.getStringValue().equals("center")) {
            aln = 1;
        }
        this.drawText(g, x, h, aln);
    }

    protected void drawText(Graphics g, int dx, int h, int align) {
        int x = 0;
        String txt = this.getText();
        for (String s : this.buildLineBreaks(txt)) {
            int l = this.stringLength(s);
            x = align == 2 ? this.getX() + this.getWidth() - l - this.pad_x / 2 + dx : (align == 1 ? this.getX() + this.getWidth() / 2 - l / 2 + dx : this.getX() + this.pad_x / 2 + dx);
            g.drawString(s, x, this.getY() + h);
            if ((h += this.fontSize + 1) > this.getHeight()) break;
        }
    }

    protected void setTextColor(Graphics g) {
        Color c = this.textColor.getColorValue();
        String theme = AndroidEditor.instance().getTheme();
        Color def = null;
        if (theme == null || theme.equals("default")) {
            def = Color.white;
        } else if (theme.equals("light")) {
            def = Color.black;
        }
        if (c == null) {
            c = def;
        }
        g.setColor(c);
    }

    @Override
    public void paint(Graphics g) {
        this.drawBackground(g);
        if (this.getText() != null) {
            this.setTextColor(g);
            g.setFont(this.f);
            int h = this.fontSize + this.pad_y / 2;
            this.drawText(g, 0, h);
        }
    }

    @Override
    public Vector<Property> getProperties() {
        return this.props;
    }
}

