/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Action;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Matrix;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.Script;
import com.macromedia.generator.api.Shape;
import com.macromedia.generator.api.Text;
import com.macromedia.generator.api.peer.ButtonPeer;

public class Button
extends GenObject {
    public static final int buttonStateNone = 0;
    public static final int buttonStateUp = 1;
    public static final int buttonStateOver = 2;
    public static final int buttonStateDown = 4;
    public static final int buttonStateTest = 8;
    public static final int buttonTrackAsButton = 0;
    public static final int buttonTrackAsMenu = 1;

    public Button() throws GeneratorApiException {
        this.peer = ButtonPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    public Button(boolean bl) throws GeneratorApiException {
        this.peer = bl ? ButtonPeer.New2() : ButtonPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Button(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            ButtonPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            ButtonPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void addShape(Shape shape, Matrix matrix, int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = 1;
        n3 = ButtonPeer.AddShape(this.peer, shape.peer, matrix.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error adding shape");
        }
    }

    public void addScript(Script script, Matrix matrix, int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = ButtonPeer.AddScript(this.peer, script.peer, matrix.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error adding script");
        }
    }

    public void addText(Text text, Matrix matrix, int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = ButtonPeer.AddShape(this.peer, text.peer, matrix.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error adding text");
        }
    }

    public void addAction(Action action) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ButtonPeer.AddAction(this.peer, action.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding action");
        }
    }

    public Rect getBounds() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ButtonPeer.GetBounds(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting bounds");
        }
        return new Rect(nArray[0]);
    }

    public void setCenter(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = ButtonPeer.SetCenter(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error setting center");
        }
    }

    public void setTracking(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ButtonPeer.SetTracking(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting tracking");
        }
    }
}

