/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Font;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.GeneratorApiRuntimeException;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.peer.EditTextPeer;

public class EditText
extends GenObject {
    public static final int PROP_READONLY = 8;
    public static final int PROP_PASSWORD = 16;
    public static final int PROP_MULTILINE = 32;
    public static final int PROP_USEOUTLINES = 256;
    public static final int PROP_WORDWRAP = 64;
    public static final int PROP_BORDER = 2048;
    public static final int PROP_NOSELECT = 4096;
    public static final int PROP_MAXLENGTH = 2;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_JUSTIFY = 3;

    public EditText() throws GeneratorApiException {
        this.peer = EditTextPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected EditText(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            EditTextPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            EditTextPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setFont(Font font) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.SetFont(this.peer, font.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting font");
        }
    }

    public void setHeight(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.SetHeight(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting edit text height");
        }
    }

    public int getHeight() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.GetHeight(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting height");
        }
        return nArray[0];
    }

    public void setColor(int n, int n2, int n3) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n4 = EditTextPeer.SetColor(this.peer, n, n2, n3);
        if (n4 == 0) {
            throw new GeneratorApiException("error setting color");
        }
    }

    public void setAlignment(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.SetAlignment(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text alignment");
        }
    }

    public int getAlignment() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.GetAlignment(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting alignment");
        }
        return nArray[0];
    }

    public void setIndent(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.SetIndent(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text indent");
        }
    }

    public int getIndent() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.GetIndent(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting indentation");
        }
        return nArray[0];
    }

    public void setLeftMargin(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.SetLeftMargin(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text left margin");
        }
    }

    public int getLeftMargin() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.GetLeftMargin(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting left margin");
        }
        return nArray[0];
    }

    public void setRightMargin(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.SetRightMargin(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text right margin");
        }
    }

    public int getRightMargin() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.GetRightMargin(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting right margin");
        }
        return nArray[0];
    }

    public void setLeading(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.SetLeading(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text leading");
        }
    }

    public int getLeading() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.GetLeading(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting leading");
        }
        return nArray[0];
    }

    public void setString(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        int n = EditTextPeer.SetString(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting text string");
        }
    }

    public String getString() {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = EditTextPeer.GetString(this.peer, stringArray);
        if (n == 0) {
            stringArray[0] = null;
        }
        return stringArray[0];
    }

    public void setVariable(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        int n = EditTextPeer.SetVariable(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting text variable");
        }
    }

    public Rect getBounds() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.GetBounds(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting bounds");
        }
        return new Rect(nArray[0]);
    }

    public void setBounds(Rect rect) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.SetBounds(this.peer, rect.getPeer());
        if (n == 0) {
            throw new GeneratorApiException("error getting bounds");
        }
    }

    public void setMaxLength(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.SetMaxLength(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting max length");
        }
    }

    public int getMaxLength() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = EditTextPeer.GetMaxLength(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting max length");
        }
        return nArray[0];
    }

    public void setProperty(int n, boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.SetProperty(this.peer, n, bl);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting property");
        }
    }

    public boolean getProperty(int n) throws GeneratorApiException {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = EditTextPeer.GetProperty(this.peer, n, blArray);
        if (n2 == 0) {
            throw new GeneratorApiException("error getting property");
        }
        return blArray[0];
    }
}

