/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.peer.FontPeer;
import com.macromedia.generator.platform.Mac;

public class Font
extends GenObject {
    public Font() throws GeneratorApiException {
        this.peer = FontPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Font(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            FontPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            FontPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setFile(String string) throws GeneratorApiException {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        Mac mac = Mac.getMac();
        if (mac != null) {
            String string2 = mac.makeSystemPretty(string);
            n = FontPeer.SetFile(this.peer, string2);
        } else {
            n = FontPeer.SetFile(this.peer, string);
        }
        if (n == 0) {
            throw new GeneratorApiException("error setting file");
        }
    }

    public void setFftFile(String string) throws GeneratorApiException {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        Mac mac = Mac.getMac();
        if (mac != null) {
            String string2 = mac.makeSystemPretty(string);
            n = FontPeer.SetFftFile(this.peer, string2);
        } else {
            n = FontPeer.SetFftFile(this.peer, string);
        }
        if (n == 0) {
            throw new GeneratorApiException("error setting file");
        }
    }

    public void setFont(String string, boolean bl, boolean bl2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        int n = FontPeer.SetFont(this.peer, string, bl, bl2);
        if (n == 0) {
            throw new GeneratorApiException("error setting font");
        }
    }

    public int getAscent() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FontPeer.GetAscent(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting ascent");
        }
        return nArray[0];
    }

    public int getDescent() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FontPeer.GetDescent(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting descent");
        }
        return nArray[0];
    }

    public int getLeading() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FontPeer.GetLeading(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting leading");
        }
        return nArray[0];
    }
}

