/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.app.CacheLog;
import com.macromedia.generator.app.GenCacheEntry;
import com.macromedia.generator.app.URLCache;
import com.macromedia.generator.utils.GenUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class FileCache
extends URLCache {
    private final String kIndexFileName = "index.dat";
    private final String kIndexHeader = "Generator Disk Cache Index - DO NOT EDIT!";
    private final String kFileSeparator = "/";
    private String mCachePath = null;
    private boolean mFlushed = false;
    private boolean mLoad = false;

    public FileCache(long l, boolean bl, boolean bl2, long l2, boolean bl3, boolean bl4, int n, int n2, CacheLog cacheLog) {
        super(l, bl, bl2, l2, bl3, n, n2, cacheLog);
        this.mLoad = bl4;
        if (this.mLoad) {
            this.loadIndex();
        } else if (l > 0L) {
            this.cleanupCacheDirectory(true);
        }
    }

    public boolean getLoad() {
        return this.mLoad;
    }

    public void setLoad(boolean bl) {
        this.mLoad = bl;
    }

    public void loadIndex() {
        this.logCacheMessage(this.getResString("LoadingIndex"), 2);
        if (this.isCacheEnabled()) {
            this.readIndex();
        }
    }

    protected void dispose() {
        if (this.mFlushed) {
            return;
        }
        this.flush();
    }

    public void flush() {
        if (!this.isCacheEnabled()) {
            return;
        }
        this.logCacheMessage(this.getResString("Flushing"), 2);
        this.writeIndex();
        this.mFlushed = true;
    }

    protected byte[] readURLInputStream(URL uRL, InputStream inputStream, long l, int n, boolean bl, long l2) throws IOException {
        byte[] byArray = null;
        if (this.isCacheEnabled() && (this.getForce() || bl)) {
            File file;
            String string = uRL.getFile();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(n2);
            }
            if ((n2 = string.indexOf(63)) != -1) {
                string = string.substring(0, n2);
            }
            if ((file = this.createNewCacheFile(string)) == null) {
                throw new IOException(this.getResString("ErrorCreatingNewCacheFile"));
            }
            FileOutputStream fileOutputStream = null;
            byArray = this.readInputStream(inputStream, l, n);
            if (byArray == null) {
                throw new IOException(this.getResString("ErrorReadingInputStream"));
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
            String string2 = file.getPath();
            if (string2 == null) {
                throw new IOException(this.getResString("ErrorReadingInputStream"));
            }
            this.setCacheURL(uRL, string2, byArray.length, l2);
        }
        return byArray;
    }

    protected byte[] readURLLocalFile(URL uRL, boolean bl, long l) throws IOException {
        return null;
    }

    protected Object getCacheURL(URL uRL) {
        byte[] byArray = null;
        String string = (String)super.getCacheURL(uRL);
        if (string == null) {
            return null;
        }
        try {
            byArray = this.readFile(string);
        }
        catch (IOException iOException) {
            return null;
        }
        return byArray;
    }

    protected boolean verifyCacheValue(GenCacheEntry genCacheEntry) {
        if (genCacheEntry == null) {
            return false;
        }
        return this.makeFileFromCacheFilePath((String)genCacheEntry.value) != null;
    }

    protected synchronized void removeCacheEntry(GenCacheEntry genCacheEntry) {
        if (genCacheEntry != null) {
            File file = this.makeFileFromCacheFilePath((String)genCacheEntry.value);
            if (file != null) {
                file.delete();
            }
            super.removeCacheEntry(genCacheEntry);
        }
    }

    private File createNewCacheFile(String string) {
        File file = null;
        try {
            String string2;
            if (string.length() != 4) {
                string = ".gen";
            }
            if ((string2 = this.getCachePath()) == null) {
                throw new IOException(this.getResString("InvalidCachePath"));
            }
            File file2 = new File(string2 = this.makeJavaPretty(string2));
            if (file2 == null) {
                throw new IOException(this.getResString("InvalidCacheDirectory"));
            }
            file = GenUtils.createTempFile("gen", string, file2);
            this.logCacheMessage(this.getResString("CreatedNewCacheFile") + file.getName(), 5);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            file = null;
        }
        return file;
    }

    private File makeFileFromCacheFilePath(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(this.makeJavaPretty(string));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private String getCachePath() {
        if (this.mCachePath == null) {
            String string = System.getProperty("com.macromedia.generator.installpath");
            String string2 = System.getProperty("file.separator");
            string = string.replace(string2.charAt(0), "/".charAt(0));
            this.mCachePath = string + "/" + "cache" + "/";
            File file = new File(this.makeJavaPretty(this.mCachePath));
            if (!file.exists() && !file.mkdir()) {
                return null;
            }
        }
        return this.mCachePath;
    }

    private File createCacheIndexFile() {
        File file = null;
        try {
            file = this.getCacheIndexFile();
            if (file == null) {
                throw new IOException(this.getResString("CouldntGetIndexFile"));
            }
            if (!file.exists()) {
                if (!GenUtils.createNewFile(file)) {
                    throw new IOException(this.getResString("CreateNewFileFailed"));
                }
            } else {
                file.delete();
                if (!GenUtils.createNewFile(file)) {
                    throw new IOException(this.getResString("CreateNewFileFailed"));
                }
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            file = null;
        }
        catch (SecurityException securityException) {
            System.out.println(securityException);
            file = null;
        }
        return file;
    }

    private File getCacheIndexFile() {
        String string = this.getCachePath();
        if (string == null) {
            return null;
        }
        string = string + "/index.dat";
        File file = new File(this.makeJavaPretty(string));
        return file;
    }

    private synchronized void writeIndex() {
        if (this.mIndex == null || this.mIndex.size() == 0) {
            return;
        }
        this.cleanupCacheDirectory(false);
        try {
            File file = this.createCacheIndexFile();
            if (file == null) {
                throw new IOException(this.getResString("CouldntCreateIndexFile"));
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("Generator Disk Cache Index - DO NOT EDIT!\r\n");
            Enumeration enumeration = this.mIndex.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                GenCacheEntry genCacheEntry = (GenCacheEntry)this.mIndex.get(string);
                if (this.isCacheEntryExpired(genCacheEntry) || !this.verifyCacheFile((String)genCacheEntry.value)) continue;
                fileWriter.write(genCacheEntry.key + "," + genCacheEntry.value + "," + genCacheEntry.size + "," + genCacheEntry.time + "," + genCacheEntry.expires + "\r\n");
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private synchronized void readIndex() {
        if (this.mIndex == null) {
            return;
        }
        File file = this.getCacheIndexFile();
        if (file == null || !file.exists()) {
            return;
        }
        String string = this.getCachePath();
        if (string == null) {
            return;
        }
        File file2 = new File(this.makeJavaPretty(string));
        if (file2 == null) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            try {
                String string2 = bufferedReader.readLine();
                if (!string2.equals("Generator Disk Cache Index - DO NOT EDIT!")) {
                    return;
                }
                string2 = bufferedReader.readLine();
                while (string2 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    GenCacheEntry genCacheEntry = new GenCacheEntry();
                    genCacheEntry.key = stringTokenizer.nextToken();
                    genCacheEntry.value = stringTokenizer.nextToken();
                    genCacheEntry.size = Long.parseLong(stringTokenizer.nextToken());
                    genCacheEntry.time = Long.parseLong(stringTokenizer.nextToken());
                    genCacheEntry.expires = Long.parseLong(stringTokenizer.nextToken());
                    genCacheEntry.hits = 0L;
                    if (!this.isCacheEntryExpired(genCacheEntry) && this.verifyCacheFile((String)genCacheEntry.value) && !this.setCacheEntry(genCacheEntry)) break;
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
                this.cleanupCacheDirectory(false);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
        }
    }

    private boolean verifyCacheFile(String string) {
        File file = new File(string = this.makeJavaPretty(string));
        return file != null && file.exists();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void cleanupCacheDirectory(boolean var1_1) {
        if (this.mIndex == null) {
            return;
        }
        this.logCacheMessage(this.getResString("CleaningCacheDirectory"), 2);
        var2_2 = this.getCacheIndexFile();
        var3_3 = null;
        if (var2_2 != null && var2_2.exists()) {
            var3_3 = var2_2.getPath();
        }
        if ((var4_4 = this.getCachePath()) == null) {
            return;
        }
        var5_5 = new File(this.makeJavaPretty(var4_4));
        if (var5_5 == null) {
            return;
        }
        var6_6 = null;
        if (GenUtils.isJava2()) {
            var6_6 = var5_5.listFiles();
            if (var6_6 == null) {
                return;
            }
        } else {
            var7_7 = var5_5.list();
            if (var7_7 == null) {
                return;
            }
            var6_6 = GenUtils.makeFileArray(var5_5, var7_7);
            if (var6_6 == null) {
                return;
            }
        }
        var7_8 = 0;
        while (var7_8 < Array.getLength(var6_6)) {
            block14: {
                if (var6_6[var7_8] == null) break block14;
                var8_9 = var6_6[var7_8].getPath();
                if (!var1_1 && var3_3 != null && var8_9.equals(var3_3)) break block14;
                var9_10 = true;
                var10_11 = null;
                var11_12 = this.mIndex.elements();
                if (var11_12 != null) ** GOTO lbl40
                return;
lbl-1000:
                // 1 sources

                {
                    var10_11 = (GenCacheEntry)var11_12.nextElement();
                    if (!var10_11.value.equals(var8_9)) continue;
                    if (this.isCacheEntryExpired(var10_11)) break;
                    var9_10 = false;
                    break;
lbl40:
                    // 2 sources

                    ** while (var11_12.hasMoreElements())
                }
lbl41:
                // 3 sources

                if (var9_10) {
                    if (var10_11 != null) {
                        this.removeCacheEntry(var10_11);
                    } else {
                        this.logCacheMessage(this.getResString("DeletingCacheFile") + var6_6[var7_8].toString(), 2);
                        var6_6[var7_8].delete();
                    }
                }
            }
            ++var7_8;
        }
    }

    protected void logCacheMessage(String string, int n) {
        if (this.mLog != null) {
            String string2 = "FileCache: " + string;
            super.logCacheMessage(string2, n);
        }
    }
}

