/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.protocol.fgjdbc;

import com.macromedia.generator.protocol.fgjdbc.FgjdbcCacheEntry;
import java.util.Enumeration;
import java.util.Hashtable;

public class FgjdbcCache
implements Runnable {
    private static int cacheMaxSize = 1000000;
    private static FgjdbcCache cacheInstance = null;
    private int cacheSize = 0;
    private Hashtable cacheTable = new Hashtable();
    private Thread cacheThread = new Thread((Runnable)this, "FgjdbcCache");

    protected FgjdbcCache() {
        this.cacheThread.setDaemon(true);
        this.cacheThread.start();
    }

    protected void finalize() throws Throwable {
    }

    public synchronized String getCacheValue(String string, String string2, String string3, String string4, String string5) {
        String string6 = string + "|" + string2 + "|" + string3 + "|" + string4 + "|" + string5;
        FgjdbcCacheEntry fgjdbcCacheEntry = (FgjdbcCacheEntry)this.cacheTable.get(string6);
        return fgjdbcCacheEntry != null ? fgjdbcCacheEntry.value : null;
    }

    public synchronized void setCacheValue(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        String string7 = string + "|" + string2 + "|" + string3 + "|" + string4 + "|" + string5;
        int n2 = string6.length();
        if (this.cacheSize + n2 < cacheMaxSize && this.getCacheValue(string, string2, string3, string4, string5) == null) {
            FgjdbcCacheEntry fgjdbcCacheEntry = new FgjdbcCacheEntry();
            fgjdbcCacheEntry.key = string7;
            fgjdbcCacheEntry.value = string6;
            fgjdbcCacheEntry.length = n2;
            fgjdbcCacheEntry.expires = System.currentTimeMillis() + (long)n * 1000L;
            this.cacheTable.put(fgjdbcCacheEntry.key, fgjdbcCacheEntry);
            this.cacheSize += n2;
        }
    }

    private synchronized void expireCacheEntries() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.cacheTable.elements();
        while (enumeration.hasMoreElements()) {
            FgjdbcCacheEntry fgjdbcCacheEntry = (FgjdbcCacheEntry)enumeration.nextElement();
            if (fgjdbcCacheEntry.expires >= l) continue;
            this.cacheTable.remove(fgjdbcCacheEntry.key);
            this.cacheSize -= fgjdbcCacheEntry.length;
        }
    }

    public void run() {
        while (this.cacheThread != null) {
            try {
                Thread.sleep(1000L);
                this.expireCacheEntries();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static FgjdbcCache getCache() {
        return cacheInstance;
    }

    static {
        if (cacheInstance == null) {
            cacheInstance = new FgjdbcCache();
        }
    }
}

