/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class GenUtils {
    private static String version = null;
    private static final Object tmpFileLock = new Object();
    private static int counter = -1;

    public static float getJavaVersion() {
        return Float.valueOf(version).floatValue();
    }

    public static String getJavaVersionString() {
        return version;
    }

    public static boolean isJava2() {
        return (double)GenUtils.getJavaVersion() >= 1.2;
    }

    private static void getJavaVersionProp() {
        if (version == null) {
            version = System.getProperty("java.version");
            version = version.substring(0, 3);
        }
    }

    public static Vector hashtableToVector(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        int n = hashtable.size();
        Vector vector = new Vector(n);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2 = null;
        file2 = GenUtils.isJava2() ? File.createTempFile(string, string2, file) : GenUtils.sun_createTempFile(string, string2, file);
        return file2;
    }

    public static boolean createNewFile(File file) throws IOException {
        boolean bl = false;
        if (!GenUtils.isJava2()) {
            return GenUtils.sun_createNewFile(file);
        }
        bl = file.createNewFile();
        return bl;
    }

    public static File getParentFile(File file) {
        File file2 = null;
        if (GenUtils.isJava2()) {
            file2 = file.getParentFile();
        } else {
            String string = file.getParent();
            if (string != null) {
                file2 = new File(string);
            }
        }
        return file2;
    }

    public static File[] makeFileArray(File file, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || file == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public static String replace(String string, String string2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            n = string.indexOf(string2, n2);
            if (n < 0) break;
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(c);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2, string.length()));
        return stringBuffer.toString();
    }

    private static boolean sun_createNewFile(File file) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(file.getPath());
        }
        return GenUtils.createFileExclusively(file);
    }

    public static File sun_createTempFile(String string, String string2, File file) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        String string3 = string2 == null ? ".tmp" : string2;
        Object object = tmpFileLock;
        synchronized (object) {
            File file2;
            if (file == null) {
                throw new IllegalArgumentException("directory is null");
            }
            SecurityManager securityManager = System.getSecurityManager();
            while (!GenUtils.sun_checkAndCreate((file2 = GenUtils.sun_generateFile(string, string3, file)).getPath(), securityManager)) {
            }
            File file3 = file2;
            return file3;
        }
    }

    private static File sun_generateFile(String string, String string2, File file) throws IOException {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return new File(file, string + Integer.toString(++counter) + string2);
    }

    private static boolean sun_checkAndCreate(String string, SecurityManager securityManager) throws IOException {
        if (securityManager != null) {
            try {
                securityManager.checkWrite(string);
            }
            catch (SecurityException securityException) {
                throw new SecurityException("Unable to create temporary file");
            }
        }
        return GenUtils.createFileExclusively(string);
    }

    private static boolean createFileExclusively(File file) {
        return !file.exists();
    }

    private static boolean createFileExclusively(String string) {
        if (string == null) {
            throw new SecurityException("Unable to create temporary file");
        }
        return GenUtils.createFileExclusively(new File(string));
    }

    public static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    static {
        GenUtils.getJavaVersionProp();
    }
}

