// Copyright 2000-2007 Adobe Systems Incorporated.  All rights reserved.

   function receiveArguments()
   {
	  var selection = dw.getSelection();
      var node      = dw.offsetsToNode( selection[0], selection[1] );
	if (!node)
	{
		return false;
	}
	if (node.tagName == undefined)
	{
		return false;
	}
	  
      var imageSrc  = node.getAttribute( "src" );
	  var fullPath = getFullPath(imageSrc);

	  var editorURL="";
	  for (i=0; i < dw.constructor.gMenuIDs.length-1; i++)
	  {
		 if (arguments[0] == dw.constructor.gMenuIDs[i])
			editorURL = dw.constructor.gExternalEditors[i*2 + 1];
	  }

	  // if we open image in FW and FW source is available -> use FW source
	  var useFireworks = (editorURL != "" && editorURL.toLowerCase().indexOf("fireworks") >= 0);
      var notesFile = MMNotes.open(fullPath);
      var sourceFilePath = "";
      var FWPath = "";
      if (notesFile)
      {
        if(useFireworks)
            FWPath = MMNotes.get(notesFile, "fw_source");

        sourceFilePath = (FWPath != "" ? FWPath : MMNotes.get(notesFile, "FilePathSrc"));
		MMNotes.close(notesFile);
		if (sourceFilePath)
		{
			fullPath = dw.resolveOriginalAssetFileURLToAbsoluteLocalFilePath(sourceFilePath, fullPath);
		}
      }

	  if (editorURL != "")
	  {
		 dw.openWithImageEditor(fullPath, editorURL);
		 return true;
	  }
	  else
	  {
	     dw.openWithBrowseDialog(fullPath);
		 return true;
	  }
   }

   function canAcceptCommand()
   {
      var selection = dw.getSelection();
      var node      = dw.offsetsToNode( selection[0], selection[1] );
	if (!node)
	{
		return false;
	}
	if (node.tagName == undefined)
	{
		return false;
	}
      var imageSrc  = node.getAttribute( "src" );
      var fullPath = getFullPath(imageSrc);
	  if (selection && node && imageSrc && fullPath)
	  {
		  var notesFile = MMNotes.open(fullPath);
	      var sourceImageFilePath = "";
	      if (notesFile)
	      {
	      	// Photoshop file
	        sourceImageFilePath = MMNotes.get(notesFile, "FilePathSrc");
        	if (sourceImageFilePath.length == 0)
        	{
        		// Fireworks file
        		sourceImageFilePath = MMNotes.get(notesFile, "fw_source");
        	}
			MMNotes.close(notesFile);
			if (sourceImageFilePath)
			{
				return true;
			}
	      }
	  }
 
      return false;
   }

   function getDynamicContent()
   {
      var selection = dw.getSelection();
      var node      = dw.offsetsToNode( selection[0], selection[1] );
	if (!node)
	{
		return false;
	}
	if (node.tagName == undefined)
	{
		return false;
	}
      var imageSrc  = node.getAttribute( "src" );
	  var fullPath = getFullPath(imageSrc);
      var hasSourceImage = false;

      if (!imageSrc)	// No source, no menu items.
        return null;
	
	  var notesFile = MMNotes.open(fullPath);
      var sourceImageFilePath = "";
      if (notesFile)
      {
      	// Photoshop file
        sourceImageFilePath = MMNotes.get(notesFile, "FilePathSrc");
        if (sourceImageFilePath.length == 0)
        {
        	// Fireworks file
        	sourceImageFilePath = MMNotes.get(notesFile, "fw_source");
        }
		MMNotes.close(notesFile);
		if (sourceImageFilePath)
		{
			fullPath = sourceImageFilePath;
			hasSourceImage = true;
		}
      }

      dw.constructor.gPrimaryEditorName = "";
	  dw.constructor.gPrimaryEditorURL = "";
      if (hasSourceImage)
      {
		  // get the primary external editor for the selected item
		  var primaryEditorArray = dw.getPrimaryExtensionEditor(fullPath);
		  if (primaryEditorArray.length > 1)
		  {
		  	dw.constructor.gPrimaryEditorName = primaryEditorArray[0];
		  	dw.constructor.gPrimaryEditorURL = primaryEditorArray[1];
		  }
	  
		// get the external editors for the selected item
        // suppress the photoshop item for non PS-files because they have different entries in the design notes
          var isPSfile = (fullPath.length > 4 && fullPath.substr(fullPath.length-4,4).toLowerCase() == ".psd");
		  var externalEditorArray = dw.getExtensionEditorList(fullPath);
		  
		  if (externalEditorArray.length <= 1)
		  	dw.constructor.gExternalEditors = new Array("");
		  else if (externalEditorArray.length == 2 && dw.constructor.gPrimaryEditorName != "")
		  	dw.constructor.gExternalEditors = new Array("");
		  else
		  {
		    dw.constructor.gExternalEditors = new Array(externalEditorArray.length-2);
			var index=0;
		  	for (i=0; i < externalEditorArray.length; i++)
		  	{
				// don't add the primary editor to the list of editors
			    if (externalEditorArray[i] == dw.constructor.gPrimaryEditorName)
				   i++;
				else
					{
					if(!isPSfile && externalEditorArray[i].toLowerCase().indexOf("photoshop") >= 0)
					    dw.constructor.gExternalEditors.pop();
					else
    					dw.constructor.gExternalEditors[index++] = externalEditorArray[i];
					}
		  	}
		  }
      }
	  // now put the primary editor at first
	  if (dw.constructor.gPrimaryEditorName.length > 0)
	  {
	  	if (dw.constructor.gExternalEditors.length == 1)
	  	{
	  		dw.constructor.gExternalEditors = new Array();
	  	}
	  	dw.constructor.gExternalEditors.unshift(dw.constructor.gPrimaryEditorURL);
	  	dw.constructor.gExternalEditors.unshift(dw.constructor.gPrimaryEditorName);
	  } else
	  {
	  	dw.constructor.gExternalEditors = new Array();
	  }
	  
	  // put the names of the editors in the menu
	  var menuItems;
	  var i;
	  if (dw.constructor.gExternalEditors.length < 2)
	  {
	    // we should have pairs... if we don't then just add Browse... to the list
		menuItems = new Array(1);
		dw.constructor.gMenuIDs = new Array(1);
		i=0;
	  }
	  else
	  {
	  	// we have pairs of editor names and editor paths
		// put the names in the menu and remember the paths
		menuItems = new Array(dw.constructor.gExternalEditors.length/2 + 1);
	    dw.constructor.gMenuIDs = new Array(dw.constructor.gExternalEditors.length/2 + 1);
		for (i=0; i < dw.constructor.gExternalEditors.length/2; i++)
		{
			// add non-primary editors to the list of editors
			dw.constructor.gMenuIDs[i] = "Editor" + i;
			menuItems[i] = dw.constructor.gExternalEditors[i*2] + ";id='" + escQuotes(dw.constructor.gMenuIDs[i]) + "'";
		}
	  }

	  // always add Browse... to the bottom of the list
	  dw.constructor.gMenuIDs[i] = "ExtEd:Browse";
	  menuItems[i] = MENU_Browse+";id='" + escQuotes(dw.constructor.gMenuIDs[i]) + "'";

	  return menuItems;
   }
