package deadbeef.Filters;

/**
 * Bell filter.
 */
final class BellFilter implements Filter {
	
	public float getRadius() {
		return 1.5f;
	}

	public final float value(float value) {
		if (value < 0.0f) 
			value = - value;
		
		if (value < 0.5f) 
			return 0.75f - (value * value);
		if (value < 1.5f) {
			value = value - 1.5f;
			return 0.5f * (value * value);
		}
		return 0.0f;
	}
}
