/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.resolver;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xsl.core.internal.Messages;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.core.resolver.XSLVersionHandler;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResolverExtension
implements URIResolverExtension {
    private static final Double DEFAULT_XSLT_VERSION = 1.0;
    private static final String XSLT_STYLESHEET = "stylesheet";
    private static final String XSLT_TEMPLATE = "template";
    private static final String XSLT_VERSION = "version";
    private boolean initialised;
    private String xslt_1_0_fileURL;
    private String xslt_2_0_fileURL;

    public String resolve(IFile file, String baseLocation, String publicId, String systemId) {
        if (!"http://www.w3.org/1999/XSL/Transform".equals(publicId)) {
            return null;
        }
        String version = null;
        if (file != null) {
            version = this.peekVersionAttributeFromSSE(file);
        }
        if (version == null) {
            version = this.peekVersionFromFile(file, baseLocation);
        }
        if (version == null) {
            return null;
        }
        Double versionNumber = null;
        try {
            versionNumber = Double.valueOf(version);
        }
        catch (Throwable throwable) {}
        if (versionNumber == null) {
            versionNumber = DEFAULT_XSLT_VERSION;
        }
        int intVersion = versionNumber.intValue();
        this.checkInitialised();
        if (intVersion == 1) {
            return this.xslt_1_0_fileURL;
        }
        if (intVersion == 2) {
            return this.xslt_2_0_fileURL;
        }
        return null;
    }

    private void checkInitialised() {
        if (!this.initialised) {
            this.initialised = true;
            try {
                URL pluginURL = FileLocator.find((Bundle)XSLCorePlugin.getDefault().getBundle(), (IPath)new Path("/xslt-schemas/xslt-1.0.xsd"), null);
                this.xslt_1_0_fileURL = FileLocator.toFileURL((URL)pluginURL).toExternalForm();
                pluginURL = FileLocator.find((Bundle)XSLCorePlugin.getDefault().getBundle(), (IPath)new Path("/xslt-schemas/xslt-2.0.xsd"), null);
                this.xslt_2_0_fileURL = FileLocator.toFileURL((URL)pluginURL).toExternalForm();
            }
            catch (IOException e) {
                XSLCorePlugin.log(e);
            }
        }
    }

    private String peekVersionFromFile(IFile file, String baseLocation) {
        XSLVersionHandler handler = new XSLVersionHandler();
        try {
            handler.parseContents(file != null ? this.createInputSource(file) : this.createInputSource(baseLocation));
        }
        catch (SAXException se) {
            XSLCorePlugin.log(se);
        }
        catch (IOException ioe) {
            XSLCorePlugin.log(new CoreException(XSLCorePlugin.newErrorStatus("Can't parse XSL document", ioe)));
        }
        catch (ParserConfigurationException pce) {
            String message = Messages.XSLCorePlugin_parserConfiguration;
            XSLCorePlugin.log((IStatus)new Status(4, "org.eclipse.wst.xsl.core", 0, message, (Throwable)pce));
            throw new RuntimeException(message);
        }
        catch (CoreException ce) {
            XSLCorePlugin.log(ce);
        }
        String versionX = handler.getVersionAttribute();
        return versionX;
    }

    private String peekVersionAttributeFromSSE(IFile file) {
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager != null) {
            String id = manager.calculateId(file);
            IStructuredModel model = manager.getExistingModelForRead((Object)id);
            try {
                IDOMDocument doc;
                if (model instanceof IDOMModel && (doc = ((IDOMModel)model).getDocument()) != null && doc.getDocumentElement() != null) {
                    Element documentElement = doc.getDocumentElement();
                    if (XSLT_STYLESHEET.equals(documentElement.getLocalName()) || XSLT_TEMPLATE.equals(documentElement.getLocalName())) {
                        String string = documentElement.getAttribute(XSLT_VERSION);
                        return string;
                    }
                    return "";
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return null;
    }

    private InputSource createInputSource(String systemId) throws CoreException {
        return new InputSource(systemId);
    }

    private InputSource createInputSource(IFile file) throws CoreException {
        InputSource src = new InputSource(file.getContents());
        src.setSystemId(file.getLocationURI().toString());
        return src;
    }
}

