/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.text.java.hover.SourceViewerInformationControl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

class JavaEditorAppearanceConfigurationBlock
extends AbstractConfigurationBlock {
    private final String[][] fAppearanceColorListModel;
    private List fAppearanceColorList;
    private ColorSelector fAppearanceColorEditor;
    private Button fAppearanceColorDefault;
    private FontMetrics fFontMetrics;

    public JavaEditorAppearanceConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        super(store, mainPreferencePage);
        String[][] stringArrayArray = new String[6][];
        String[] stringArray = new String[3];
        stringArray[0] = PreferencesMessages.JavaEditorPreferencePage_matchingBracketsHighlightColor2;
        stringArray[1] = "matchingBracketsColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = PreferencesMessages.JavaEditorPreferencePage_backgroundForMethodParameters;
        stringArray2[1] = "content_assist_parameters_background";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = PreferencesMessages.JavaEditorPreferencePage_foregroundForMethodParameters;
        stringArray3[1] = "content_assist_parameters_foreground";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = PreferencesMessages.JavaEditorPreferencePage_backgroundForCompletionReplacement;
        stringArray4[1] = "content_assist_completion_replacement_background";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = PreferencesMessages.JavaEditorPreferencePage_foregroundForCompletionReplacement;
        stringArray5[1] = "content_assist_completion_replacement_foreground";
        stringArrayArray[4] = stringArray5;
        stringArrayArray[5] = new String[]{PreferencesMessages.JavaEditorPreferencePage_sourceHoverBackgroundColor, "sourceHoverBackgroundColor", "sourceHoverBackgroundColor.SystemDefault"};
        this.fAppearanceColorListModel = stringArrayArray;
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "matchingBracketsColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "matchingBrackets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.jdt.quickassist.lightbulb"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "subWordNavigation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "handleTemporaryProblems"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.jdt.ui.editor.showSegments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_completion_replacement_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_completion_replacement_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "sourceHoverBackgroundColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "sourceHoverBackgroundColor.SystemDefault"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite composite = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createHeader(composite);
        this.createAppearancePage(composite);
        scrolled.setContent((Control)composite);
        Point size = composite.computeSize(-1, -1);
        scrolled.setMinSize(size.x, size.y);
        return scrolled;
    }

    private void createHeader(Composite contents) {
        final Shell shell = contents.getShell();
        String text = PreferencesMessages.JavaEditorPreferencePage_link;
        Link link = new Link(contents, 0);
        link.setText(text);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        link.setToolTipText(PreferencesMessages.JavaEditorPreferencePage_link_tooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        this.addFiller(contents);
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    protected int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    protected int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String label = PreferencesMessages.JavaEditorPreferencePage_subWordNavigation;
        this.addCheckBox(appearanceComposite, label, "subWordNavigation", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_analyseAnnotationsWhileTyping;
        this.addCheckBox(appearanceComposite, label, "handleTemporaryProblems", 0);
        String text = PreferencesMessages.SmartTypingConfigurationBlock_annotationReporting_link;
        this.addLink(appearanceComposite, text, 20);
        Label spacer = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        spacer.setLayoutData((Object)gd);
        label = PreferencesMessages.JavaEditorPreferencePage_highlightMatchingBrackets;
        this.addCheckBox(appearanceComposite, label, "matchingBrackets", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_quickassist_lightbulb;
        this.addCheckBox(appearanceComposite, label, "org.eclipse.jdt.quickassist.lightbulb", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_showJavaElementOnly;
        this.addCheckBox(appearanceComposite, label, "org.eclipse.jdt.ui.editor.showSegments", 0);
        Label l = new Label(appearanceComposite, 16384);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(PreferencesMessages.JavaEditorPreferencePage_appearanceOptions);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(12);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(PreferencesMessages.JavaEditorPreferencePage_color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorDefault.getSelection();
                JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String key = JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    JavaEditorAppearanceConfigurationBlock.this.getPreferenceStore().setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText(PreferencesMessages.JavaEditorPreferencePage_systemDefault);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(colorDefaultSelectionListener);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JavaEditorAppearanceConfigurationBlock.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String key = JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorAppearanceConfigurationBlock.this.getPreferenceStore(), (String)key, (RGB)JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    private void addLink(Composite composite, String text, int indent) {
        final Link link = new Link(composite, 0);
        link.setText(text);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, null);
            }
        });
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        if (i == -1) {
            return;
        }
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[i][2]);
    }

    private void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.getPreferenceStore().getBoolean(systemDefaultKey);
            this.fAppearanceColorDefault.setSelection(systemDefault);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
        }
    }

    public void initialize() {
        super.initialize();
        this.initializeDefaultColors();
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorList != null && !JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorList.isDisposed()) {
                    JavaEditorAppearanceConfigurationBlock.this.fAppearanceColorList.select(0);
                    JavaEditorAppearanceConfigurationBlock.this.handleAppearanceColorListSelection();
                }
            }
        });
    }

    private void initializeDefaultColors() {
        if (this.getPreferenceStore().getBoolean("sourceHoverBackgroundColor.SystemDefault")) {
            Display display = this.fAppearanceColorList.getDisplay();
            RGB rgb = SourceViewerInformationControl.getVisibleBackgroundColor(display);
            if (rgb == null) {
                rgb = display.getSystemColor(29).getRGB();
            }
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"sourceHoverBackgroundColor", (RGB)rgb);
        }
    }

    public void performDefaults() {
        super.performDefaults();
        this.initializeDefaultColors();
        this.handleAppearanceColorListSelection();
    }

    protected void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }
}

