/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.operations.AbstractProvisioningOperation;
import org.eclipse.epp.internal.mpc.ui.operations.FeatureDescriptor;
import org.eclipse.epp.internal.mpc.ui.operations.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileChangeOperationComputer
extends AbstractProvisioningOperation {
    private final OperationType operationType;
    private final List<FeatureDescriptor> featureDescriptors;
    private ProfileChangeOperation operation;
    private IInstallableUnit[] ius;
    private final ResolutionStrategy resolutionStrategy;
    private final URI dependenciesRepository;

    public ProfileChangeOperationComputer(OperationType operationType, Collection<CatalogItem> items, Set<FeatureDescriptor> featureDescriptors, URI dependenciesRepository, ResolutionStrategy resolutionStrategy) {
        super(items);
        if (featureDescriptors == null || featureDescriptors.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (operationType == null) {
            throw new IllegalArgumentException();
        }
        if (resolutionStrategy == null) {
            throw new IllegalArgumentException();
        }
        this.featureDescriptors = new ArrayList<FeatureDescriptor>(featureDescriptors);
        this.operationType = operationType;
        this.resolutionStrategy = resolutionStrategy;
        this.dependenciesRepository = dependenciesRepository;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.ProvisioningOperation_configuringProvisioningOperation, (int)1000);
            try {
                this.ius = this.computeInstallableUnits(monitor.newChild(500));
                this.checkCancelled((IProgressMonitor)monitor);
                switch (this.operationType) {
                    case INSTALL: {
                        this.operation = this.resolveInstall((IProgressMonitor)monitor.newChild(500), this.ius, this.repositoryLocations.toArray(new URI[0]));
                        break;
                    }
                    case UNINSTALL: {
                        this.operation = this.resolveUninstall((IProgressMonitor)monitor.newChild(500), this.ius, this.repositoryLocations.toArray(new URI[0]));
                        break;
                    }
                    case UPDATE: {
                        this.operation = this.resolveUpdate((IProgressMonitor)monitor.newChild(500), this.computeInstalledIus(this.ius), this.repositoryLocations.toArray(new URI[0]));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(this.operationType.name());
                    }
                }
                this.checkCancelled((IProgressMonitor)monitor);
            }
            finally {
                monitor.done();
            }
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private IInstallableUnit[] computeInstalledIus(IInstallableUnit[] ius) {
        ArrayList<IInstallableUnit> installedIus = new ArrayList<IInstallableUnit>(ius.length);
        Map<String, IInstallableUnit> iUsById = MarketplaceClientUi.computeInstalledIUsById((IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            IInstallableUnit installedIu = iUsById.get(iu.getId());
            installedIus.add(installedIu);
            ++n2;
        }
        return installedIus.toArray(new IInstallableUnit[installedIus.size()]);
    }

    public ProfileChangeOperation getOperation() {
        return this.operation;
    }

    public IInstallableUnit[] getIus() {
        return this.ius;
    }

    private ProfileChangeOperation resolveInstall(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        return this.resolve(monitor, new ProfileChangeOperationFactory(){

            @Override
            public ProfileChangeOperation create(List<IInstallableUnit> ius) throws CoreException {
                return ProfileChangeOperationComputer.this.provisioningUI.getInstallOperation(ius, null);
            }
        }, ius, repositories);
    }

    private ProfileChangeOperation resolveUninstall(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        return this.resolve(monitor, new ProfileChangeOperationFactory(){

            @Override
            public ProfileChangeOperation create(List<IInstallableUnit> ius) throws CoreException {
                return ProfileChangeOperationComputer.this.provisioningUI.getUninstallOperation(ius, null);
            }
        }, ius, repositories);
    }

    private ProfileChangeOperation resolveUpdate(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        return this.resolve(monitor, new ProfileChangeOperationFactory(){

            @Override
            public ProfileChangeOperation create(List<IInstallableUnit> ius) throws CoreException {
                return ProfileChangeOperationComputer.this.provisioningUI.getUpdateOperation(ius, null);
            }
        }, ius, repositories);
    }

    private ProfileChangeOperation resolve(IProgressMonitor monitor, ProfileChangeOperationFactory operationFactory, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        List<IInstallableUnit> installableUnits = Arrays.asList(ius);
        ArrayList<ResolutionStrategy> strategies = new ArrayList<ResolutionStrategy>(2);
        switch (this.resolutionStrategy) {
            case FALLBACK_STRATEGY: {
                strategies.add(ResolutionStrategy.SELECTED_REPOSITORIES);
                strategies.add(ResolutionStrategy.ALL_REPOSITORIES);
                break;
            }
            default: {
                strategies.add(this.resolutionStrategy);
            }
        }
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        URI[] knownRepositories = repositoryTracker.getKnownRepositories(session);
        ProfileChangeOperation operation = null;
        int workPerStrategy = 1000;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(strategies.size() * 1000));
        HashSet<URI> previousRepositoryLocations = null;
        for (ResolutionStrategy strategy : strategies) {
            HashSet<URI> repositoryLocations = new HashSet<URI>(Arrays.asList(repositories));
            if (strategy == ResolutionStrategy.SELECTED_REPOSITORIES) {
                repositoryLocations.addAll(Arrays.asList(repositories));
            }
            if (this.dependenciesRepository != null) {
                repositoryLocations.add(this.dependenciesRepository);
            }
            if (strategy == ResolutionStrategy.ALL_REPOSITORIES && !repositoryLocations.isEmpty()) {
                repositoryLocations.addAll(Arrays.asList(knownRepositories));
            }
            if (repositoryLocations.equals(previousRepositoryLocations)) continue;
            operation = operationFactory.create(installableUnits);
            if (!repositoryLocations.isEmpty()) {
                URI[] locations = repositoryLocations.toArray(new URI[repositoryLocations.size()]);
                operation.getProvisioningContext().setMetadataRepositories(locations);
                operation.getProvisioningContext().setArtifactRepositories(locations);
            }
            this.resolveModal((IProgressMonitor)subMonitor.newChild(1000), operation);
            if (operation.getResolutionResult() != null && operation.getResolutionResult().getSeverity() != 4) break;
            previousRepositoryLocations = repositoryLocations;
        }
        return operation;
    }

    public void resolveModal(IProgressMonitor monitor, ProfileChangeOperation operation) throws CoreException {
        operation.resolveModal((IProgressMonitor)new SubProgressMonitor(monitor, this.items.size()));
    }

    public IInstallableUnit[] computeInstallableUnits(SubMonitor monitor) throws CoreException {
        try {
            monitor.setWorkRemaining(100);
            List<IMetadataRepository> repositories = this.addRepositories(monitor.newChild(50));
            List<IInstallableUnit> installableUnits = this.queryInstallableUnits(monitor.newChild(50), repositories);
            this.checkForUnavailable(installableUnits);
            this.pruneUnselected(installableUnits);
            if (this.operationType != OperationType.UNINSTALL) {
                this.pruneOlderVersions(installableUnits);
            }
            IInstallableUnit[] iInstallableUnitArray = installableUnits.toArray(new IInstallableUnit[installableUnits.size()]);
            return iInstallableUnitArray;
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epp.mpc.ui", Messages.ProvisioningOperation_unexpectedErrorUrl, (Throwable)e));
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epp.mpc.ui", Messages.ProvisioningOperation_unexpectedErrorUrl, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private void pruneOlderVersions(List<IInstallableUnit> installableUnits) throws CoreException {
        if (!installableUnits.isEmpty()) {
            Map<String, IInstallableUnit> iUsById = MarketplaceClientUi.computeInstalledIUsById((IProgressMonitor)new NullProgressMonitor());
            Iterator<IInstallableUnit> it = installableUnits.iterator();
            while (it.hasNext()) {
                Version installableVersion;
                Version installedVersion;
                IInstallableUnit iu = it.next();
                IInstallableUnit installedIu = iUsById.get(iu.getId());
                if (installedIu == null || (installedVersion = installedIu.getVersion()).compareTo((Object)(installableVersion = iu.getVersion())) < 0) continue;
                it.remove();
            }
            if (installableUnits.isEmpty()) {
                throw new CoreException((IStatus)new Status(1, "org.eclipse.epp.mpc.ui", Messages.ProvisioningOperation_nothingToUpdate));
            }
        }
    }

    private void pruneUnselected(List<IInstallableUnit> installableUnits) {
        HashSet<String> installableFeatureIds = new HashSet<String>();
        for (FeatureDescriptor descriptor : this.featureDescriptors) {
            installableFeatureIds.add(descriptor.getId());
        }
        Iterator<IInstallableUnit> it = installableUnits.iterator();
        while (it.hasNext()) {
            IInstallableUnit iu = it.next();
            if (installableFeatureIds.contains(iu.getId())) continue;
            it.remove();
        }
    }

    private void checkForUnavailable(List<IInstallableUnit> installableUnits) throws CoreException {
        HashSet<String> foundIds = new HashSet<String>();
        for (IInstallableUnit unit : installableUnits) {
            foundIds.add(unit.getId());
        }
        HashSet<String> installFeatureIds = new HashSet<String>();
        for (FeatureDescriptor descriptor : this.featureDescriptors) {
            installFeatureIds.add(descriptor.getId());
        }
        String message = "";
        String detailedMessage = "";
        for (CatalogItem descriptor : this.items) {
            StringBuilder unavailableIds = null;
            for (String id : this.getFeatureIds(descriptor)) {
                if (foundIds.contains(id) || !installFeatureIds.contains(id)) continue;
                if (unavailableIds == null) {
                    unavailableIds = new StringBuilder();
                } else {
                    unavailableIds.append(Messages.ProvisioningOperation_commaSeparator);
                }
                unavailableIds.append(id);
            }
            if (unavailableIds == null) continue;
            if (message.length() > 0) {
                message = String.valueOf(message) + Messages.ProvisioningOperation_commaSeparator;
            }
            message = String.valueOf(message) + descriptor.getName();
            if (detailedMessage.length() > 0) {
                detailedMessage = String.valueOf(detailedMessage) + Messages.ProvisioningOperation_commaSeparator;
            }
            detailedMessage = String.valueOf(detailedMessage) + NLS.bind((String)Messages.ProvisioningOperation_unavailableFeatures, (Object[])new Object[]{descriptor.getName(), unavailableIds.toString(), descriptor.getSiteUrl()});
        }
        if (message.length() > 0) {
            final boolean[] okayToProceed = new boolean[1];
            final String finalMessage = message;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    okayToProceed[0] = MessageDialog.openQuestion((Shell)WorkbenchUtil.getShell(), (String)Messages.ProvisioningOperation_proceedQuestion, (String)NLS.bind((String)Messages.ProvisioningOperation_unavailableConnectors_proceedQuestion, (Object[])new Object[]{finalMessage}));
                }
            });
            if (!okayToProceed[0]) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.ProvisioningOperation_unavailableConnectors, (Object)detailedMessage), null));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        INSTALL,
        UPDATE,
        UNINSTALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ProfileChangeOperationFactory {
        public ProfileChangeOperation create(List<IInstallableUnit> var1) throws CoreException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResolutionStrategy {
        ALL_REPOSITORIES,
        SELECTED_REPOSITORIES,
        FALLBACK_STRATEGY;

    }
}

