/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.commands.MarketplaceWizardCommand;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceBrowserIntegration
implements LocationListener,
OpenWindowListener {
    private static final String UTF_8 = "UTF-8";
    private static final String PARAM_SPLIT_REGEX = "&";
    private static final String MPC_INSTALL_URI = "/mpc/install?";
    private static final String EQUALS_REGEX = "=";
    private static final String MPC_STATE = "mpc_state";
    private static final String MPC_INSTALL = "mpc_install";
    private final List<CatalogDescriptor> catalogDescriptors;
    private final CatalogDescriptor catalogDescriptor;

    public MarketplaceBrowserIntegration(List<CatalogDescriptor> catalogDescriptors, CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptors == null || catalogDescriptors.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.catalogDescriptors = new ArrayList<CatalogDescriptor>(catalogDescriptors);
        this.catalogDescriptor = catalogDescriptor;
    }

    public void open(WindowEvent event) {
    }

    public void changing(LocationEvent event) {
        String suffix;
        String catalogLocation;
        if (!event.doit) {
            return;
        }
        URL url = this.catalogDescriptor.getUrl();
        try {
            catalogLocation = url.toURI().toString();
        }
        catch (URISyntaxException e) {
            return;
        }
        if (catalogLocation.endsWith("/")) {
            catalogLocation = catalogLocation.substring(0, catalogLocation.length() - 1);
        }
        if (event.location.startsWith(catalogLocation) && (suffix = event.location.substring(catalogLocation.length())).startsWith(MPC_INSTALL_URI) && suffix.length() > MPC_INSTALL_URI.length()) {
            String[] args = suffix.substring(MPC_INSTALL_URI.length()).split(PARAM_SPLIT_REGEX);
            String installId = null;
            String mpcState = null;
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                String[] parts = arg.split(EQUALS_REGEX);
                if (parts.length == 2) {
                    String key = parts[0];
                    if (MPC_INSTALL.equals(key)) {
                        installId = parts[1];
                    } else if (MPC_STATE.equals(key)) {
                        mpcState = parts[1];
                    }
                }
                ++n2;
            }
            if (installId != null) {
                event.doit = false;
                MarketplaceWizardCommand command = new MarketplaceWizardCommand();
                command.setCatalogDescriptors(this.catalogDescriptors);
                command.setSelectedCatalogDescriptor(this.catalogDescriptor);
                try {
                    if (mpcState != null) {
                        command.setWizardState(URLDecoder.decode(mpcState, UTF_8));
                    }
                    HashMap<String, Operation> nodeIdToOperation = new HashMap<String, Operation>();
                    nodeIdToOperation.put(URLDecoder.decode(installId, UTF_8), Operation.INSTALL);
                    command.setOperationByNodeId(nodeIdToOperation);
                }
                catch (UnsupportedEncodingException e1) {
                    throw new IllegalStateException(e1);
                }
                try {
                    command.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    IStatus status = MarketplaceClientUi.computeStatus(new InvocationTargetException(e), Messages.MarketplaceBrowserIntegration_cannotOpenMarketplaceWizard);
                    StatusManager.getManager().handle(status, 7);
                }
            }
        }
    }

    public void changed(LocationEvent event) {
    }
}

