/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Document;

public class FnCollection
extends Function {
    private static Collection _expected_args = null;
    public static final String DEFAULT_COLLECTION_URI = "http://www.w3.org/2005/xpath-functions/collection/default";

    public FnCollection() {
        super(new QName("collection"), 0, 1);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnCollection.collection(args, this.dynamic_context());
    }

    public static ResultSequence collection(Collection args, DynamicContext dc) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnCollection.expected_args());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = null;
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (!argiter.hasNext()) {
            return FnCollection.getCollection(DEFAULT_COLLECTION_URI, dc);
        }
        arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return ResultSequenceFactory.create_new();
        }
        String uri = ((XSString)arg1.first()).value();
        try {
            new URI(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw DynamicError.doc_not_found(null);
        }
        if (uri.indexOf(":") < 0) {
            throw DynamicError.invalidCollectionArgument();
        }
        URI resolved = dc.resolve_uri(uri);
        if (resolved == null) {
            throw DynamicError.invalid_doc(null);
        }
        rs = FnCollection.getCollection(uri, dc);
        if (rs.empty()) {
            throw DynamicError.doc_not_found(null);
        }
        return rs;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
        }
        return _expected_args;
    }

    private static ResultSequence getCollection(String uri, DynamicContext dc) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        Map collectionMap = dc.get_collections();
        List docList = (List)collectionMap.get(uri);
        int i = 0;
        while (i < docList.size()) {
            Document doc = (Document)docList.get(i);
            rs.add(new DocType(doc));
            ++i;
        }
        return rs;
    }
}

