/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class XSBase64Binary
extends CtrType
implements CmpEq {
    private static final String XS_BASE64_BINARY = "xs:base64Binary";
    private String _value;

    public XSBase64Binary(String x) {
        this._value = x;
    }

    public XSBase64Binary() {
        this(null);
    }

    public String string_type() {
        return XS_BASE64_BINARY;
    }

    public String type_name() {
        return "base64Binary";
    }

    public String string_value() {
        return this._value;
    }

    public String value() {
        return this._value;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBoolean || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        String str_value = aat.string_value();
        byte[] decodedValue = Base64.decode((String)str_value);
        if (aat instanceof XSHexBinary) {
            decodedValue = HexBin.decode((String)str_value);
            decodedValue = Base64.encode((byte[])decodedValue).getBytes();
        } else {
            decodedValue = str_value.getBytes();
        }
        if (decodedValue == null) {
            throw DynamicError.throw_type_error();
        }
        rs.add(new XSBase64Binary(new String(decodedValue)));
        return rs;
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        return aat instanceof XSBase64Binary || aat instanceof XSHexBinary;
    }

    public boolean eq(AnyType arg, DynamicContext context) throws DynamicError {
        String valToCompare = arg.string_value();
        byte[] value1 = Base64.decode((String)this._value);
        byte[] value2 = Base64.decode((String)valToCompare);
        if (value2 == null) {
            return false;
        }
        int len = value1.length;
        if (len != value2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (value1[i] != value2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

