/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.recording;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEventListener;
import org.eclipse.epp.usagedata.internal.gathering.services.UsageDataService;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecorder;
import org.eclipse.epp.usagedata.internal.recording.settings.UsageDataRecordingSettings;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadManager;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class UsageDataRecordingActivator
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.epp.usagedata.recording";
    private static UsageDataRecordingActivator plugin;
    private UploadManager uploadManager;
    private UsageDataRecordingSettings settings;
    private UsageDataRecorder usageDataRecorder;
    private ServiceTracker usageDataServiceTracker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.uploadManager = new UploadManager();
        this.settings = new UsageDataRecordingSettings();
        this.usageDataRecorder = new UsageDataRecorder();
        this.usageDataRecorder.start();
        this.usageDataServiceTracker = new ServiceTracker(context, UsageDataService.class.getName(), null);
        this.usageDataServiceTracker.open();
        this.getUsageDataService().addUsageDataEventListener((UsageDataEventListener)this.usageDataRecorder);
    }

    public void stop(BundleContext context) throws Exception {
        this.usageDataRecorder.stop();
        this.getUsageDataService().removeUsageDataEventListener((UsageDataEventListener)this.usageDataRecorder);
        this.settings.dispose();
        plugin = null;
        super.stop(context);
    }

    private UsageDataService getUsageDataService() {
        return (UsageDataService)this.usageDataServiceTracker.getService();
    }

    public static UsageDataRecordingActivator getDefault() {
        return plugin;
    }

    public UsageDataRecordingSettings getSettings() {
        return this.settings;
    }

    public void log(int status, String message, Object ... arguments) {
        this.log(status, null, message, arguments);
    }

    public void log(int status, Exception exception, String message, Object ... arguments) {
        this.log(status, exception, String.format(message, arguments));
    }

    public void log(int status, Exception e, String message) {
        this.getLog().log((IStatus)new Status(status, PLUGIN_ID, message, (Throwable)e));
    }

    public void log(Status status) {
        this.getLog().log((IStatus)status);
    }

    public void earlyStartup() {
    }

    public UploadManager getUploadManager() {
        return this.uploadManager;
    }
}

