/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.util.Calendar;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.commons.core.Messages;
import org.eclipse.osgi.util.NLS;

public class DateUtil {
    private static long MILLIS_SECOND = 1000L;
    private static long MILLIS_MINUTE = 60L * MILLIS_SECOND;
    private static long MILLIS_HOUR = 60L * MILLIS_MINUTE;
    private static long MILLIS_DAY = 24L * MILLIS_HOUR;
    private static long MILLIS_WEEK = 7L * MILLIS_DAY;
    private static long MILLIS_MONTH = 4L * MILLIS_WEEK;

    public static String getIsoFormattedDate(Calendar calendar) {
        try {
            int monthInt = calendar.get(2) + 1;
            String month = "" + monthInt;
            if (monthInt < 10) {
                month = "0" + month;
            }
            int dateInt = calendar.get(5);
            String date = "" + dateInt;
            if (dateInt < 10) {
                date = "0" + date;
            }
            return String.valueOf(calendar.get(1)) + "-" + month + "-" + date;
        }
        catch (Exception exception) {
            return "<unresolved date>";
        }
    }

    public static String getIsoFormattedDateTime(Calendar calendar) {
        return String.valueOf(DateUtil.getIsoFormattedDate(calendar)) + "T" + calendar.get(10) + "-" + calendar.get(12) + "-" + calendar.get(13);
    }

    public static String getFormattedDurationShort(long duration, boolean includeSeconds) {
        if (duration <= 0L) {
            return "00:00";
        }
        long totalSeconds = duration / 1000L;
        long remainderSeconds = totalSeconds % 60L;
        long totalMinutes = totalSeconds / 60L;
        long remainderMinutes = totalMinutes % 60L;
        long totalHours = totalMinutes / 60L;
        StringBuffer sb = new StringBuffer(8);
        if (totalHours < 10L) {
            sb.append("0");
        }
        sb.append(totalHours);
        sb.append(":");
        if (remainderMinutes < 10L) {
            sb.append("0");
        }
        sb.append(remainderMinutes);
        if (includeSeconds) {
            sb.append(":");
            if (remainderSeconds < 10L) {
                sb.append("0");
            }
            sb.append(remainderSeconds);
        }
        return sb.toString();
    }

    public static String getFormattedDurationShort(long duration) {
        return DateUtil.getFormattedDurationShort(duration, false);
    }

    @Deprecated
    public static String getFormattedDuration(long duration, boolean includeSeconds) {
        long seconds = duration / 1000L;
        long minutes = 0L;
        long hours = 0L;
        String formatted = "";
        String hour = "";
        String min = "";
        String sec = "";
        if (seconds >= 3600L) {
            hours = seconds / 3600L;
            if (hours == 1L) {
                hour = String.valueOf(hours) + " hour ";
            } else if (hours > 1L) {
                hour = String.valueOf(hours) + " hours ";
            }
            minutes = (seconds -= hours * 3600L) / 60L;
            if (minutes == 1L) {
                min = String.valueOf(minutes) + " minute ";
            } else if (minutes != 1L) {
                min = String.valueOf(minutes) + " minutes ";
            }
            if ((seconds -= minutes * 60L) == 1L) {
                sec = String.valueOf(seconds) + " second";
            } else if (seconds > 1L) {
                sec = String.valueOf(seconds) + " seconds";
            }
            formatted = String.valueOf(formatted) + hour + min;
            if (includeSeconds) {
                formatted = String.valueOf(formatted) + sec;
            }
        } else if (seconds >= 60L) {
            minutes = seconds / 60L;
            if (minutes == 1L) {
                min = String.valueOf(minutes) + " minute ";
            } else if (minutes != 1L) {
                min = String.valueOf(minutes) + " minutes ";
            }
            if ((seconds -= minutes * 60L) == 1L) {
                sec = String.valueOf(seconds) + " second";
            } else if (seconds > 1L) {
                sec = String.valueOf(seconds) + " seconds";
            }
            formatted = String.valueOf(formatted) + min;
            if (includeSeconds) {
                formatted = String.valueOf(formatted) + sec;
            }
        } else {
            if (seconds == 1L) {
                sec = String.valueOf(seconds) + " second";
            } else if (seconds > 1L) {
                sec = String.valueOf(seconds) + " seconds";
            }
            if (includeSeconds) {
                formatted = String.valueOf(formatted) + sec;
            }
        }
        return formatted;
    }

    public static String getRelative(long time) {
        long diff = System.currentTimeMillis() - time;
        String duration = DateUtil.getRelativeDuration(Math.abs(diff));
        if (duration.length() > 0) {
            if (diff > 0L) {
                return NLS.bind((String)Messages.DateUtil_ago, (Object)duration);
            }
            return NLS.bind((String)Messages.DateUtil_in, (Object)duration);
        }
        return "";
    }

    public static String getRelativeDuration(long diff) {
        PeriodString string = null;
        Period[] periodArray = Period.values();
        int n = periodArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean wasSet;
            Period period = periodArray[n2];
            boolean bl = wasSet = string != null;
            if (diff >= period.duration) {
                if (string != null) {
                    string.append(new PeriodString(period, diff));
                    break;
                }
                string = new PeriodString(period, diff);
                diff -= diff / period.duration * period.duration;
            }
            if (wasSet) break;
            ++n2;
        }
        return string != null ? string.toString() : "";
    }

    static /* synthetic */ long access$0() {
        return MILLIS_MONTH;
    }

    static /* synthetic */ long access$1() {
        return MILLIS_WEEK;
    }

    static /* synthetic */ long access$2() {
        return MILLIS_DAY;
    }

    static /* synthetic */ long access$3() {
        return MILLIS_HOUR;
    }

    static /* synthetic */ long access$4() {
        return MILLIS_MINUTE;
    }

    static /* synthetic */ long access$5() {
        return MILLIS_SECOND;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Period {
        MONTH(DateUtil.access$0(), Messages.DateUtil_month_single, Messages.DateUtil_month_multi),
        WEEK(DateUtil.access$1(), Messages.DateUtil_week, Messages.DateUtil_weeks),
        DAY(DateUtil.access$2(), Messages.DateUtil_day, Messages.DateUtil_days),
        HOUR(DateUtil.access$3(), Messages.DateUtil_hour, Messages.DateUtil_hours),
        MINUTE(DateUtil.access$4(), Messages.DateUtil_minute, Messages.DateUtil_minutes),
        SECOND(DateUtil.access$5(), Messages.DateUtil_second, Messages.DateUtil_seconds);

        private final long duration;
        private final String singularLabel;
        private final String pluralLabel;

        private Period(long duration, String singularLabel, String pluralLabel) {
            this.duration = duration;
            this.singularLabel = singularLabel;
            this.pluralLabel = pluralLabel;
        }

        public String toString(long time) {
            long count = time / this.duration;
            if (count <= 1L) {
                return NLS.bind((String)this.singularLabel, (Object)count);
            }
            return NLS.bind((String)this.pluralLabel, (Object)count);
        }
    }

    private static class PeriodString {
        private final Period period;
        private final long duration;
        private PeriodString next;

        public PeriodString(Period period, long duration) {
            Assert.isNotNull((Object)((Object)period));
            this.period = period;
            this.duration = duration;
        }

        public void append(PeriodString next) {
            this.next = next;
        }

        public String toString() {
            return String.valueOf(this.period.toString(this.duration)) + (this.next != null ? " " + this.next.toString() : "");
        }
    }
}

