/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.mylyn.internal.provisional.commons.ui.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumnViewerSupport<T extends Item> {
    public static final String KEY_COLUMN_CAN_HIDE = "org.eclipse.mylyn.column.viewer.support.column.can.hide";
    private static final String KEY_LAYOUT_DATA = "org.eclipse.jface.LAYOUT_DATA";
    public static final String KEY_SUPPORTS_SORTING = "org.eclipse.mylyn.column.viewer.support.sorting";
    private Menu contextMenu;
    private final Control control;
    private int[] defaultOrder;
    private ColumnState[] defaults;
    private int defaultSortColumnIndex;
    private int defaultSortDirection;
    private final boolean[] defaultVisibilities;
    private final Menu headerMenu;
    private ColumnState[] lastStates;
    private final File stateFile;
    private boolean supportsSorting;
    private final ColumnViewer viewer;

    public AbstractColumnViewerSupport(ColumnViewer viewer, File stateFile) {
        this(viewer, stateFile, new boolean[0]);
    }

    public AbstractColumnViewerSupport(ColumnViewer viewer, File stateFile, boolean[] defaultVisibilities) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)stateFile);
        Assert.isNotNull((Object)defaultVisibilities);
        Object supportSort = viewer.getControl().getData(KEY_SUPPORTS_SORTING);
        this.supportsSorting = supportSort instanceof Boolean ? (Boolean)supportSort : true;
        this.defaultVisibilities = defaultVisibilities;
        this.viewer = viewer;
        this.stateFile = stateFile;
        this.control = viewer.getControl();
        Composite parent = viewer.getControl().getParent();
        this.headerMenu = new Menu((Control)parent);
    }

    abstract void addColumnSelectionListener(T var1, SelectionListener var2);

    private MenuItem createMenuItem(Menu parent, T column, int i) {
        MenuItem item = new MenuItem(parent, 32);
        item.setText(column.getText());
        item.setSelection(this.getWidth(column) > 0);
        item.addListener(13, new Listener((Item)column, i, item){
            private final /* synthetic */ Item val$column;
            private final /* synthetic */ int val$i;
            private final /* synthetic */ MenuItem val$item;
            {
                this.val$column = item;
                this.val$i = n;
                this.val$item = menuItem;
            }

            public void handleEvent(Event event) {
                int lastWidth = AbstractColumnViewerSupport.this.getWidth(this.val$column);
                if (lastWidth != 0) {
                    ((AbstractColumnViewerSupport)AbstractColumnViewerSupport.this).lastStates[this.val$i].width = lastWidth;
                }
                if (((AbstractColumnViewerSupport)AbstractColumnViewerSupport.this).lastStates[this.val$i].width == 0) {
                    ((AbstractColumnViewerSupport)AbstractColumnViewerSupport.this).lastStates[this.val$i].width = ((AbstractColumnViewerSupport)AbstractColumnViewerSupport.this).defaults[this.val$i].width;
                }
                if (((AbstractColumnViewerSupport)AbstractColumnViewerSupport.this).lastStates[this.val$i].width == 0) {
                    ((AbstractColumnViewerSupport)AbstractColumnViewerSupport.this).lastStates[this.val$i].width = 150;
                }
                if (this.val$item.getSelection()) {
                    AbstractColumnViewerSupport.this.setWidth(this.val$column, ((AbstractColumnViewerSupport)AbstractColumnViewerSupport.this).lastStates[this.val$i].width);
                } else {
                    AbstractColumnViewerSupport.this.setWidth(this.val$column, 0);
                }
            }
        });
        return item;
    }

    private void createRestoreDefaults(Menu parent) {
        new MenuItem(parent, 2);
        MenuItem restoreDefaults = new MenuItem(parent, 8);
        restoreDefaults.setText(Messages.AbstractColumnViewerSupport_Restore_defaults);
        restoreDefaults.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractColumnViewerSupport.this.restoreDefaults();
            }
        });
    }

    abstract Rectangle getClientArea();

    abstract T getColumn(int var1);

    abstract int getColumnIndexOf(T var1);

    abstract AbstractColumnLayout getColumnLayout();

    private ColumnLayoutData getColumnLayoutData(Item column) {
        Object data = column.getData(KEY_LAYOUT_DATA);
        if (data instanceof ColumnLayoutData) {
            return (ColumnLayoutData)data;
        }
        return null;
    }

    abstract int[] getColumnOrder();

    abstract T[] getColumns();

    abstract int getColumnWidth(T var1);

    abstract int getHeaderHeight();

    abstract T getSortColumn();

    abstract int getSortDirection();

    private int getWidth(T column) {
        ColumnLayoutData data = this.getColumnLayoutData((Item)column);
        AbstractColumnLayout columnLayout = this.getColumnLayout();
        if (data != null && columnLayout != null) {
            if (data instanceof ColumnWeightData) {
                return ((ColumnWeightData)data).weight;
            }
            if (data instanceof ColumnPixelData) {
                int width = ((ColumnPixelData)data).width;
                int totalWidth = this.control.getSize().x;
                if (totalWidth == 0) {
                    return width;
                }
                return width * 100 / totalWidth;
            }
            return this.getColumnWidth(column);
        }
        return this.getColumnWidth(column);
    }

    private void initialize() {
        Item[] columns = this.getColumns();
        this.defaults = new ColumnState[columns.length];
        this.defaultSortColumnIndex = -1;
        int i = 0;
        while (i < columns.length) {
            final Item column = columns[i];
            if (this.supportsSorting) {
                this.addColumnSelectionListener(column, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int direction = AbstractColumnViewerSupport.this.getSortDirection();
                        direction = AbstractColumnViewerSupport.this.getSortColumn() == column && direction != 0 ? (direction == 1024 ? 128 : 0) : 1024;
                        AbstractColumnViewerSupport.this.setSortDirection(direction);
                        if (direction == 0) {
                            AbstractColumnViewerSupport.this.setSortColumn(null);
                        } else {
                            AbstractColumnViewerSupport.this.setSortColumn(column);
                        }
                        AbstractColumnViewerSupport.this.viewer.refresh();
                    }
                });
                if (column == this.getSortColumn()) {
                    this.defaultSortColumnIndex = i;
                }
            }
            MenuItem item = this.createMenuItem(this.headerMenu, column, i);
            item.setEnabled(this.canHide(column));
            this.defaults[i] = new ColumnState();
            this.defaults[i].width = this.getWidth(column);
            ++i;
        }
        this.createRestoreDefaults(this.headerMenu);
        this.defaultOrder = this.getColumnOrder();
        this.defaultSortDirection = this.getSortDirection();
        this.control.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Menu menu = AbstractColumnViewerSupport.this.control.getMenu();
                if (menu != null && menu != AbstractColumnViewerSupport.this.headerMenu) {
                    AbstractColumnViewerSupport.this.contextMenu = menu;
                }
                Display display = AbstractColumnViewerSupport.this.control.getDisplay();
                Point pt = display.map(null, AbstractColumnViewerSupport.this.control, new Point(event.x, event.y));
                Rectangle clientArea = AbstractColumnViewerSupport.this.getClientArea();
                boolean header = clientArea.y <= pt.y && pt.y < clientArea.y + AbstractColumnViewerSupport.this.getHeaderHeight();
                AbstractColumnViewerSupport.this.control.setMenu(header ? AbstractColumnViewerSupport.this.headerMenu : AbstractColumnViewerSupport.this.contextMenu);
            }
        });
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AbstractColumnViewerSupport.this.save();
            }
        });
    }

    private boolean canHide(T column) {
        Object canHide = column.getData(KEY_COLUMN_CAN_HIDE);
        return !(canHide instanceof Boolean) || (Boolean)canHide != false;
    }

    void initializeViewerSupport() {
        this.initialize();
        this.restore();
        Item[] columns = this.getColumns();
        this.lastStates = new ColumnState[columns.length];
        int i = 0;
        while (i < columns.length) {
            Item column = columns[i];
            this.lastStates[i] = new ColumnState();
            this.lastStates[i].width = this.getWidth(column);
            ++i;
        }
    }

    private void restore() {
        if (this.stateFile.exists()) {
            block16: {
                try {
                    FileReader reader = new FileReader(this.stateFile);
                    try {
                        try {
                            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                            IMemento[] children = memento.getChildren("Column");
                            int[] order = new int[children.length];
                            int i = 0;
                            while (i < children.length) {
                                int width;
                                T column = this.getColumn(i);
                                Integer widthInteger = children[i].getInteger("width");
                                if (widthInteger != null && (width = widthInteger.intValue()) >= 0 && (width > 0 || this.canHide(column))) {
                                    this.setWidth(column, width);
                                }
                                this.headerMenu.getItem(i).setSelection(this.getWidth(column) > 0);
                                Integer orderInteger = children[i].getInteger("order");
                                order[i] = orderInteger != null ? orderInteger : 0;
                                ++i;
                            }
                            try {
                                this.setColumnOrder(order);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            IMemento child = memento.getChild("Sort");
                            if (child != null) {
                                int columnIndex = child.getInteger("column");
                                T column = this.getColumn(columnIndex);
                                this.setSortColumn(column);
                                this.setSortDirection(child.getInteger("direction"));
                            }
                        }
                        catch (Exception exception) {
                            reader.close();
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.viewer.refresh();
        } else {
            Item[] columns = this.getColumns();
            int i = 0;
            while (i < columns.length) {
                Item column = columns[i];
                if (i < this.defaultVisibilities.length && !this.defaultVisibilities[i]) {
                    this.setWidth(column, 0);
                    this.headerMenu.getItem(i).setSelection(false);
                }
                ++i;
            }
        }
    }

    private void restoreDefaults() {
        int index = 0;
        while (index < this.defaults.length) {
            T column = this.getColumn(index);
            if (index < this.defaultVisibilities.length && !this.defaultVisibilities[index]) {
                this.setWidth(column, 0);
            } else {
                this.setWidth(column, this.defaults[index].width);
            }
            this.headerMenu.getItem(index).setSelection(this.getWidth(column) > 0);
            ++index;
        }
        this.setColumnOrder(this.defaultOrder);
        if (this.defaultSortColumnIndex != -1) {
            this.setSortColumn(this.getColumn(this.defaultSortColumnIndex));
            this.setSortDirection(this.defaultSortDirection);
        } else {
            this.setSortColumn(null);
        }
        this.viewer.refresh();
    }

    private void save() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"Viewer");
        int[] order = this.getColumnOrder();
        Item[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            Item column = columns[i];
            IMemento child = memento.createChild("Column");
            child.putInteger("width", this.getWidth(column));
            child.putInteger("order", order[i]);
            ++i;
        }
        T sortColumn = this.getSortColumn();
        if (sortColumn != null) {
            IMemento child = memento.createChild("Sort");
            child.putInteger("column", this.getColumnIndexOf(sortColumn));
            child.putInteger("direction", this.getSortDirection());
        }
        try {
            FileWriter writer = new FileWriter(this.stateFile);
            try {
                memento.save((Writer)writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException iOException) {}
    }

    abstract void setColumnOrder(int[] var1);

    abstract void setColumnResizable(T var1, boolean var2);

    abstract void setColumnWidth(T var1, int var2);

    abstract void setSortColumn(T var1);

    abstract void setSortDirection(int var1);

    private void setWidth(T column, int width) {
        ColumnLayoutData data = this.getColumnLayoutData((Item)column);
        AbstractColumnLayout columnLayout = this.getColumnLayout();
        if (data != null && columnLayout != null) {
            if (width == 0) {
                columnLayout.setColumnData(column, (ColumnLayoutData)new ColumnPixelData(width, data.resizable));
            } else {
                columnLayout.setColumnData(column, (ColumnLayoutData)new ColumnWeightData(width, data.resizable));
            }
            this.control.getParent().layout();
        } else {
            this.setColumnWidth(column, width);
        }
        this.setColumnResizable(column, width > 0);
    }

    private static class ColumnState {
        int width;

        private ColumnState() {
        }
    }
}

