/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.contentassist.IJavaDebugContentAssistContext;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugCompletionProposalCollector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;

public class JavaDebugContentAssistProcessor
implements IContentAssistProcessor {
    private JavaDebugCompletionProposalCollector fCollector;
    private IContextInformationValidator fValidator;
    private TemplateEngine fJavaEngine;
    private TemplateEngine fStatementEngine;
    private String fErrorMessage = null;
    private char[] fProposalAutoActivationSet;
    private CompletionProposalComparator fComparator;
    private IJavaDebugContentAssistContext fContext;

    public JavaDebugContentAssistProcessor(IJavaDebugContentAssistContext context) {
        this.fContext = context;
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType != null) {
            this.fJavaEngine = new TemplateEngine(contextType);
        }
        if ((contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java-statements")) != null) {
            this.fStatementEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new CompletionProposalComparator();
    }

    public String getErrorMessage() {
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        if (this.fCollector != null) {
            return this.fCollector.getErrorMessage();
        }
        return null;
    }

    private void setErrorMessage(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.fErrorMessage = string;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        this.setErrorMessage(null);
        try {
            IType type = this.fContext.getType();
            IJavaProject project = type.getJavaProject();
            String[][] locals = this.fContext.getLocalVariables();
            int numLocals = 0;
            if (locals.length > 0) {
                numLocals = locals[0].length;
            }
            char[][] localVariableNames = new char[numLocals][];
            char[][] localVariableTypeNames = new char[numLocals][];
            int i = 0;
            while (i < numLocals) {
                localVariableNames[i] = locals[0][i].toCharArray();
                localVariableTypeNames[i] = locals[1][i].toCharArray();
                ++i;
            }
            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            this.configureResultCollector(project, selection);
            int[] localModifiers = new int[localVariableNames.length];
            Arrays.fill(localModifiers, 0);
            String snippet = viewer.getDocument().get();
            char[] charSnippet = this.fContext.getSnippet(snippet).toCharArray();
            type.codeComplete(charSnippet, this.fContext.getInsertionPosition(), documentOffset, (char[][])localVariableTypeNames, (char[][])localVariableNames, localModifiers, this.fContext.isStatic(), (CompletionRequestor)this.fCollector);
            ArrayList<Object> total = new ArrayList<Object>();
            total.addAll(Arrays.asList(this.fCollector.getJavaCompletionProposals()));
            if (this.fJavaEngine != null) {
                this.fJavaEngine.reset();
                this.fJavaEngine.complete(viewer, documentOffset, null);
                total.addAll(Arrays.asList(this.fJavaEngine.getResults()));
            }
            if (this.fStatementEngine != null) {
                this.fStatementEngine.reset();
                this.fStatementEngine.complete(viewer, documentOffset, null);
                total.addAll(Arrays.asList(this.fStatementEngine.getResults()));
            }
            IJavaCompletionProposal[] iJavaCompletionProposalArray = this.order(total.toArray(new IJavaCompletionProposal[total.size()]));
            return iJavaCompletionProposalArray;
        }
        catch (CoreException x) {
            this.setErrorMessage(x.getStatus().getMessage());
        }
        finally {
            this.releaseCollector();
        }
        return null;
    }

    private IJavaCompletionProposal[] order(IJavaCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private void configureResultCollector(IJavaProject project, ITextSelection selection) {
        this.fCollector = new JavaDebugCompletionProposalCollector(project);
        if (selection.getLength() != 0) {
            this.fCollector.setReplacementLength(selection.getLength());
        }
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    private void releaseCollector() {
        if (this.fCollector != null && this.fCollector.getErrorMessage().length() > 0 && this.fErrorMessage != null) {
            this.setErrorMessage(this.fCollector.getErrorMessage());
        }
        this.fCollector = null;
    }
}

