/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RichTextAttributeEditor
extends AbstractAttributeEditor {
    private final RichTextEditor editor;
    protected boolean ignoreNotification;
    protected boolean suppressRefresh;

    public RichTextAttributeEditor(TaskDataModel manager, TaskRepository taskRepository, TaskAttribute taskAttribute) {
        this(manager, taskRepository, taskAttribute, 2);
    }

    public RichTextAttributeEditor(TaskDataModel manager, TaskRepository taskRepository, TaskAttribute taskAttribute, int style) {
        this(manager, taskRepository, taskAttribute, style, null, null);
    }

    public RichTextAttributeEditor(TaskDataModel manager, TaskRepository taskRepository, TaskAttribute taskAttribute, int style, IContextService contextService, AbstractTaskEditorExtension extension) {
        super(manager, taskAttribute);
        this.editor = new RichTextEditor(taskRepository, style, contextService, extension, this.getModel().getTask()){

            public void valueChanged(String value) {
                if (!RichTextAttributeEditor.this.ignoreNotification) {
                    try {
                        RichTextAttributeEditor.this.suppressRefresh = true;
                        RichTextAttributeEditor.this.setValue(value);
                    }
                    finally {
                        RichTextAttributeEditor.this.suppressRefresh = false;
                    }
                }
            }
        };
        this.editor.setReadOnly(this.isReadOnly());
        if ((style & 2) != 0) {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
        } else {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
        }
        this.setMode(RepositoryTextViewerConfiguration.Mode.DEFAULT);
        this.refresh();
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.refresh();
        this.editor.createControl(parent, toolkit);
        this.editor.getViewer().getTextWidget().setToolTipText(this.getDescription());
        this.setControl(this.editor.getControl());
    }

    public RichTextEditor getEditor() {
        return this.editor;
    }

    public SourceViewer getEditorViewer() {
        return this.editor.getEditorViewer();
    }

    public RepositoryTextViewerConfiguration.Mode getMode() {
        return this.editor.getMode();
    }

    public AbstractRenderingEngine getRenderingEngine() {
        return this.editor.getRenderingEngine();
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public SourceViewer getViewer() {
        return this.editor.getViewer();
    }

    public IAction getViewSourceAction() {
        return this.editor.getViewSourceAction();
    }

    public boolean hasBrowser() {
        return this.editor.hasBrowser();
    }

    public boolean hasPreview() {
        return this.editor.hasPreview();
    }

    public boolean isSpellCheckingEnabled() {
        return this.editor.isSpellCheckingEnabled();
    }

    public void setMode(RepositoryTextViewerConfiguration.Mode mode) {
        this.editor.setMode(mode);
    }

    public void setRenderingEngine(AbstractRenderingEngine renderingEngine) {
        this.editor.setRenderingEngine(renderingEngine);
    }

    public void setSpellCheckingEnabled(boolean spellCheckingEnabled) {
        this.editor.setSpellCheckingEnabled(spellCheckingEnabled);
    }

    public void setValue(String value) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), value);
        this.attributeChanged();
    }

    public void showBrowser() {
        this.editor.showBrowser();
    }

    public void showDefault() {
        this.editor.showDefault();
    }

    public void showEditor() {
        this.editor.showEditor();
    }

    public void showPreview() {
        this.editor.showPreview();
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.editor != null) {
            this.editor.setReadOnly(readOnly);
        }
    }

    public void refresh() {
        if (this.editor.getControl() == null || !this.editor.getControl().isDisposed()) {
            try {
                this.ignoreNotification = true;
                this.editor.setText(this.getValue());
            }
            finally {
                this.ignoreNotification = false;
            }
        }
    }

    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }

    protected void decorateIncoming(Color color) {
        super.decorateIncoming(color);
        if (this.editor != null) {
            this.editor.setBackground(color);
        }
    }

    public void enableAutoTogglePreview() {
        this.editor.enableAutoTogglePreview();
    }
}

