/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.SelectionManagerFactory;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemovePersistentAttributeFromXmlHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
        final ArrayList<OrmReadOnlyPersistentAttribute> virtualAttributes = new ArrayList<OrmReadOnlyPersistentAttribute>();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        for (OrmPersistentAttribute attribute : CollectionTools.iterable((Iterator)selection.iterator())) {
            OrmReadOnlyPersistentAttribute newAttribute = attribute.convertToVirtual();
            if (newAttribute == null) continue;
            virtualAttributes.add(newAttribute);
        }
        if (virtualAttributes.size() == 1) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JpaSelectionManager selectionManager = SelectionManagerFactory.getSelectionManager(window);
                    selectionManager.select(new DefaultJpaSelection((JpaStructureNode)virtualAttributes.get(0)), null);
                }
            });
        }
        return null;
    }
}

