/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.orm;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class MappingFileNewFileWizardPage
extends WizardNewFileCreationPage {
    protected IDataModel dataModel;

    public MappingFileNewFileWizardPage(String pageName, IStructuredSelection selection, IDataModel dataModel, String title, String description) {
        super(pageName, selection);
        this.init(dataModel);
        this.setTitle(title);
        this.setDescription(description);
    }

    protected void init(IDataModel dataModel) {
        String fileName;
        this.dataModel = dataModel;
        IPath containerPath = (IPath)this.dataModel.getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
        if (containerPath != null) {
            this.setContainerFullPath(containerPath);
        }
        if ((fileName = (String)this.dataModel.getProperty("JptFileCreationDataModelProperties.FILE_NAME")) != null) {
            this.setFileName(fileName);
        }
    }

    protected boolean validatePage() {
        this.dataModel.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getContainerFullPath());
        this.dataModel.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)this.getFileName());
        boolean valid = super.validatePage();
        if (!valid) {
            return valid;
        }
        IStatus validationStatus = this.dataModel.validateProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
        if (validationStatus.isOK()) {
            validationStatus = this.dataModel.validateProperty("JptFileCreationDataModelProperties.FILE_NAME");
        }
        if (validationStatus.isOK()) {
            this.setErrorMessage(null);
            return true;
        }
        if (validationStatus.getSeverity() == 2) {
            this.setErrorMessage(null);
            this.setMessage(validationStatus.getMessage(), 2);
            return true;
        }
        this.setErrorMessage(validationStatus.getMessage());
        return false;
    }
}

