/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.proj.model;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.internal.facet.FacetTools;
import org.eclipse.jpt.jpa.ui.internal.wizards.proj.model.JpaProjectCreationDataModelProperties;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProviderNew;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class JpaProjectCreationDataModelProvider
extends FacetProjectCreationDataModelProvider
implements JpaProjectCreationDataModelProperties {
    private IDataModelListener moduleFacetDataModelListener = new IDataModelListener(){

        public void propertyChanged(DataModelEvent event) {
            if ("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME".equals(event.getPropertyName())) {
                if (JpaProjectCreationDataModelProvider.this.isPropertySet("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME")) {
                    JpaProjectCreationDataModelProvider.this.setProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME", event.getProperty());
                } else {
                    JpaProjectCreationDataModelProvider.this.model.notifyPropertyChange("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME", 2);
                }
            } else if ("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(event.getPropertyName())) {
                JpaProjectCreationDataModelProvider.this.setProperty("JpaProjectCreationDataModelProperties.ADD_TO_EAR", event.getProperty());
            }
        }
    };

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("JpaProjectCreationDataModelProperties.MODULE_FACET_DATA_MODEL");
        names.add("JpaProjectCreationDataModelProperties.ADDED_UTILITY_FACET");
        names.add("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME");
        names.add("JpaProjectCreationDataModelProperties.ADD_TO_EAR");
        return names;
    }

    public void init() {
        super.init();
        ArrayList<IProjectFacet> requiredFacets = new ArrayList<IProjectFacet>();
        requiredFacets.add(JavaFacet.FACET);
        requiredFacets.add(JpaFacet.FACET);
        this.setProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION", requiredFacets);
        this.getDataModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP".equals(event.getPropertyName())) {
                    JpaProjectCreationDataModelProvider.this.updateModuleFacetDataModel();
                }
            }
        });
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IProject earProject;
            IStatus status;
            if (this.isAddToEar() && (status = this.validateEAR(this.model.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME"))).isOK() && (earProject = ProjectUtilities.getProject((String)this.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME"))) != null) {
                try {
                    IFacetedProject facetedEarProject = ProjectFacetsManager.create((IProject)earProject);
                    if (facetedEarProject != null) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    J2EEPlugin.logError((CoreException)e);
                }
            }
            return true;
        }
        if ("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME".equals(propertyName)) {
            return this.isAddToEar();
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Object getDefaultProperty(String propertyName) {
        IDataModel moduleFacetDataModel;
        if ("JpaProjectCreationDataModelProperties.ADDED_UTILITY_FACET".equals(propertyName)) {
            return Boolean.FALSE;
        }
        if ("JpaProjectCreationDataModelProperties.ADD_TO_EAR".equals(propertyName)) {
            IDataModel moduleFacetDataModel2 = this.getModuleFacetDataModel();
            if (moduleFacetDataModel2 != null) {
                return moduleFacetDataModel2.getDefaultProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR");
            }
        } else if ("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME".equals(propertyName) && (moduleFacetDataModel = this.getModuleFacetDataModel()) != null) {
            return moduleFacetDataModel.getDefaultProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName) && this.isAddToEar()) {
            DataModelPropertyDescriptor[] descriptors = super.getValidPropertyDescriptors(propertyName);
            ArrayList<DataModelPropertyDescriptor> list = new ArrayList<DataModelPropertyDescriptor>();
            int i = 0;
            while (i < descriptors.length) {
                IRuntime rt = (IRuntime)descriptors[i].getPropertyValue();
                if (rt == null || rt.supports(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET)) {
                    list.add(descriptors[i]);
                }
                ++i;
            }
            descriptors = new DataModelPropertyDescriptor[list.size()];
            i = 0;
            while (i < descriptors.length) {
                descriptors[i] = (DataModelPropertyDescriptor)list.get(i);
                ++i;
            }
            return descriptors;
        }
        if ("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME".equals(propertyName)) {
            IDataModel moduleFacetDataModel = this.getModuleFacetDataModel();
            if (moduleFacetDataModel != null) {
                return moduleFacetDataModel.getValidPropertyDescriptors("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
            }
            return new DataModelPropertyDescriptor[0];
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME".equals(propertyName) || "JpaProjectCreationDataModelProperties.ADD_TO_EAR".equals(propertyName) || "IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName) || "JpaProjectCreationDataModelProperties.MODULE_FACET_DATA_MODEL".equals(propertyName)) {
            IProject earProject;
            IStatus status;
            IDataModel moduleFacetDataModel = this.getModuleFacetDataModel();
            if (moduleFacetDataModel != null) {
                if ("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME".equals(propertyName) || "JpaProjectCreationDataModelProperties.MODULE_FACET_DATA_MODEL".equals(propertyName)) {
                    moduleFacetDataModel.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)this.getEarProjectName());
                }
                if ("JpaProjectCreationDataModelProperties.ADD_TO_EAR".equals(propertyName) || "JpaProjectCreationDataModelProperties.MODULE_FACET_DATA_MODEL".equals(propertyName)) {
                    moduleFacetDataModel.setProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", (Object)this.isAddToEar());
                }
                if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName) || "JpaProjectCreationDataModelProperties.MODULE_FACET_DATA_MODEL".equals(propertyName)) {
                    moduleFacetDataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)this.getFacetRuntime());
                }
            }
            if (this.isAddToEar() && (status = this.validateEAR(this.model.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME"))).isOK() && (earProject = ProjectUtilities.getProject((String)this.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME"))) != null) {
                try {
                    IFacetedProject facetedEarProject = ProjectFacetsManager.create((IProject)earProject);
                    if (facetedEarProject != null) {
                        this.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", facetedEarProject.getPrimaryRuntime());
                    }
                }
                catch (CoreException e) {
                    J2EEPlugin.logError((CoreException)e);
                }
            }
            if ("JpaProjectCreationDataModelProperties.ADD_TO_EAR".equals(propertyName)) {
                this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
                IProjectFacetVersion moduleFacet = this.findModuleFacet();
                if (this.isAddToEar()) {
                    if (moduleFacet == null) {
                        this.getFacetedProject().addProjectFacet(IJ2EEFacetConstants.UTILITY_FACET_10);
                        this.setBooleanProperty("JpaProjectCreationDataModelProperties.ADDED_UTILITY_FACET", true);
                    }
                } else if (moduleFacet != null && this.isAddedUtilityFacet()) {
                    if (moduleFacet.equals(IJ2EEFacetConstants.UTILITY_FACET_10)) {
                        this.getFacetedProject().removeProjectFacet(IJ2EEFacetConstants.UTILITY_FACET_10);
                    }
                    this.setBooleanProperty("JpaProjectCreationDataModelProperties.ADDED_UTILITY_FACET", false);
                }
                this.model.notifyPropertyChange("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME", 3);
                this.model.notifyPropertyChange("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME", 4);
                this.model.notifyPropertyChange("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME", 1);
            }
            this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 3);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String propertyName) {
        IStatus status = super.validate(propertyName);
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (!status.isOK()) {
            return status;
        }
        if (("JpaProjectCreationDataModelProperties.ADD_TO_EAR".equals(propertyName) || "JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME".equals(propertyName) || "IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) && this.model.getBooleanProperty("JpaProjectCreationDataModelProperties.ADD_TO_EAR") && (status = this.validateEAR(this.model.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME"))).isOK() && this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").equals(this.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME"))) {
            String errorMessage = WTPCommonPlugin.getResourceString((String)"4", (Object[])new Object[]{this.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME")});
            status = WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        return status;
    }

    protected IStatus validateEAR(String earName) {
        IProject earProject;
        if (earName.indexOf("#") != -1 || earName.indexOf("/") != -1) {
            String errorMessage = WTPCommonPlugin.getResourceString((String)"35");
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        if (earName.equals("")) {
            String errorMessage = WTPCommonPlugin.getResourceString((String)"34");
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        IStatus status = ProjectCreationDataModelProviderNew.validateProjectName((String)earName);
        if (status.isOK() && !(earProject = ProjectUtilities.getProject((String)this.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME"))).exists()) {
            IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            path = path.append(earName);
            status = ProjectCreationDataModelProviderNew.validateExisting((String)earName, (String)path.toString());
        }
        return status;
    }

    protected void updateModuleFacetDataModel() {
        IDataModel newModuleFacetDataModel = this.findModuleFacetDataModel();
        IDataModel oldModuleFacetDataModel = this.getModuleFacetDataModel();
        if (oldModuleFacetDataModel != newModuleFacetDataModel) {
            if (oldModuleFacetDataModel != null) {
                oldModuleFacetDataModel.removeListener(this.moduleFacetDataModelListener);
            }
            if (newModuleFacetDataModel != null) {
                newModuleFacetDataModel.setProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", this.getProperty("JpaProjectCreationDataModelProperties.ADD_TO_EAR"));
                newModuleFacetDataModel.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", this.getProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME"));
                newModuleFacetDataModel.addListener(this.moduleFacetDataModelListener);
            } else {
                this.model.setBooleanProperty("JpaProjectCreationDataModelProperties.ADD_TO_EAR", false);
                this.model.setBooleanProperty("JpaProjectCreationDataModelProperties.ADDED_UTILITY_FACET", false);
            }
            this.setProperty("JpaProjectCreationDataModelProperties.MODULE_FACET_DATA_MODEL", newModuleFacetDataModel);
            this.model.notifyPropertyChange("JpaProjectCreationDataModelProperties.ADD_TO_EAR", 2);
            this.model.notifyPropertyChange("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME", 2);
            this.model.notifyPropertyChange("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME", 4);
        }
    }

    protected IFacetedProjectWorkingCopy getFacetedProject() {
        return (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    protected IRuntime getFacetRuntime() {
        return (IRuntime)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
    }

    protected IDataModel getModuleFacetDataModel() {
        return (IDataModel)this.getProperty("JpaProjectCreationDataModelProperties.MODULE_FACET_DATA_MODEL");
    }

    protected boolean isAddedUtilityFacet() {
        return this.getBooleanProperty("JpaProjectCreationDataModelProperties.ADDED_UTILITY_FACET");
    }

    protected boolean isAddToEar() {
        return this.getBooleanProperty("JpaProjectCreationDataModelProperties.ADD_TO_EAR");
    }

    protected String getEarProjectName() {
        return this.getStringProperty("JpaProjectCreationDataModelProperties.EAR_PROJECT_NAME");
    }

    protected IDataModel findModuleFacetDataModel() {
        IFacetProjectCreationDataModelProperties.FacetActionMap map = (IFacetProjectCreationDataModelProperties.FacetActionMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP");
        IProjectFacetVersion moduleFacet = this.findModuleFacet();
        if (moduleFacet != null) {
            IFacetedProject.Action action = map.getAction(moduleFacet.getProjectFacet().getId());
            return action == null ? null : (IDataModel)action.getConfig();
        }
        return null;
    }

    protected IProjectFacetVersion findModuleFacet() {
        return FacetTools.getModuleFacet((IFacetedProjectBase)this.getFacetedProject());
    }
}

