/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;
import org.eclipse.mylyn.wikitext.mediawiki.core.TemplateResolver;

public class WikiTemplateResolver
extends TemplateResolver {
    private String wikiBaseUrl;

    public String getWikiBaseUrl() {
        return this.wikiBaseUrl;
    }

    public void setWikiBaseUrl(String wikiBaseUrl) {
        this.wikiBaseUrl = wikiBaseUrl;
    }

    public Template resolveTemplate(String templateName) {
        if (this.wikiBaseUrl != null) {
            int indexOf = templateName.indexOf(58);
            if (indexOf == 0) {
                templateName = "Template" + templateName;
            } else if (indexOf == -1) {
                templateName = "Template:" + templateName;
            }
            URL url = this.computeRawUrl(templateName);
            if (url != null) {
                Template template;
                InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), "UTF-8");
                try {
                    String content = this.readFully(input);
                    Template template2 = new Template();
                    String basicName = templateName.toLowerCase().startsWith("template:") ? templateName.substring(templateName.lastIndexOf(58) + 1) : templateName;
                    template2.setName(basicName);
                    template2.setTemplateMarkup(content);
                    template = template2;
                }
                catch (Throwable throwable) {
                    try {
                        ((Reader)input).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        String message = MessageFormat.format("Cannot read from {0}: {1}", url, e.getMessage());
                        Logger.getLogger(WikiTemplateResolver.class.getName()).log(Level.WARNING, message, e);
                    }
                }
                ((Reader)input).close();
                return template;
            }
        }
        return null;
    }

    private String readFully(Reader input) throws IOException {
        int i;
        StringWriter content = new StringWriter(1024);
        while ((i = input.read()) != -1) {
            content.write(i);
        }
        return content.toString();
    }

    private URL computeRawUrl(String path) {
        try {
            String qualifiedUrl = this.wikiBaseUrl;
            if (!qualifiedUrl.endsWith("/")) {
                qualifiedUrl = String.valueOf(qualifiedUrl) + "/";
            }
            qualifiedUrl = String.valueOf(qualifiedUrl) + "index.php?title=" + URLEncoder.encode(path, "UTF-8") + "&action=raw";
            return new URL(qualifiedUrl);
        }
        catch (IOException e) {
            Logger.getLogger(WikiTemplateResolver.class.getName()).log(Level.WARNING, MessageFormat.format("Cannot compute raw URL for {0}: {1}", path, e.getMessage()), e);
            return null;
        }
    }
}

