/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskHistory {
    private final TaskRepository repository;
    private final List<TaskRevision> revisions;
    private final ITask task;

    public TaskHistory(TaskRepository repository, ITask task) {
        Assert.isNotNull((Object)((Object)repository));
        Assert.isNotNull((Object)task);
        this.repository = repository;
        this.task = task;
        this.revisions = new ArrayList<TaskRevision>();
    }

    public void add(TaskRevision entry) {
        this.revisions.add(entry);
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public List<TaskRevision> getRevisions() {
        return new ArrayList<TaskRevision>(this.revisions);
    }

    public TaskRevision getRevision(String id) {
        for (TaskRevision revision : this.revisions) {
            if (!revision.getId().equals(id)) continue;
            return revision;
        }
        return null;
    }

    public ITask getTask() {
        return this.task;
    }

    public void remove(TaskRevision entry) {
        this.revisions.remove(entry);
    }
}

