/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.AnnotationProvider;
import org.eclipse.jpt.jaxb.core.resource.java.Annotation;
import org.eclipse.jpt.jaxb.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.NestableAnnotationDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericAnnotationProvider
implements AnnotationProvider {
    private final AnnotationDefinition[] annotationDefinitions;
    private final NestableAnnotationDefinition[] nestableAnnotationDefinitions;

    public GenericAnnotationProvider(AnnotationDefinition[] annotationDefinitions, NestableAnnotationDefinition[] nestableAnnotationDefinitions) {
        this.annotationDefinitions = annotationDefinitions;
        this.nestableAnnotationDefinitions = nestableAnnotationDefinitions;
    }

    protected Iterable<AnnotationDefinition> getAnnotationDefinitions() {
        return new ArrayIterable((Object[])this.annotationDefinitions);
    }

    protected AnnotationDefinition getAnnotationDefinition(String annotationName) {
        AnnotationDefinition[] annotationDefinitionArray = this.annotationDefinitions;
        int n = this.annotationDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationDefinition annotationDefinition = annotationDefinitionArray[n2];
            if (annotationDefinition.getAnnotationName().equals(annotationName)) {
                return annotationDefinition;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Iterable<String> getAnnotationNames() {
        return new TransformationIterable<AnnotationDefinition, String>(this.getAnnotationDefinitions()){

            protected String transform(AnnotationDefinition annotationDefinition) {
                return annotationDefinition.getAnnotationName();
            }
        };
    }

    @Override
    public Iterable<String> getContainerAnnotationNames() {
        return new TransformationIterable<NestableAnnotationDefinition, String>(this.getNestableAnnotationDefinitions()){

            protected String transform(NestableAnnotationDefinition annotationDefinition) {
                return annotationDefinition.getContainerAnnotationName();
            }
        };
    }

    @Override
    public Iterable<String> getNestableAnnotationNames() {
        return new TransformationIterable<NestableAnnotationDefinition, String>(this.getNestableAnnotationDefinitions()){

            protected String transform(NestableAnnotationDefinition annotationDefinition) {
                return annotationDefinition.getNestableAnnotationName();
            }
        };
    }

    @Override
    public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, String annotationName) {
        return this.getAnnotationDefinition(annotationName).buildAnnotation(parent, element);
    }

    @Override
    public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, IAnnotation jdtAnnotation) {
        return this.getAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation(parent, jdtAnnotation);
    }

    @Override
    public Annotation buildNullAnnotation(JavaResourceAnnotatedElement parent, String annotationName) {
        return this.getAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    protected Iterable<NestableAnnotationDefinition> getNestableAnnotationDefinitions() {
        return new ArrayIterable((Object[])this.nestableAnnotationDefinitions);
    }

    protected NestableAnnotationDefinition getNestableAnnotationDefinition(String annotationName) {
        NestableAnnotationDefinition[] nestableAnnotationDefinitionArray = this.nestableAnnotationDefinitions;
        int n = this.nestableAnnotationDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            NestableAnnotationDefinition annotationDefinition = nestableAnnotationDefinitionArray[n2];
            if (annotationDefinition.getNestableAnnotationName().equals(annotationName)) {
                return annotationDefinition;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public NestableAnnotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, String annotationName, int index) {
        return this.getNestableAnnotationDefinition(annotationName).buildAnnotation(parent, element, index);
    }

    @Override
    public String getNestableAnnotationName(String containerAnnotationName) {
        return this.getNestableAnnotationDefinitionForContainer(containerAnnotationName).getNestableAnnotationName();
    }

    @Override
    public String getNestableElementName(String nestableAnnotationName) {
        return this.getNestableAnnotationDefinition(nestableAnnotationName).getElementName();
    }

    private NestableAnnotationDefinition getNestableAnnotationDefinitionForContainer(String containerAnnotationName) {
        for (NestableAnnotationDefinition nestableAnnotationDefinition : this.getNestableAnnotationDefinitions()) {
            if (!nestableAnnotationDefinition.getContainerAnnotationName().equals(containerAnnotationName)) continue;
            return nestableAnnotationDefinition;
        }
        return null;
    }
}

