/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributesContainer;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbContainmentMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.XmlAdaptable;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.context.XmlSeeAlso;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaPersistentType;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaAttributesContainer;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaTypeXmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlAdaptable;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlSeeAlso;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSeeAlsoAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPersistentClass
extends AbstractJavaPersistentType
implements JaxbPersistentClass {
    protected JaxbClass superClass;
    protected XmlAccessType defaultAccessType;
    protected XmlAccessType specifiedAccessType;
    protected XmlAccessOrder defaultAccessOrder;
    protected XmlAccessOrder specifiedAccessOrder;
    protected final XmlAdaptable xmlAdaptable;
    protected XmlSeeAlso xmlSeeAlso;
    protected final JaxbAttributesContainer attributesContainer;
    protected final Map<JaxbClass, JaxbAttributesContainer> inheritedAttributesContainers = new HashMap<JaxbClass, JaxbAttributesContainer>();

    public GenericJavaPersistentClass(JaxbContextRoot parent, JavaResourceType resourceType) {
        super(parent, resourceType);
        this.superClass = this.buildSuperClass();
        this.specifiedAccessType = this.getResourceAccessType();
        this.specifiedAccessOrder = this.getResourceAccessOrder();
        this.defaultAccessType = this.buildDefaultAccessType();
        this.defaultAccessOrder = this.buildDefaultAccessOrder();
        this.xmlAdaptable = this.buildXmlAdaptable();
        this.initXmlSeeAlso();
        this.attributesContainer = new GenericJavaAttributesContainer(this, this.buildAttributesContainerOwner(), resourceType);
        this.initializeInheritedAttributes();
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return (JavaResourceType)super.getJavaResourceType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedAccessType_(this.getResourceAccessType());
        this.setSpecifiedAccessOrder_(this.getResourceAccessOrder());
        this.xmlAdaptable.synchronizeWithResourceModel();
        this.syncXmlSeeAlso();
        this.attributesContainer.synchronizeWithResourceModel();
        this.syncInheritedAttributes();
    }

    @Override
    public void update() {
        super.update();
        super.update();
        this.setSuperClass(this.buildSuperClass());
        this.setDefaultAccessType(this.buildDefaultAccessType());
        this.setDefaultAccessOrder(this.buildDefaultAccessOrder());
        this.xmlAdaptable.update();
        this.updateXmlSeeAlso();
        this.attributesContainer.update();
        this.updateInheritedAttributes();
    }

    @Override
    public JaxbType.Kind getKind() {
        return JaxbType.Kind.PERSISTENT_CLASS;
    }

    @Override
    public Iterable<String> getDirectlyReferencedTypeNames() {
        return new CompositeIterable(new Iterable[]{new SingleElementIterable((Object)this.getJavaResourceType().getSuperclassQualifiedName()), new CompositeIterable((Iterable)new TransformationIterable<JaxbPersistentAttribute, Iterable<String>>(this.getAttributes()){

            protected Iterable<String> transform(JaxbPersistentAttribute o) {
                return o.getMapping().getDirectlyReferencedTypeNames();
            }
        }), this.getXmlSeeAlsoClasses()});
    }

    protected Iterable<String> getXmlSeeAlsoClasses() {
        return this.xmlSeeAlso == null ? EmptyIterable.instance() : this.getXmlSeeAlso().getDirectlyReferencedTypeNames();
    }

    @Override
    public JaxbClass getSuperClass() {
        return this.superClass;
    }

    protected void setSuperClass(JaxbClass superClass) {
        JaxbClass old = this.superClass;
        this.superClass = superClass;
        this.firePropertyChanged("superClass", old, superClass);
    }

    protected JaxbClass buildSuperClass() {
        HashSet<JavaResourceType> visited = new HashSet<JavaResourceType>();
        visited.add(this.getJavaResourceType());
        JaxbClass spc = this.getSuperClass(this.getJavaResourceType().getSuperclassQualifiedName(), visited);
        if (spc == null) {
            return null;
        }
        if (CollectionTools.contains(spc.getInheritanceHierarchy(), (Object)this)) {
            return null;
        }
        return spc;
    }

    protected JaxbClass getSuperClass(String typeName, Collection<JavaResourceType> visited) {
        if (typeName == null) {
            return null;
        }
        JavaResourceType resourceType = (JavaResourceType)this.getJaxbProject().getJavaResourceType(typeName, JavaResourceAbstractType.Kind.TYPE);
        if (resourceType == null || visited.contains(resourceType)) {
            return null;
        }
        visited.add(resourceType);
        JaxbClass spc = this.getClass(typeName);
        return spc != null && resourceType.isMapped() ? spc : this.getSuperClass(resourceType.getSuperclassQualifiedName(), visited);
    }

    protected JaxbClass getClass(String fullyQualifiedTypeName) {
        return this.getParent().getClass(fullyQualifiedTypeName);
    }

    @Override
    public Iterable<JaxbClass> getInheritanceHierarchy() {
        return this.getInheritanceHierarchyOf(this);
    }

    @Override
    public Iterable<JaxbClass> getAncestors() {
        return this.getInheritanceHierarchyOf(this.superClass);
    }

    protected Iterable<JaxbClass> getInheritanceHierarchyOf(JaxbClass start) {
        return new ChainIterable<JaxbClass>(start){

            protected JaxbClass nextLink(JaxbClass jaxbClass) {
                return jaxbClass.getSuperClass();
            }
        };
    }

    @Override
    public XmlAccessType getAccessType() {
        return this.specifiedAccessType != null ? this.specifiedAccessType : this.defaultAccessType;
    }

    @Override
    public XmlAccessType getSpecifiedAccessType() {
        return this.specifiedAccessType;
    }

    @Override
    public void setSpecifiedAccessType(XmlAccessType access) {
        this.getAccessorTypeAnnotation().setValue(XmlAccessType.toJavaResourceModel(access));
        this.setSpecifiedAccessType_(access);
    }

    protected void setSpecifiedAccessType_(XmlAccessType access) {
        XmlAccessType old = this.specifiedAccessType;
        this.specifiedAccessType = access;
        this.firePropertyChanged("specifiedAccessType", (Object)old, (Object)access);
    }

    @Override
    public XmlAccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    protected void setDefaultAccessType(XmlAccessType access) {
        XmlAccessType old = this.defaultAccessType;
        this.defaultAccessType = access;
        this.firePropertyChanged("defaultAccessType", (Object)old, (Object)access);
    }

    protected XmlAccessType getResourceAccessType() {
        return XmlAccessType.fromJavaResourceModel(this.getAccessorTypeAnnotation().getValue());
    }

    protected XmlAccessorTypeAnnotation getAccessorTypeAnnotation() {
        return (XmlAccessorTypeAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorType");
    }

    protected XmlAccessType buildDefaultAccessType() {
        XmlAccessType superAccessType = this.getSuperClassAccessType();
        if (superAccessType != null) {
            return superAccessType;
        }
        XmlAccessType packageAccessType = this.getPackageAccessType();
        if (packageAccessType != null) {
            return packageAccessType;
        }
        return XmlAccessType.PUBLIC_MEMBER;
    }

    protected XmlAccessType getSuperClassAccessType() {
        JaxbClass superClass = this.getSuperClass();
        return superClass == null ? null : superClass.getSpecifiedAccessType();
    }

    protected XmlAccessType getPackageAccessType() {
        JaxbPackageInfo packageInfo = this.getPackageInfo();
        return packageInfo == null ? null : packageInfo.getAccessType();
    }

    @Override
    public XmlAccessOrder getAccessOrder() {
        return this.specifiedAccessOrder != null ? this.specifiedAccessOrder : this.defaultAccessOrder;
    }

    @Override
    public XmlAccessOrder getSpecifiedAccessOrder() {
        return this.specifiedAccessOrder;
    }

    @Override
    public void setSpecifiedAccessOrder(XmlAccessOrder accessOrder) {
        this.getAccessorOrderAnnotation().setValue(XmlAccessOrder.toJavaResourceModel(accessOrder));
        this.setSpecifiedAccessOrder_(accessOrder);
    }

    protected void setSpecifiedAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.specifiedAccessOrder;
        this.specifiedAccessOrder = accessOrder;
        this.firePropertyChanged("specifiedAccessOrder", (Object)old, (Object)accessOrder);
    }

    @Override
    public XmlAccessOrder getDefaultAccessOrder() {
        return this.defaultAccessOrder;
    }

    protected void setDefaultAccessOrder(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.defaultAccessOrder;
        this.defaultAccessOrder = accessOrder;
        this.firePropertyChanged("defaultAccessOrder", (Object)old, (Object)accessOrder);
    }

    protected XmlAccessOrder getResourceAccessOrder() {
        return XmlAccessOrder.fromJavaResourceModel(this.getAccessorOrderAnnotation().getValue());
    }

    protected XmlAccessorOrderAnnotation getAccessorOrderAnnotation() {
        return (XmlAccessorOrderAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
    }

    protected XmlAccessOrder buildDefaultAccessOrder() {
        XmlAccessOrder superAccessOrder = this.getSuperClassAccessOrder();
        if (superAccessOrder != null) {
            return superAccessOrder;
        }
        XmlAccessOrder packageAccessOrder = this.getPackageAccessOrder();
        if (packageAccessOrder != null) {
            return packageAccessOrder;
        }
        return XmlAccessOrder.UNDEFINED;
    }

    protected XmlAccessOrder getSuperClassAccessOrder() {
        JaxbClass superClass = this.getSuperClass();
        return superClass == null ? null : superClass.getSpecifiedAccessOrder();
    }

    protected XmlAccessOrder getPackageAccessOrder() {
        JaxbPackageInfo packageInfo = this.getPackageInfo();
        return packageInfo == null ? null : packageInfo.getAccessOrder();
    }

    public XmlAdaptable buildXmlAdaptable() {
        return new GenericJavaXmlAdaptable(this, new XmlAdaptable.Owner(){

            public JavaResourceAnnotatedElement getResource() {
                return GenericJavaPersistentClass.this.getJavaResourceType();
            }

            public XmlJavaTypeAdapter buildXmlJavaTypeAdapter(XmlJavaTypeAdapterAnnotation adapterAnnotation) {
                return GenericJavaPersistentClass.this.buildXmlJavaTypeAdapter(adapterAnnotation);
            }

            public void fireXmlAdapterChanged(XmlJavaTypeAdapter oldAdapter, XmlJavaTypeAdapter newAdapter) {
                GenericJavaPersistentClass.this.firePropertyChanged("xmlJavaTypeAdapter", oldAdapter, newAdapter);
            }
        });
    }

    @Override
    public XmlJavaTypeAdapter getXmlJavaTypeAdapter() {
        return this.xmlAdaptable.getXmlJavaTypeAdapter();
    }

    @Override
    public XmlJavaTypeAdapter addXmlJavaTypeAdapter() {
        return this.xmlAdaptable.addXmlJavaTypeAdapter();
    }

    protected XmlJavaTypeAdapter buildXmlJavaTypeAdapter(XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation) {
        return new GenericJavaTypeXmlJavaTypeAdapter(this, xmlJavaTypeAdapterAnnotation);
    }

    @Override
    public void removeXmlJavaTypeAdapter() {
        this.xmlAdaptable.removeXmlJavaTypeAdapter();
    }

    protected XmlSeeAlsoAnnotation getXmlSeeAlsoAnnotation() {
        return (XmlSeeAlsoAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
    }

    protected void initXmlSeeAlso() {
        XmlSeeAlsoAnnotation annotation = this.getXmlSeeAlsoAnnotation();
        this.xmlSeeAlso = annotation == null ? null : this.buildXmlSeeAlso(annotation);
    }

    protected XmlSeeAlso buildXmlSeeAlso(XmlSeeAlsoAnnotation annotation) {
        return new GenericJavaXmlSeeAlso(this, annotation);
    }

    @Override
    public XmlSeeAlso getXmlSeeAlso() {
        return this.xmlSeeAlso;
    }

    @Override
    public XmlSeeAlso addXmlSeeAlso() {
        if (this.xmlSeeAlso != null) {
            throw new IllegalStateException();
        }
        XmlSeeAlsoAnnotation annotation = (XmlSeeAlsoAnnotation)this.getJavaResourceType().addAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlso xmlSeeAlso = this.buildXmlSeeAlso(annotation);
        this.setXmlSeeAlso_(xmlSeeAlso);
        return xmlSeeAlso;
    }

    protected void setXmlSeeAlso_(XmlSeeAlso xmlSeeAlso) {
        XmlSeeAlso old = this.xmlSeeAlso;
        this.xmlSeeAlso = xmlSeeAlso;
        this.firePropertyChanged("xmlSeeAlso", old, xmlSeeAlso);
    }

    @Override
    public void removeXmlSeeAlso() {
        if (this.xmlSeeAlso == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceType().removeAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        this.setXmlSeeAlso_(null);
    }

    protected void syncXmlSeeAlso() {
        XmlSeeAlsoAnnotation annotation = this.getXmlSeeAlsoAnnotation();
        if (annotation != null) {
            if (this.xmlSeeAlso != null) {
                this.xmlSeeAlso.synchronizeWithResourceModel();
            } else {
                this.setXmlSeeAlso_(this.buildXmlSeeAlso(annotation));
            }
        } else {
            this.setXmlSeeAlso_(null);
        }
    }

    protected void updateXmlSeeAlso() {
        if (this.xmlSeeAlso != null) {
            this.xmlSeeAlso.update();
        }
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getAttributes() {
        return this.attributesContainer.getAttributes();
    }

    @Override
    public int getAttributesSize() {
        return this.attributesContainer.getAttributesSize();
    }

    protected JaxbAttributesContainer.Owner buildAttributesContainerOwner() {
        return new JaxbAttributesContainer.Owner(){

            public XmlAccessType getAccessType() {
                return GenericJavaPersistentClass.this.getAccessType();
            }

            public void fireAttributeAdded(JaxbPersistentAttribute attribute) {
                GenericJavaPersistentClass.this.fireItemAdded("attributes", attribute);
            }

            public void fireAttributeRemoved(JaxbPersistentAttribute attribute) {
                GenericJavaPersistentClass.this.fireItemRemoved("attributes", attribute);
            }
        };
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getInheritedAttributes() {
        return new CompositeIterable(this.getInheritedAttributeSets());
    }

    protected Iterable<Iterable<JaxbPersistentAttribute>> getInheritedAttributeSets() {
        return new TransformationIterable<JaxbAttributesContainer, Iterable<JaxbPersistentAttribute>>(this.getInheritedAttributesContainers()){

            protected Iterable<JaxbPersistentAttribute> transform(JaxbAttributesContainer attributesContainer) {
                return attributesContainer.getAttributes();
            }
        };
    }

    protected Iterable<JaxbAttributesContainer> getInheritedAttributesContainers() {
        return new LiveCloneIterable(this.inheritedAttributesContainers.values());
    }

    @Override
    public int getInheritedAttributesSize() {
        int size = 0;
        for (JaxbAttributesContainer attributesContainer : this.getInheritedAttributesContainers()) {
            size += attributesContainer.getAttributesSize();
        }
        return size;
    }

    protected void initializeInheritedAttributes() {
        this.addInheritedAttributesContainer(this.getSuperClass());
    }

    protected void addInheritedAttributesContainer(JaxbClass superClass) {
        if (superClass != null && superClass.getKind() == JaxbType.Kind.TRANSIENT) {
            this.inheritedAttributesContainers.put(superClass, this.buildInheritedAttributesContainer(superClass));
            this.addInheritedAttributesContainer(superClass.getSuperClass());
        }
    }

    protected JaxbAttributesContainer buildInheritedAttributesContainer(JaxbClass jaxbClass) {
        return new GenericJavaAttributesContainer(this, this.buildInheritedAttributesContainerOwner(), jaxbClass.getJavaResourceType());
    }

    protected JaxbAttributesContainer.Owner buildInheritedAttributesContainerOwner() {
        return new JaxbAttributesContainer.Owner(){

            public XmlAccessType getAccessType() {
                return GenericJavaPersistentClass.this.getAccessType();
            }

            public void fireAttributeAdded(JaxbPersistentAttribute attribute) {
                GenericJavaPersistentClass.this.fireItemAdded("inheritedAttributes", attribute);
            }

            public void fireAttributeRemoved(JaxbPersistentAttribute attribute) {
                GenericJavaPersistentClass.this.fireItemRemoved("inheritedAttributes", attribute);
            }
        };
    }

    protected void syncInheritedAttributes() {
        for (JaxbAttributesContainer attributesContainer : this.inheritedAttributesContainers.values()) {
            attributesContainer.synchronizeWithResourceModel();
        }
    }

    protected void updateInheritedAttributes() {
        HashSet contextSuperclasses = CollectionTools.set(this.inheritedAttributesContainers.keySet());
        for (JaxbClass superClass : this.getAncestors()) {
            if (superClass.getKind() != JaxbType.Kind.TRANSIENT) continue;
            boolean match = false;
            Iterator stream = contextSuperclasses.iterator();
            while (stream.hasNext()) {
                JaxbClass contextSuperclass = (JaxbClass)stream.next();
                if (contextSuperclass != superClass) continue;
                stream.remove();
                this.inheritedAttributesContainers.get(contextSuperclass).update();
                match = true;
                break;
            }
            if (match) continue;
            JaxbAttributesContainer container = this.buildInheritedAttributesContainer(superClass);
            this.inheritedAttributesContainers.put(superClass, container);
            this.fireItemsAdded("inheritedAttributes", (Collection)CollectionTools.collection(container.getAttributes()));
        }
        for (JaxbClass superClass : contextSuperclasses) {
            JaxbAttributesContainer container = this.inheritedAttributesContainers.remove(superClass);
            this.fireItemsRemoved("inheritedAttributes", (Collection)CollectionTools.collection(container.getAttributes()));
        }
    }

    @Override
    public boolean isInherited(JaxbPersistentAttribute attribute) {
        if (attribute.getParent() != this) {
            throw new IllegalArgumentException("The attribute is not owned by this GenericJavaPersistentClass");
        }
        return !CollectionTools.contains(this.getAttributes(), (Object)attribute);
    }

    @Override
    public String getJavaResourceAttributeOwningTypeName(JaxbPersistentAttribute attribute) {
        if (attribute.getParent() != this) {
            throw new IllegalArgumentException("The attribute is not owned by this GenericJavaPersistentClass");
        }
        for (JaxbClass inheritedClass : this.inheritedAttributesContainers.keySet()) {
            if (!CollectionTools.contains(this.inheritedAttributesContainers.get(inheritedClass).getAttributes(), (Object)attribute)) continue;
            return inheritedClass.getSimpleName();
        }
        throw new IllegalArgumentException("The attribute is not an inherited attribute");
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            result = attribute.getJavaCompletionProposals(pos, filter, astRoot);
            if (CollectionTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.xmlAdaptable.validate(messages, reporter, astRoot);
        this.validateXmlAnyAttributeMapping(messages, astRoot);
        this.validateXmlAnyElementMapping(messages, astRoot);
        this.validateXmlValueMapping(messages, astRoot);
        this.validateXmlIDs(messages, astRoot);
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            attribute.validate(messages, reporter, astRoot);
        }
    }

    protected void validateXmlValueMapping(List<IMessage> messages, CompilationUnit astRoot) {
        String xmlValueMapping = null;
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            if (attribute.getMappingKey() != "xml-value") continue;
            if (xmlValueMapping != null) {
                messages.add(DefaultValidationMessages.buildMessage(1, "MULTIPLE_XML_VALUE_MAPPINGS_DEFINED", new String[]{attribute.getName(), xmlValueMapping}, attribute.getMapping(), attribute.getMapping().getValidationTextRange(astRoot)));
                continue;
            }
            xmlValueMapping = attribute.getName();
        }
        if (xmlValueMapping != null) {
            for (JaxbPersistentAttribute attribute : this.getAttributes()) {
                if (attribute.getName() == xmlValueMapping || attribute.getMappingKey() == "xml-attribute" || attribute.getMappingKey() == "xml-transient") continue;
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_VALUE_MAPPING_WITH_NON_XML_ATTRIBUTE_MAPPING_DEFINED", new String[]{attribute.getName(), xmlValueMapping}, attribute.getMapping(), attribute.getMapping().getValidationTextRange(astRoot)));
            }
        }
    }

    protected void validateXmlAnyAttributeMapping(List<IMessage> messages, CompilationUnit astRoot) {
        String xmlAnyAttributeMapping = null;
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            if (attribute.getMappingKey() != "xml-any-attribute") continue;
            if (xmlAnyAttributeMapping != null) {
                messages.add(DefaultValidationMessages.buildMessage(1, "MULTIPLE_XML_ANY_ATTRIBUTE_MAPPINGS_DEFINED", new String[]{attribute.getName(), xmlAnyAttributeMapping}, attribute.getMapping(), attribute.getMapping().getValidationTextRange(astRoot)));
                continue;
            }
            xmlAnyAttributeMapping = attribute.getName();
        }
    }

    protected void validateXmlAnyElementMapping(List<IMessage> messages, CompilationUnit astRoot) {
        String xmlAnyElementMapping = null;
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            if (attribute.getMappingKey() != "xml-any-element") continue;
            if (xmlAnyElementMapping != null) {
                messages.add(DefaultValidationMessages.buildMessage(1, "MULTIPLE_XML_ANY_ELEMENT_MAPPINGS_DEFINED", new String[]{attribute.getName(), xmlAnyElementMapping}, attribute.getMapping(), attribute.getMapping().getValidationTextRange(astRoot)));
                continue;
            }
            xmlAnyElementMapping = attribute.getName();
        }
    }

    protected void validateXmlIDs(List<IMessage> messages, CompilationUnit astRoot) {
        String xmlIdMapping = null;
        for (JaxbContainmentMapping containmentMapping : this.getContainmentMappingsWithXmlID()) {
            if (xmlIdMapping != null) {
                messages.add(DefaultValidationMessages.buildMessage(1, "MULTIPLE_XML_IDS_DEFINED", new String[]{containmentMapping.getParent().getName(), xmlIdMapping}, containmentMapping, containmentMapping.getValidationTextRange(astRoot)));
                continue;
            }
            xmlIdMapping = containmentMapping.getParent().getName();
        }
    }

    protected Iterable<JaxbContainmentMapping> getContainmentMappingsWithXmlID() {
        return new FilteringIterable<JaxbContainmentMapping>(this.getContainmentMappings()){

            protected boolean accept(JaxbContainmentMapping containmentMapping) {
                return containmentMapping.getXmlID() != null;
            }
        };
    }

    protected Iterable<JaxbContainmentMapping> getContainmentMappings() {
        return new SubIterableWrapper(this.getContainmentMappings_());
    }

    protected Iterable<JaxbAttributeMapping> getContainmentMappings_() {
        return new FilteringIterable<JaxbAttributeMapping>(this.getAttributeMappings()){

            protected boolean accept(JaxbAttributeMapping attributeMapping) {
                return attributeMapping.getKey() == "xml-element" || attributeMapping.getKey() == "xml-attribute";
            }
        };
    }

    private Iterable<? extends JaxbAttributeMapping> getAttributeMappings() {
        return new TransformationIterable<JaxbPersistentAttribute, JaxbAttributeMapping>(this.getAttributes()){

            protected JaxbAttributeMapping transform(JaxbPersistentAttribute attribute) {
                return attribute.getMapping();
            }
        };
    }

    @Override
    public boolean containsXmlId() {
        return !CollectionTools.isEmpty(this.getContainmentMappingsWithXmlID());
    }
}

