/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OrderColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceOrderColumn2_0Annotation
extends SourceNamedColumnAnnotation
implements OrderColumn2_0Annotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OrderColumn");
    private DeclarationAnnotationElementAdapter<Boolean> nullableDeclarationAdapter = this.buildNullableDeclarationAdapter();
    private AnnotationElementAdapter<Boolean> nullableAdapter = this.buildNullableAdapter();
    private Boolean nullable;
    private DeclarationAnnotationElementAdapter<Boolean> insertableDeclarationAdapter = this.buildInsertableDeclarationAdapter();
    private AnnotationElementAdapter<Boolean> insertableAdapter = this.buildInsertableAdapter();
    private Boolean insertable;
    private DeclarationAnnotationElementAdapter<Boolean> updatableDeclarationAdapter = this.buildUpdatableDeclarationAdapter();
    private AnnotationElementAdapter<Boolean> updatableAdapter = this.buildUpdatableAdapter();
    private Boolean updatable;

    public SourceOrderColumn2_0Annotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.nullable = this.buildNullable(astRoot);
        this.insertable = this.buildInsertable(astRoot);
        this.updatable = this.buildUpdatable(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncNullable(this.buildNullable(astRoot));
        this.syncInsertable(this.buildInsertable(astRoot));
        this.syncUpdatable(this.buildUpdatable(astRoot));
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OrderColumn";
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    protected String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    public Boolean getNullable() {
        return this.nullable;
    }

    @Override
    public void setNullable(Boolean nullable) {
        if (this.attributeValueHasChanged(this.nullable, nullable)) {
            this.nullable = nullable;
            this.nullableAdapter.setValue((Object)nullable);
        }
    }

    private void syncNullable(Boolean astNullable) {
        Boolean old = this.nullable;
        this.nullable = astNullable;
        this.firePropertyChanged("nullable", old, astNullable);
    }

    private Boolean buildNullable(CompilationUnit astRoot) {
        return (Boolean)this.nullableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNullableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nullableDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildNullableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getNullableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildNullableAdapter() {
        return this.buildBooleanElementAdapter(this.nullableDeclarationAdapter);
    }

    String getNullableElementName() {
        return "nullable";
    }

    @Override
    public Boolean getInsertable() {
        return this.insertable;
    }

    @Override
    public void setInsertable(Boolean insertable) {
        if (this.attributeValueHasChanged(this.insertable, insertable)) {
            this.insertable = insertable;
            this.insertableAdapter.setValue((Object)insertable);
        }
    }

    private void syncInsertable(Boolean astInsertable) {
        Boolean old = this.insertable;
        this.insertable = astInsertable;
        this.firePropertyChanged("insertable", old, astInsertable);
    }

    private Boolean buildInsertable(CompilationUnit astRoot) {
        return (Boolean)this.insertableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getInsertableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.insertableDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildInsertableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getInsertableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildInsertableAdapter() {
        return this.buildBooleanElementAdapter(this.insertableDeclarationAdapter);
    }

    String getInsertableElementName() {
        return "insertable";
    }

    @Override
    public Boolean getUpdatable() {
        return this.updatable;
    }

    @Override
    public void setUpdatable(Boolean updatable) {
        if (this.attributeValueHasChanged(this.updatable, updatable)) {
            this.updatable = updatable;
            this.updatableAdapter.setValue((Object)updatable);
        }
    }

    private void syncUpdatable(Boolean astUpdatable) {
        Boolean old = this.updatable;
        this.updatable = astUpdatable;
        this.firePropertyChanged("updatable", old, astUpdatable);
    }

    private Boolean buildUpdatable(CompilationUnit astRoot) {
        return (Boolean)this.updatableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getUpdatableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.updatableDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildUpdatableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getUpdatableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildUpdatableAdapter() {
        return this.buildBooleanElementAdapter(this.updatableDeclarationAdapter);
    }

    String getUpdatableElementName() {
        return "updatable";
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.nullable == null && this.insertable == null && this.updatable == null;
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.nullableDeclarationAdapter = this.buildNullableDeclarationAdapter();
        this.nullableAdapter = this.buildNullableAdapter();
        this.insertableDeclarationAdapter = this.buildInsertableDeclarationAdapter();
        this.insertableAdapter = this.buildInsertableAdapter();
        this.updatableDeclarationAdapter = this.buildUpdatableDeclarationAdapter();
        this.updatableAdapter = this.buildUpdatableAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("nullable", this.nullable);
        this.nullable = null;
        map.put("insertable", this.insertable);
        this.insertable = null;
        map.put("updatable", this.updatable);
        this.updatable = null;
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setNullable((Boolean)map.get("nullable"));
        this.setInsertable((Boolean)map.get("insertable"));
        this.setUpdatable((Boolean)map.get("updatable"));
    }
}

