/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.SortDirectionNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class OrderByItemNode
extends Node {
    private SortDirectionNode direction = null;
    private Object orderByItem = null;
    private Node orderNode = null;

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.orderNode == null) {
            if (this.orderByItem instanceof Node) {
                this.orderNode = (Node)this.orderByItem;
            } else {
                this.orderNode = context.pathForVariable((String)this.orderByItem);
                if (this.orderNode == null) {
                    throw JPQLException.nonExistantOrderByAlias(context.getQueryInfo(), this.getLine(), this.getColumn(), (String)this.orderByItem);
                }
            }
        }
        if (this.orderNode != null) {
            this.orderNode.validate(context);
            Object type = this.orderNode.getType();
            this.setType(type);
            if (!typeHelper.isOrderableType(type)) {
                throw JPQLException.expectedOrderableOrderByItem(context.getQueryInfo(), this.orderNode.getLine(), this.orderNode.getColumn(), this.orderNode.getAsString(), typeHelper.getTypeName(type));
            }
        }
    }

    public Expression generateExpression(GenerationContext context) {
        boolean oldCheckState = context.shouldCheckSelectNodeBeforeResolving();
        ((SelectGenerationContext)context).checkSelectNodeBeforeResolving(true);
        Expression orderByExpression = null;
        if (this.orderByItem instanceof Node) {
            this.orderNode = (Node)this.orderByItem;
            orderByExpression = this.orderNode.generateExpression(context);
        } else {
            orderByExpression = context.expressionFor((String)this.orderByItem);
            if (orderByExpression == null) {
                return null;
            }
        }
        orderByExpression = this.getDirection().addToExpression(orderByExpression, context);
        ((SelectGenerationContext)context).checkSelectNodeBeforeResolving(oldCheckState);
        return orderByExpression;
    }

    public SortDirectionNode getDirection() {
        if (this.direction == null) {
            this.setDirection(new SortDirectionNode());
        }
        return this.direction;
    }

    public Object getOrderByItem() {
        return this.orderByItem;
    }

    public void setDirection(SortDirectionNode direction) {
        this.direction = direction;
    }

    public void setOrderByItem(Object orderByItem) {
        this.orderByItem = orderByItem;
    }
}

