unit BaseListUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TBaseList = class
  private
    FList: TList;
    function GetCount: Cardinal;        
    function GetItem(index: integer): Pointer; virtual;
  protected
    function DoAllocMem(Item: Pointer): Pointer; virtual; abstract;
    procedure DoFreeMem(index: integer); virtual; abstract;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Item: Pointer): Pointer;
    function Insert(Index: Integer; Item: Pointer): Pointer;
    procedure delete(index: integer);
    procedure Sort(Compare: TListSortCompare);
    procedure Clear;
    procedure Assign(ListA: TBaseList);
    property Count: Cardinal read GetCount;     
    property Items[index: integer]: Pointer read GetItem; default;
  end;

implementation

constructor TBaseList.Create;
begin
  inherited;
  FList := TList.Create;
end;

destructor TBaseList.Destroy;
begin
  Clear;
  FList.Free;
  inherited;
end;

function TBaseList.Add(Item: Pointer): Pointer;
begin
  result := Insert(Count, Item);
end;

procedure TBaseList.delete(index: integer);
begin
  DoFreeMem(index);
  FList.Delete(index);
end;

function TBaseList.Insert(Index: Integer; Item: Pointer): Pointer;
var
  Ptr: Pointer;
begin
  Ptr := DoAllocMem(Item);
  FList.Insert(Index, Ptr);
  result := Ptr;
end;

procedure TBaseList.Clear;
var
  i: integer;
begin
  if Count = 0 then exit;
  for i := Count - 1 downto 0 do
    Delete(i);
end;

procedure TBaseList.Sort(Compare: TListSortCompare);
begin
  FList.Sort(Compare);
end;

function TBaseList.GetCount: Cardinal;
begin
  result := FList.Count;
end;

function TBaseList.GetItem(index: integer): Pointer;
begin
  if (index > Count - 1) or (Count = 0) or (index < 0) then
    Raise Exception.Create('index out of range!');
  result := FList[index];
end;

procedure TBaseList.Assign(ListA: TBaseList);
var
  i: integer;
begin
  for i := 0 to ListA.Count - 1 do
  begin
    Add(ListA[i]);
  end;
end;

end.
