unit ExpEditorUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
  ExpUnit2;

type
  TExpEditor = class(TForm)
    leOrd: TLabeledEdit;
    leName: TLabeledEdit;
    leForward: TLabeledEdit;
    GroupBox1: TGroupBox;
    leRVA: TLabeledEdit;
    leOffset: TLabeledEdit;
    Button1: TButton;
    Button2: TButton;
    rbOffset: TRadioButton;
    rbRVA: TRadioButton;
    Label1: TLabel;
    procedure FormShow(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure leForwardChange(Sender: TObject);
    procedure leNameMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    FExp: TExport;
    function SaveExp: Boolean;
    procedure SetExp(Exp: TExport);
    procedure AssignExp(var Des: TExport; Src: TExport);
    procedure FreeExp(Exp: TExport);
  public
    { Public declarations }
    destructor Destroy; override;
    property Exp: TExport read FExp write SetExp;
  end;

var
  ExpEditor: TExpEditor;

implementation

{$R *.dfm}

destructor TExpEditor.Destroy;
begin
  FreeExp(FExp);
  inherited;
end;

procedure TExpEditor.AssignExp(var Des: TExport; Src: TExport);
var
  l: integer;
begin
  FreeExp(FExp);
  CopyMemory(@Des, @Src, SizeOf(TExport));
  l := length(Src.Name);
  if l > 0 then
  begin
    Des.Name := AllocMem(l + 1);
    CopyMemory(Des.Name, Src.Name, l);
  end;
  l := length(Src.ForwardFunc);
  if l > 0 then
  begin
    Des.ForwardFunc := AllocMem(l + 1);
    CopyMemory(Des.ForwardFunc, Src.ForwardFunc, l);
  end;
end;

procedure TExpEditor.FreeExp(Exp: TExport);
var
  l: integer;
begin
  l := length(Exp.Name);
  if l > 0 then
  begin
    FreeMem(Exp.Name);
  end;
  l := length(Exp.ForwardFunc);
  if l > 0 then
  begin
    FreeMem(Exp.ForwardFunc);
  end;
end;

procedure TExpEditor.SetExp(Exp: TExport);
begin
  AssignExp(FExp, Exp);
end;

procedure TExpEditor.FormShow(Sender: TObject);
begin
  leOrd.Text := inttohex(FExp.Orindal, 4);
  leRVA.Text := inttohex(FExp.FuncRVA, 8);
//  leOffset.Text := inttohex(RVAtoOffset(Exp.FuncRVA), 8);
  leName.Text := FExp.Name;
  leForward.Text := FExp.ForwardFunc;
  leForwardChange(nil);
  leOrd.SelectAll;
  leOrd.SetFocus;
end;

function TExpEditor.SaveExp: Boolean;
var
  l: integer;
  t: string;
  E: Integer;
begin
  result := false;
  Val('$' + Trim(leOrd.Text), FExp.Orindal, E);
  if E <> 0 then
  begin
    ShowMessage('Function Ordinal ' + Trim(leOrd.Text) + ' is not a HEX number!');
    leOrd.SetFocus;
    exit;
  end;
  Val('$' + Trim(leRVA.Text), FExp.FuncRVA, E);   
  if E <> 0 then
  begin
    ShowMessage('Function RVA ' + Trim(leRVA.Text) + ' is not a HEX number!');  
    leRVA.SetFocus;
    exit;
  end;
  t := Trim(leName.Text);
  l := length(t);
  if FExp.Name <> nil then
  begin
    FreeMem(FExp.Name);
    FExp.Name := nil;
  end;
  if l > 0 then
  begin
    FExp.Name := AllocMem(l + 1);
    CopyMemory(FExp.Name, PChar(t), l);
  end;

  t := Trim(leForward.Text);
  l := length(t);
  if FExp.ForwardFunc <> nil then
  begin
    FreeMem(FExp.ForwardFunc);
    FExp.ForwardFunc := nil;
  end;
  if l > 0 then
  begin
    FExp.ForwardFunc := AllocMem(l + 1);
    CopyMemory(FExp.ForwardFunc, PChar(t), l);
  end;
  result := true;
end;

procedure TExpEditor.Button2Click(Sender: TObject);
begin
  ModalResult := mrCancel;
  Hide;
end;

procedure TExpEditor.Button1Click(Sender: TObject);
begin
  if SaveExp then
  begin
    Modalresult := mrOK;
    Hide;
  end;
end;

procedure TExpEditor.leForwardChange(Sender: TObject);
begin
  leRVA.Enabled := length(leForward.Text) = 0;
  rbRVA.Enabled := leRVA.Enabled;
end;

procedure TExpEditor.leNameMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  (Sender as TLabeledEdit).SelectAll;
end;

end.
