unit ExpUnit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,
  JwaWinnt, BaseListUnit, UtilUnit;

type
  PExport = ^TExport;
  TExport = record
    Orindal: WORD;
    Name: PChar;
    FuncRVA: DWORD;
    ForwardFunc: PChar;
  end;

type
  TExportList = class(TBaseList)
  private
  protected
    function DoAllocMem(Item: Pointer): Pointer; override;
    procedure DoFreeMem(index: integer); override;
  public
  end;

type
  TExports = class
  private
    FExpList: TExportList;
    FExpPtr: PImageExportDirectory;
    FExpSize: Cardinal;
    FNewExpPtr: PImageExportDirectory;
    FNewExpSize: Cardinal;
    FDllName: PChar;
    FFuncntionCount: Cardinal;
    FNameCount: Cardinal;
    FExpRVA: Cardinal;
    function GetDllName: string;
    function DoAnalyse(pExp: Pointer): Boolean;
    function ValidateExp(pExp: Pointer): Boolean;
    function RVAtoPtr(RVA: Cardinal): Pointer;
    function GetItem(index: integer): TExport;
    function GetCount: Cardinal;
    procedure Clear;
    procedure SetDllName(Dll: String);
  public
    constructor Create;
    destructor Destroy; override;
    function Analyse: Boolean;
    function Assign(SrcExports: TExports): Boolean;
    procedure Cleanup;
    function AssembleExp(BaseRVA: Cardinal): Cardinal;
    procedure FixBaseRVA(NewBaseRVA: Cardinal; OriginBaseRVA: Cardinal);
    procedure AddExp(NewExp: TExport);           //һ
    procedure ModifyExp(index: integer; NewExp: TExport);  //޸е
                                                //NewExpforwardΪnil,RVA
    procedure DeleteExp(index: integer);         //ɾһ
    function FindByOrd(Ordinal: integer): integer;
    property ExpPtr: PImageExportDirectory read FExpPtr write FExpPtr;  //Pointer to ImageExportDirectory
    property ExpRVA: Cardinal read FExpRVA write FExpRVA;      //ImageExportDirectory RVA
    property ExpSize: Cardinal read FExpSize write FExpSize;   //Export directory size
    property Items[index: integer]: TExport read GetItem; default;
    property DllName: String read GetDllName write SetDllName;
    property nFunction: Cardinal read FFuncntionCount;
    property nName: Cardinal read FNameCount;
    property ValidCount: Cardinal read GetCount;
    property NewExpPtr: PImageExportDirectory read FNewExpPtr;
    property NewExpSize: Cardinal read FNewExpSize;
  end;

implementation
  
constructor TExports.Create;
begin
  inherited;
  FExpList := TExportList.Create;
  Cleanup;
end;

destructor TExports.Destroy;
begin
  Cleanup;
  FExpList.Free;
  inherited;
end;

procedure TExports.Cleanup;
begin
  Clear;
end;

procedure TExports.Clear;
begin
  if FNewExpPtr <> nil then
    FreeMem(FNewExpPtr);
  FNewExpPtr := nil;
  if FDllName <> nil then
    FreeMem(FDllName);
  FDllName := nil;
  FFuncntionCount := 0;
  FNameCount := 0;
  FExpList.Clear;
end;

function TExports.GetDllName: string;
begin
  result := FDllName;
end;

procedure TExports.SetDllName(Dll: String);
var
  lDll: integer;
begin
  lDll := length(Dll);
  FDllName := AllocMem(lDll + 1);
  CopyMemory(FDllName, PChar(Dll), lDll);       //dllname
end;

function TExports.ValidateExp(pExp: Pointer): Boolean;
begin
  result := false;
  if (pExp = nil) or (IsBadReadPtr(pExp, SizeOf(TImageExportDirectory))) then
    exit;
  if (ExpSize = 0) then
    exit;
  result := true;
end;

function TExports.RVAtoPtr(RVA: Cardinal): Pointer;
begin
  result := OffsetPointer(ExpPtr, RVA - ExpRVA);
end;

function TExports.GetItem(index: integer): TExport;
begin
  result := PExport(FExpList[index])^;
end;

function TExports.GetCount: Cardinal;
begin
  result := FExpList.Count;
end;

function TExports.DoAnalyse(pExp: Pointer): Boolean;
var
  ExpCount: integer;
  pAddr: PDWORD;
  pName0, pName1: PDWORD;
  pOrdinal0, pOrdinal1: PWORD;
  ExpFound: Boolean;
  tmpExp: PExport;
  i, j: Cardinal;
begin
  Cleanup;
  SetDllName(PChar(RVAtoPtr(ExpPtr^.Name)));

  ExpCount := ExpPtr^.NumberOfFunctions;
  pAddr := RVAtoPtr(ExpPtr^.AddressOfFunctions);
  pName0 := RVAtoPtr(ExpPtr^.AddressOfNames);
  pOrdinal0 := RVAtoPtr(ExpPtr^.AddressOfNameOrdinals);
  tmpExp := AllocMem(SizeOf(TExport));  
  FFuncntionCount := ExpCount;

  try
    for i := 0 to ExpCount - 1 do
    begin
      if pAddr^ <> 0 then
      begin
        ExpFound := false;
        pName1 := pName0;
        pOrdinal1 := pOrdinal0;
        ZeroMemory(tmpExp, SizeOf(TExport));
        for j := 0 to ExpPtr^.NumberOfNames - 1 do        //ordinal˳dump
        begin
          if pOrdinal1^ = i then
          begin
            tmpExp^.Name := RVAtoPtr(pName1^);
            ExpFound := true;
            break;
          end;
          inc(pOrdinal1);
          inc(pName1);
        end;  // for j
        if ExpFound then
          tmpExp^.Orindal := pOrdinal1^ + ExpPtr^.Base
        else
          tmpExp^.Orindal := i + ExpPtr^.Base;

        tmpExp^.FuncRVA := pAddr^;

        if (pAddr^ >= ExpRVA) and (pAddr^ <= ExpRVA + ExpSize) then
        begin
          tmpExp^.ForwardFunc := RVAtoPtr(pAddr^);
        end;

        AddExp(tmpExp^);                                    //FExpList

      end;  //if pAddr^ <> 0
      inc(pAddr);
    end;  // for i
  finally
    FreeMem(tmpExp);
  end;

  result := true;
end;
       
function TExports.Analyse: Boolean;
begin
  result := false;
  if ExpPtr = nil then
    exit;           
  if not ValidateExp(ExpPtr) then
    exit;
  result := DoAnalyse(ExpPtr);
end;

function TExports.Assign(SrcExports: TExports): Boolean;
label BadExp;
begin
  result := false;
  if (SrcExports.nFunction = 0) or
     (SrcExports.ExpPtr = nil) then
    goto BadExp;
  ExpPtr := SrcExports.ExpPtr;
  ExpRVA := SrcExports.ExpRVA;
  ExpSize := SrcExports.ExpSize;
  if not ValidateExp(ExpPtr) then
    goto BadExp;
  if not DoAnalyse(ExpPtr) then
    goto BadExp;
  result := true;
  exit;
BadExp:
  Cleanup;
end;

function CompareNames(Item1, Item2: Pointer): Integer;
begin
  Result := CompareStr(PExport(Item1)^.Name, PExport(Item2)^.Name);
end;

function TExports.AssembleExp(BaseRVA: DWORD): DWORD;
{
Named exp correct!
Forwarded exp correct!
ordinal only correct!
}
var
  lAddr, lNAT, lName, lOrdinal: Cardinal;     //ֵSize
  lForward, lDllName: Cardinal;               //ֵSize
  ExpSize: Cardinal;                          //Export tableSize
  i, l: Cardinal;                         
  NewExp: PImageExportDirectory;              //ָexport tableָ
  AddrCount, NameCount: Cardinal;             //NumberOfFunctions, NumberOfNames
  OrdBase: Cardinal;                          //Ordinal base
  pAddr: PDWORD;                              //ʱָexport tableӦֵָ
  pNAT: PDWORD;
  pName: Pointer;
  pOrdinal: PWORD;
  pForward: Pointer;
  pDllName: Pointer;
  NATBaseRVA: Cardinal;                       //NATĻ׼RVA
  ForwardBaseRVA: Cardinal;                   //ForwardĻ׼RVA
  TmpExpList: TExportList;
  SrcExp: TImageExportDirectory;
begin
//  Clear;
//  Analyse;

  if FNewExpPtr <> nil then
  begin
    FreeMem(FNewExpPtr);
    FNewExpPtr := nil;
  end;
  lName := 0;
  lNAT := 0;
  lOrdinal :=0;
  lForward := 0;
  AddrCount := FFuncntionCount;
  NameCount := FNameCount;
  lAddr := AddrCount * 4;

  if ExpPtr <> nil then
    CopyMemory(@SrcExp, ExpPtr, SizeOf(TImageExportDirectory))
  else
  begin
    ZeroMemory(@SrcExp, SizeOf(TImageExportDirectory));
    SrcExp.Base := 1;
  end;

  TmpExpList := TExportList.Create;
  TmpExpList.Assign(FExpList);
  TmpExpList.Sort(@CompareNames);    //!!!

  for i := 0 to ValidCount - 1 do
  begin
    with PExport(TmpExpList.Items[i])^ do
    begin
      if Name <> nil then
      begin
        l := length(Name) + 1;
        inc(lOrdinal, 2);
        inc(lNAT, 4);
        inc(lName, l);
      end;
      if ForwardFunc <> nil then
      begin
        l := length(ForwardFunc) + 1;
        inc(lForward, l);
      end;
    end;
  end;
  lDllName := length(DllName) + 1;
  ExpSize := SizeOf(TImageExportDirectory) + lAddr + lOrdinal + lDllName +
             lNAT + lName + lForward;        

  NewExp := AllocMem(ExpSize);
  CopyMemory(NewExp, @SrcExp, SizeOf(TImageExportDirectory));
  pAddr := OffsetPointer(NewExp, SizeOf(TImageExportDirectory));      //1
  pNAT :=  OffsetPointer(pAddr, lAddr);                         //2
  pOrdinal := OffsetPointer(pNAT, lNAT);                             //3
  pDllName := OffsetPointer(pOrdinal, lOrdinal);                      //4
  pName := OffsetPointer(pDllName, lDllName);                                //5
  pForWard := OffsetPointer(pName, lName);                            //6

  OrdBase := SrcExp.Base;
  NewExp^.NumberOfFunctions := AddrCount;
  NewExp^.NumberOfNames := NameCount;
  NewExp^.AddressOfFunctions := BaseRVA + SizeOf(TImageExportDirectory);
  NewExp^.AddressOfNames := NewExp^.AddressOfFunctions + lAddr;
  NewExp^.AddressOfNameOrdinals := NewExp^.AddressOfNames + lNAT;
  NewExp^.Name := NewExp^.AddressOfNameOrdinals + lOrdinal;
  NATBaseRVA := BaseRVA + ExpSize - lNAT - lOrdinal - lDllName - lName - lForward;
  ForwardBaseRVA := BaseRVA + ExpSize - lForward;


  CopyMemory(pDllName, PChar(DllName), lDllName - 1);
  for i := 0 to ValidCount - 1 do
  begin
    with PExport(TmpExpList.Items[i])^ do
    begin
      PDWORD(DWORD(pAddr) + (Orindal - OrdBase) * 4)^ := FuncRVA;
      if Name <> nil then
      begin
        l := length(Name);
        pNAT^ := NATBaseRVA + DWORD(pName) - DWORD(pNAT);
        CopyMemory(pName, Name, l);
        pOrdinal^ := Orindal - OrdBase;
        inc(pNAT);
        inc(pOrdinal);
        inc(DWORD(pName) ,l + 1);
        inc(NATBaseRVA, 4);
      end;
      if ForwardFunc <> nil then
      begin
        PDWORD(DWORD(pAddr) + (Orindal - OrdBase) * 4)^ := ForwardBaseRVA;
        l := length(ForwardFunc);
        CopyMemory(pForward, ForwardFunc, l);
        inc(DWORD(pForward), l + 1);
        inc(ForwardBaseRVA, l + 1);
      end;
    end;
  end;
  
  TmpExpList.Free;
(*  showmessage('ExpSize:' + inttohex(ExpSize, 8) + #13 +
              ' ;lAddr:' + inttohex(lAddr, 8) + ' ;lNAT:' + inttohex(lNAT, 8) + #13 +
              ' ;lName:' + inttohex(lName, 8) + ' ;lOrdinal:' + inttohex(lOrdinal, 8) + #13 +
              ' ;lForward:' + inttohex(lForward, 8) + ' ;lDllName:' + inttohex(lDllName, 8));  *)
  FNewExpPtr := NewExp;
  FNewExpSize := ExpSize;
  result := ExpSize;
end;

procedure TExports.FixBaseRVA(NewBaseRVA: Cardinal; OriginBaseRVA: Cardinal);
var
  i: Cardinal;
  j: integer;

  pNAT: PDWORD;
  pAddr: PDWORD;
begin
  pNAT := OffsetPointer(FNewExpPtr, FNewExpPtr^.AddressOfNames);
  pAddr := OffsetPointer(FNewExpPtr, FNewExpPtr^.AddressOfFunctions);

  j := NewBaseRVA - OriginBaseRVA;

  inc(FNewExpPtr^.AddressOfFunctions, j);
  inc(FNewExpPtr^.AddressOfNames, j);
  inc(FNewExpPtr^.AddressOfNameOrdinals, j);
  inc(FNewExpPtr^.Name, j);

  for i := 0 to FNameCount - 1 do
  begin
    inc(pNAT^, j);
    inc(pNAT);
  end;

  for i := 0 to FFuncntionCount - 1 do
  begin
    if pAddr^ < FNewExpSize then
    begin
      inc(pAddr^, j);
    end;
  end;
end;

procedure TExports.AddExp(NewExp: TExport);
begin
  if FFuncntionCount < NewExp.Orindal then
    FFuncntionCount := NewExp.Orindal;
  if length(NewExp.Name) <> 0 then
    inc(FNameCount);
  FExpList.Add(@NewExp);
end;

procedure TExports.ModifyExp(index: integer; NewExp: TExport);
begin
  DeleteExp(index);
  if length(NewExp.Name) <> 0 then
    inc(FNameCount);
  FExpList.Insert(index, @NewExp);
  if FFuncntionCount < NewExp.Orindal then
    FFuncntionCount := NewExp.Orindal;
end;

procedure TExports.DeleteExp(index: integer);
begin
  if FFuncntionCount = Items[index].Orindal then
    FFuncntionCount := Items[index].Orindal - 1;
  if length(Items[index].Name) <> 0 then
    dec(FNameCount);
  FExpList.Delete(index);
end;

function TExports.FindByOrd(Ordinal: integer): integer;
var
  i: integer;
begin
  result := -1;
  for i := 0 to ValidCount - 1 do
  begin
    if Items[i].Orindal = Ordinal then
    begin
      result := i;
      Break;
    end;
  end;
end;

//TExportsList  export list

function TExportList.DoAllocMem(Item: Pointer): Pointer;
var                                          //һItem,ָ
  tmpExp: PExport;
  l : integer;
begin
  tmpExp := AllocMem(SizeOf(TExport));
  tmpExp^.FuncRVA := PExport(Item)^.FuncRVA;
  tmpExp^.Orindal := PExport(Item)^.Orindal;
  if PExport(Item)^.Name <> nil then
  begin
    l := length(PExport(Item)^.Name) + 1;
    tmpExp^.Name := AllocMem(l);
    CopyMemory(tmpExp^.Name, PExport(Item)^.Name, l);
  end
  else
  begin
    tmpExp^.Name := nil;
  end;
  if PExport(Item)^.ForwardFunc <> nil then
  begin
    l := length(PExport(Item)^.ForwardFunc) + 1;
    tmpExp^.ForwardFunc := AllocMem(l);
    CopyMemory(tmpExp^.ForwardFunc, PExport(Item)^.ForwardFunc, l);
  end
  else
    tmpExp^.ForwardFunc := nil;
  result := tmpExp;
end;


procedure TExportList.DoFreeMem(index: integer);
var
  tmpExp: PExport;
begin
  tmpExp := Items[index];
  if tmpExp^.Name <> nil then
    FreeMem(tmpExp^.Name);
  if tmpExp^.ForwardFunc <> nil then
    FreeMem(tmpExp^.ForwardFunc);
  FreeMem(tmpExp);
end;
end.
