unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,
  ShellAPI,
  CommCtrl,
  JwaWinnt,
  ExpEditorUnit, ExpUnit2, PEHeaderUnit, UtilUnit, TestFormUnit, ExpLocateUnit,
  AboutUnit,
  ComCtrls, ToolWin, Menus, ImgList, ActnList, ActnMan, ExtCtrls, StdCtrls;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mmOpen: TMenuItem;
    mmClose: TMenuItem;
    N1: TMenuItem;
    mmSave: TMenuItem;
    mmExportToText: TMenuItem;
    N2: TMenuItem;
    mmExit: TMenuItem;
    Help1: TMenuItem;
    mmAbout: TMenuItem;
    ToolBar1: TToolBar;
    tbOpen: TToolButton;
    tbSave: TToolButton;
    tbSaveAs: TToolButton;
    ToolButton5: TToolButton;
    tbLocate: TToolButton;
    ToolButton7: TToolButton;
    StatusBar1: TStatusBar;
    lvExp: TListView;
    PopupMenu1: TPopupMenu;
    pmModify: TMenuItem;
    pmAdd: TMenuItem;
    pmDelete: TMenuItem;
    OpenDialog1: TOpenDialog;
    Edit1: TMenuItem;
    mmLocate: TMenuItem;
    ImageList1: TImageList;
    ToolButton4: TToolButton;
    N3: TMenuItem;
    mmModify: TMenuItem;
    mmAdd: TMenuItem;
    mmDelete: TMenuItem;
    N4: TMenuItem;
    mmRefresh: TMenuItem;
    mmSaveAs: TMenuItem;
    SaveDialog1: TSaveDialog;
    tbExportToText: TToolButton;
    ActionManager1: TActionManager;
    ActRefresh: TAction;
    ActModify: TAction;
    ActAdd: TAction;
    ActDelete: TAction;
    ActAbout: TAction;
    ActOpen: TAction;
    ActClose: TAction;
    ActSave: TAction;
    ActSaveAs: TAction;
    mmReload: TMenuItem;
    N6: TMenuItem;
    tbRefresh: TToolButton;
    ToolButton2: TToolButton;
    ools1: TMenuItem;
    mmTest: TMenuItem;
    ActTest: TAction;
    ImageList2: TImageList;
    ActFn: TAction;
    mmFindnext: TMenuItem;
    ActExport: TAction;
    ImageList3: TImageList;
    ActFind: TAction;
    procedure WithDropFiles(var Msg: TMessage); message WM_DROPFILES;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Add1Click(Sender: TObject);
    procedure lvExpDblClick(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure mmExitClick(Sender: TObject);
    procedure Refresh1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure Refresh2Click(Sender: TObject);
    procedure lvExpChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure ActRefreshExecute(Sender: TObject);
    procedure ActModifyExecute(Sender: TObject);
    procedure ActAddExecute(Sender: TObject);
    procedure ActAboutExecute(Sender: TObject);
    procedure ActDeleteExecute(Sender: TObject);
    procedure ActOpenExecute(Sender: TObject);
    procedure ActCloseExecute(Sender: TObject);
    procedure ActSaveExecute(Sender: TObject);
    procedure ActSaveAsExecute(Sender: TObject);
    procedure mmReloadClick(Sender: TObject);
    procedure ActTestExecute(Sender: TObject);
    procedure lvExpColumnClick(Sender: TObject; Column: TListColumn);
    procedure ActFnExecute(Sender: TObject);
    procedure ActExportExecute(Sender: TObject);
    procedure ActFindExecute(Sender: TObject);
  private
    PeName: string;
    PEStream: TMemoryStream;
    PEPtr: Pointer;
    PEHeader: TPEHeader;
    PEExports: TExports;
    SortColIndex: integer;
    procedure LoadFile(fn: string);
    procedure CloseFile;
    function DumpExport: Boolean;
    procedure ListExport;
    procedure InsertExpListItem(index: integer; Exp: TExport);
    procedure SetMenuState;
    function RVAtoPtr(RVA: Cardinal): Pointer;
    function SaveChange(Fn: String; MakeBackup: Boolean = true): Boolean;
    procedure DrawLvSortState(ShowArrow: Boolean = true);
    procedure UpdateInfo;
    procedure Locate;
    function DoLocate(var index: integer; Ordinal: String; FName: String; WWO: Boolean; FromIndex: integer = 0): Boolean;
  public
    { Public declarations }
    procedure ListDump;
  end;

const
  VerDef = 'v0.50';

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

var
  LvSortAsc: Boolean;

function CustomSortProc( Item1, Item2 : TListItem; lParam : LongInt ) : Integer; stdcall;
begin
   if lParam > 0 then
      result := - CompareStr(Item1.SubItems.Strings[lParam - 1],
                             Item2.SubItems.Strings[lParam - 1])
   else
      result := - CompareStr(Item1.Caption, Item2.Caption);
   if not LvSortAsc then
   begin
     result := - result;
   end;
end;

procedure TMainForm.WithDropFiles(var Msg: TMessage);
Var
  Buffer: PChar;
  i: integer;
begin
  i := DragQueryFile(Msg.WParam, 0, nil, 0) + 1;
  GetMem(Buffer, i);
  try
    DragQueryFile(Msg.WParam, 0, Buffer, i);
    DragFinish(Msg.WParam);
    LoadFile(Buffer);
    SetForeGroundWindow(Handle);
  finally
    FreeMem(Buffer);
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  DragAcceptFiles(Handle, true);
  PEStream := TMemoryStream.Create;
  PEHeader := TPEHeader.Create;
  PEExports := TExports.Create;
  SetMenuState;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  PEExports.Free;
  PEHeader.Free;
  PEStream.Free;
end;

procedure TMainForm.LoadFile(fn: string);
var
  LvShowArrow: Boolean;
begin
  CloseFile;
  PeName := fn;
  PEStream.LoadFromFile(PeName);
  PEPtr := PEStream.Memory;   
  LvShowArrow := true;
  if PEHeader.AssignHeader(PEPtr) then
  begin
    if not DumpExport then
    begin
      ShowMessage('No export table found!');

      PEExports.DllName := 'noname.Cream';
      PEExports.ExpPtr := nil;
      UpdateInfo;
      LvShowArrow := false;
    end;
  end
  else
  begin
    ShowMessage('Error when analyse PE header!');
    CloseFile;
  end;
  LvSortAsc := false;
  SortColIndex := 0;
  SetMenuState;
  DrawLvSortState(LvShowArrow);
end;

procedure TMainForm.CloseFile;
begin
  PEStream.Clear;
  PeName := '';
  lvExp.Clear;
  SetMenuState;
  DrawLvSortState(false);
end;

function TMainForm.RVAtoPtr(RVA: Cardinal): Pointer;
begin
  result := OffsetPointer(PEPtr, PEHeader.RVAtoOffset(RVA));
end;

function TMainForm.DumpExport: Boolean;
var
  tmp: Cardinal;
begin
  result := false;
  tmp := PEHeader.DataDirectorys[IMAGE_DIRECTORY_ENTRY_EXPORT]^.VirtualAddress;
  if (tmp = 0) then
  begin
    exit;
  end;
  PEExports.ExpPtr := RVAtoPtr(tmp);
  PEExports.ExpRVA := tmp;
  PEExports.ExpSize := PEHeader.DataDirectorys[IMAGE_DIRECTORY_ENTRY_EXPORT]^.Size;
  if not PEExports.Analyse then
  begin
    Showmessage('Analys export failed!');
    exit;
  end;
  ListDump;
  result := true;
end;

procedure TMainForm.ListDump;
begin
  if PEExports.ValidCount > 0 then
    ListExport;
end;

procedure TMainForm.UpdateInfo;
begin
  StatusBar1.Panels[0].Text := 'Total functions :' + inttostr(PEExports.nFunction);
  StatusBar1.Panels[1].Text := 'Named functions :' + inttostr(PEExports.nName);
  Caption := 'Export Function Explorer - ' + PeName + '  [' + PEExports.DllName + ']';
end;

procedure TMainForm.ListExport;
var
  i: integer;
begin
  lvExp.Clear;
  for i := 0 to PEExports.ValidCount - 1 do
  begin
    InsertExpListItem(i, PEExports[i]);
  end;
  UpdateInfo;
end;

procedure TMainForm.InsertExpListItem(index: integer; Exp: TExport);
var
  ListItem: TListItem;
  fName, forName: string;
  fOrd, fRVA, fOffset: Cardinal;
begin
  fName := Exp.Name;
  if fName = '' then fName := '(Ordinal only)';
  forName := Exp.ForwardFunc;
  fOrd := Exp.Orindal;
  fRVA := Exp.FuncRVA;
  fOffset := PEHeader.RVAtoOffset(fRVA);
  if index <= lvExp.Items.Count - 1 then
    ListItem := lvExp.Items[index]
  else
    ListItem := lvExp.Items.Add;
  ListItem.ImageIndex := -1;
  ListItem.SubItems.Clear;
  ListItem.Caption := inttohex(fOrd, 4);
  ListItem.SubItems.Add(fName);
  ListItem.SubItems.Add(inttohex(fRVA, 8));
  ListItem.SubItems.Add(inttohex(fOffset, 8));
  ListItem.SubItems.Add(forName);
  lvExp.CustomSort(@CustomSortProc, SortColIndex);
  DrawLvSortState;
  ListItem.Selected := true;
end;

procedure TMainForm.Add1Click(Sender: TObject);
begin
  ActModify.Execute;
end;

procedure TMainForm.lvExpDblClick(Sender: TObject);
begin
  ActModify.Execute;
end;

procedure TMainForm.ToolButton4Click(Sender: TObject);
begin
  ListDump;
end;

function TMainForm.SaveChange(Fn: String; MakeBackup: Boolean = true): Boolean;
var
  NewHeader: TPEHeader;
  pNewSection: PImageSectionHeader;
  lNewSection: Cardinal;
  p: pointer;
  fs: TMemoryStream;
  j, l: Cardinal;
begin
  if MakeBackup then
    CopyFile(PChar(Fn), PChar(Fn + '.bak'), false);    //      --------------------------------------
  begin
    NewHeader := PEHeader.AddSection;
    pNewSection := NewHeader.Sections[NewHeader.SectionCount - 1];
    l := PEHeader.Sections[PEHeader.SectionCount - 1]^.PointerToRawData +
         PEHeader.Sections[PEHeader.SectionCount - 1]^.SizeOfRawData;
    if PEStream.Size > l then
      j := PEStream.Size - l
    else
      j := 0;
    Move('.Cream', pNewSection^.Name, 7);
    pNewSection^.VirtualAddress := NewHeader.CalcSectionAilgnment(
                                    NewHeader.Sections[NewHeader.SectionCount - 2]^.VirtualAddress +
                                    NewHeader.Sections[NewHeader.SectionCount - 2]^.SizeOfRawData);
    lNewSection := PEExports.AssembleExp(pNewSection^.VirtualAddress);
    pNewSection^.SizeOfRawData := NewHeader.CalcFileAilgnment(lNewSection);
    pNewSection^.Misc.VirtualSize := pNewSection^.SizeOfRawData;
    pNewSection^.Characteristics := $E00000E0;
    pNewSection^.PointerToRawData := l;

    NewHeader.ImageOptionalHeader32^.SizeOfImage := pNewSection^.VirtualAddress + lNewSection + j;
    NewHeader.DataDirectorys[IMAGE_DIRECTORY_ENTRY_EXPORT]^.VirtualAddress := pNewSection^.VirtualAddress;
    NewHeader.DataDirectorys[IMAGE_DIRECTORY_ENTRY_EXPORT]^.Size := pNewSection^.SizeOfRawData;
    p := NewHeader.PEHdrPtr;

    fs := TMemoryStream.Create;
    fs.Write(p^, NewHeader.ImageOptionalHeader32^.SizeOfHeaders);

    fs.Write(OffsetPointer(PEStream.Memory, PEHeader.ImageOptionalHeader32^.SizeOfHeaders)^,
             l - PEHeader.ImageOptionalHeader32^.SizeOfHeaders);

    fs.Write(PEExports.NewExpPtr^, lNewSection);
    l := NewHeader.CalcFileAilgnment(lNewSection) - lNewSection;
    p := AllocMem(l);
    fs.Write(p^, l);
    FreeMem(p);
    if j > 0 then
      fs.Write(OffsetPointer(PEStream.Memory, l)^, j);
    fs.SaveToFile(Fn);           //  ---------------------------------------------------
    fs.Free;
  end;
  result := true;
end;

procedure TMainForm.mmExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.Refresh1Click(Sender: TObject);
begin
  ActRefresh.Execute;
end;

procedure TMainForm.PopupMenu1Popup(Sender: TObject);
begin
  SetMenuState; 
end;

procedure TMainForm.SetMenuState;
var
  ItemSelected: Boolean;
  LoadFile: Boolean;
begin
  ItemSelected := lvExp.ItemIndex <> -1;
  LoadFile := PeName <> '';

  pmAdd.Enabled := LoadFile;
  mmAdd.Enabled := LoadFile;
  mmRefresh.Enabled := LoadFile;
  tbRefresh.Enabled := LoadFile;
  mmReload.Enabled := LoadFile;
  mmSave.Enabled := LoadFile;
  mmSaveAs.Enabled := LoadFile;
  tbSave.Enabled := LoadFile;
  tbSaveAs.Enabled := LoadFile;

  mmExportToText.Enabled := lvExp.Items.Count > 0;
  tbExportToText.Enabled := lvExp.Items.Count > 0;
  
  tbLocate.Enabled := lvExp.Items.Count > 0;
  mmLocate.Enabled := lvExp.Items.Count > 0;
  if Assigned(FrmLocate) then
    mmFindNext.Enabled := (FrmLocate.ledtOrd.Text <> '') or (FrmLocate.ledtFName.Text <> '');

  pmModify.Enabled := ItemSelected;
  mmModify.Enabled := ItemSelected;
  pmDelete.Enabled := ItemSelected;
  mmDelete.Enabled := ItemSelected;
end;

procedure TMainForm.Edit1Click(Sender: TObject);
begin
  SetMenuState;
end;

procedure TMainForm.File1Click(Sender: TObject);
begin
  SetMenuState;
end;

procedure TMainForm.Refresh2Click(Sender: TObject);
begin
  ActRefresh.Execute;
end;

procedure TMainForm.lvExpChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  UpdateInfo;
end;

procedure TMainForm.ActRefreshExecute(Sender: TObject);
begin
  ListDump;
end;

procedure TMainForm.ActModifyExecute(Sender: TObject);

  procedure AssignExp(var Des: TExport; Src: TExport);
  var
    l: integer;
  begin
    CopyMemory(@Des, @Src, SizeOf(TExport));
    l := length(Src.Name);
    if l > 0 then
    begin
      Des.Name := AllocMem(l + 1);
      CopyMemory(Des.Name, Src.Name, l);
    end;
    l := length(Src.ForwardFunc);
    if l > 0 then
    begin
      Des.ForwardFunc := AllocMem(l + 1);
      CopyMemory(Des.ForwardFunc, Src.ForwardFunc, l);
    end;
  end;

  procedure FreeExp(Exp: TExport);
  var
    l: integer;
  begin
    l := length(Exp.Name);
    if l > 0 then
    begin
      FreeMem(Exp.Name);
    end;
    l := length(Exp.ForwardFunc);
    if l > 0 then
    begin
      FreeMem(Exp.ForwardFunc);
    end;
  end;

var
  tmpExp: TExport;
begin
  if lvExp.ItemIndex = -1 then exit;  //-----------
  AssignExp(tmpExp, PEExports[PEExports.FindByOrd(StrToint('$' + lvExp.Items[lvExp.ItemIndex].Caption))]);
  ExpEditor.Exp := tmpExp;
  if ExpEditor.ShowModal = mrCancel then
    exit;
  PEExports.ModifyExp(lvExp.ItemIndex, ExpEditor.Exp);
  InsertExpListItem(lvExp.ItemIndex, ExpEditor.Exp);
  FreeExp(tmpExp);
end;

procedure TMainForm.ActAddExecute(Sender: TObject);
var
  tmpExp: TExport;
begin
  tmpExp.Orindal := 0;
  tmpExp.Name := nil;
  tmpExp.FuncRVA := 0;
  tmpExp.ForwardFunc := nil;
  ExpEditor.Exp := tmpExp;
  if ExpEditor.ShowModal = mrCancel then
    exit;
  PEExports.AddExp(ExpEditor.Exp);
  InsertExpListItem(lvExp.Items.Count, ExpEditor.Exp);
  SetMenuState;
end;

procedure TMainForm.ActAboutExecute(Sender: TObject);
begin
  FrmAbout := TFrmAbout.Create(Self);
  try
    FrmAbout.ShowModal;
  finally
    FrmAbout.Free;
  end;
//  Showmessage('Export Function Explorer'#13'Written by tt.t'#13 + VerDef);
end;

procedure TMainForm.ActDeleteExecute(Sender: TObject);
var
  i: Cardinal;
begin
  if lvExp.ItemIndex = -1 then exit;  //-----------
  i := lvExp.ItemIndex;
  PEExports.DeleteExp(PEExports.FindByOrd(StrToint('$' + lvExp.Items[lvExp.ItemIndex].Caption)));
  lvExp.Items.Delete(i);
  if i >= PEExports.ValidCount then
    i := PEExports.ValidCount - 1;
  lvExp.ItemIndex := i;
  SetMenuState;
end;

procedure TMainForm.ActOpenExecute(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    LoadFile(OpenDialog1.FileName);
  end;
end;

procedure TMainForm.ActCloseExecute(Sender: TObject);
begin
  CloseFile;
  lvExp.Clear;
  Caption := 'Export Function Explorer';
  StatusBar1.Panels[0].Text := '';
  StatusBar1.Panels[1].Text := '';
end;

procedure TMainForm.ActSaveExecute(Sender: TObject);
begin    
  SaveChange(PeName);
end;

procedure TMainForm.ActSaveAsExecute(Sender: TObject);
begin
  SaveDialog1.FileName := PeName;
  SaveDialog1.Filter := '*.*|All files';
  if SaveDialog1.Execute then
  begin
    if FileExists(SaveDialog1.FileName) then
      if Application.MessageBox(PChar('Overwrite existing file ' + SaveDialog1.FileName + '?'),
                                'Confirm', MB_OKCANCEL) = IDOK then
      begin
        PeName := SaveDialog1.FileName;
        SaveChange(PeName);
        UpdateInfo;
      end;
  end;
end;

procedure TMainForm.mmReloadClick(Sender: TObject);
var
  i: integer;
begin
  i := LvExp.ItemIndex;
  LoadFile(PeName);
  LvExp.ItemIndex := i; 
end;

procedure TMainForm.ActTestExecute(Sender: TObject);
var
  tmpFn: String;
  tmpPath: PChar;
  l: integer;
begin
  l := GetTempPath(0, nil);
  if l = 0 then
  begin
    ShowMessage('Error occured!');
    exit;
  end;
  tmpPath := AllocMem(l + 1);
  GetTempPath(l, tmpPath);
  tmpFn := tmpPath + 'ExpTestDll.dll';
  if not SaveChange(tmpFn) then
  begin
    ShowMessage('Error occured!');
    exit;
  end;
  TestForm.SetExpList(PEExports);
  TestForm.LoadDll(tmpFn);
  TestForm.ShowModal;
  DeleteFile(tmpPath);
end;

procedure TMainForm.lvExpColumnClick(Sender: TObject; Column: TListColumn);
begin
  lvExp.Column[SortColIndex].ImageIndex := -1;
  SortColIndex := Column.Index;
  LvSortAsc := not LvSortAsc;
  lvExp.CustomSort(@CustomSortProc, SortColIndex);
  DrawLvSortState;
end;

procedure TMainForm.DrawLvSortState(ShowArrow: Boolean = true);
var
  i: integer;
begin
  if not ShowArrow then
    i := -1
  else if LvSortAsc then
      i := 1
  else
      i := 0;
  lvExp.Column[SortColIndex].ImageIndex := i;
end;

procedure TMainForm.Locate;
var
  i: integer;
begin
  FrmLocate.ledtOrd.Text := '';
  FrmLocate.ledtFName.Text := '';
  FrmLocate.cbWWO.Checked := true;
  if FrmLocate.ShowModal = mrOK then
  begin
    if DoLocate(i, FrmLocate.ledtOrd.Text, FrmLocate.ledtFName.Text, FrmLocate.cbWWO.Checked) then
    begin
      LvExp.Items[i].Selected := true;
      SendMessage(LvExp.Handle, LVM_ENSUREVISIBLE, i, 0);
    end
    else
      ShowMessage('Specified function not found!');
  end;
end;

function TMainForm.DoLocate(var index: integer; Ordinal: String; FName: String; WWO: Boolean; FromIndex: integer = 0): Boolean;
var
  i: integer;
begin
  result := false;
  index := -1;
  if (Ordinal = '') and (FName = '') then
    exit;
  if Ordinal <> '' then
  begin
    for i := FromIndex to LvExp.Items.Count - 1 do
      if StrToInt('$' + LvExp.Items[i].Caption) = StrToInt('$' + Ordinal) then
      begin
        index := i;
        result := true;
        Break;
      end;
  end
  else
  begin
    FName := UpperCase(FName);
    for i := FromIndex to LvExp.Items.Count - 1 do
      if WWO then
      begin
        if UpperCase(LvExp.Items[i].SubItems.Strings[0]) = FName then
        begin
          index := i;
          result := true;
          Break;
        end;
      end
      else
        if Pos(FName, UpperCase(LvExp.Items[i].SubItems.Strings[0])) > 0 then
        begin
          index := i;
          result := true;
          Break;
        end;
    end;
end;

procedure TMainForm.ActFnExecute(Sender: TObject);
var
  i: integer;
begin
  if DoLocate(i, FrmLocate.ledtOrd.Text, FrmLocate.ledtFName.Text, FrmLocate.cbWWO.Checked,
              lvExp.ItemIndex + 1) then
  begin
    LvExp.Items[i].Selected := true;
    SendMessage(LvExp.Handle, LVM_ENSUREVISIBLE, i, 0);
  end
  else
    ShowMessage('Specified function not found!');
end;

procedure TMainForm.ActExportExecute(Sender: TObject);
var
  i: integer;
  FOrd, Fn, FRVA, FOffset, FForward, Str: String;
  Et: TMemoryStream;
  p: PChar;
begin
  Str := 'Ordinal,Function Name,RVA, Offset, Forward' + #13 + #10;
  for i := 0 to PEExports.ValidCount - 1 do
  begin
    FOrd := '0x' + IntToHex(PEExports[i].Orindal, 4);
    Fn := PEExports[i].Name;
    FRVA := '0x' + IntToHex(PEExports[i].FuncRVA, 8);
    FOffset := '0x' + IntToHex(PEHeader.RVAtoOffset(PEExports[i].FuncRVA), 8);
    FForward := PEExports[i].ForwardFunc;
    Str := Str + FOrd + ',' + Fn + ',' + FRVA + ',' + FOffset + ',' + FForward + #13 + #10;
  end;

  SaveDialog1.Filter := '*.txt|Text files';
  SaveDialog1.FileName := '';
  if SaveDialog1.Execute then
  begin
    if FileExists(SaveDialog1.FileName) then
      if Application.MessageBox(PChar('Overwrite existing file ' + SaveDialog1.FileName + '?'),
                                'Confirm', MB_OKCANCEL) <> IDOK then
        exit;
    p := PChar(@Str[1]);
    Et := TMemoryStream.Create;
    Et.Position := 0;
    Et.Write(p^, Length(p));
    Et.SaveToFile(SaveDialog1.FileName + '.txt');
    Et.Free;
  end;
end;

procedure TMainForm.ActFindExecute(Sender: TObject);
begin
  Locate;
end;

end.


