unit TestFormUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  ExpUnit2;

type
  TTestForm = class(TForm)
    Label1: TLabel;
    lbProcAddr: TLabel;
    Label3: TLabel;
    lbDllHandle: TLabel;
    Label5: TLabel;
    lbExpList: TListBox;
    rbName: TRadioButton;
    rbOrd: TRadioButton;
    Memo1: TMemo;
    procedure lbExpListDblClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    procedure UnLoadDll;
  public
    { Public declarations }
    procedure LoadDll(Fn: String);
    procedure SetExpList(Exps: TExports);
  end;

var
  TestForm: TTestForm;

implementation

{$R *.dfm}

uses
  StrUtils;

var
  h, p: Cardinal;

procedure TTestForm.LoadDll(Fn: String);
begin
  h := LoadLibrary(PChar(Fn));
  lbDllHandle.Caption := inttohex(h, 8);
  lbProcAddr.Caption := '00000000';
end;
       
procedure TTestForm.UnLoadDll;
begin
  FreeLibrary(h);
end;

procedure TTestForm.SetExpList(Exps: TExports);
var
  i: integer;
begin
  lbExpList.Clear;
  for i := 0 to Exps.ValidCount - 1 do
    if length(Exps.Items[i].Name) > 0 then
      lbExpList.Items.Add(inttohex(Exps.Items[i].Orindal, 4) + ': ' +
                          Exps.Items[i].Name)
    else
    begin
      lbExpList.Items.Add(inttohex(Exps.Items[i].Orindal, 4) + ': (Ordinal Only)');
    end;        
end;

procedure TTestForm.lbExpListDblClick(Sender: TObject);
var
  lStr, rStr: String;
  s: String;
  i, l: integer;
begin
  s := lbExpList.Items[lbExpList.ItemIndex];
  l := length(s);
  i := Pos(':', s);
  lStr := LeftStr(s, i - 1);
  rStr := RightStr(s, l - i - 1);
  if rbName.Checked then
  begin
    if rStr = '(Ordinal Only)' then
      s := lStr
    else
      s := rStr;
    p := DWORD(GetProcAddress(h, PChar(s)));
  end
  else
  begin
    p := DWORD(GetProcAddress(h, PChar(MakelParam(StrToInt('$' + lStr), 0))));
  end;

  lbProcAddr.Caption := inttohex(p, 8);
end;

procedure TTestForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  UnLoadDll;
end;

end.
