unit UtilUnit;

interface

uses  SysUtils, Classes, JwaWinnt;

function OffsetPointer(Ptr: Pointer; Delta: integer): Pointer;
//function RVAToOffset(PEPtr: Pointer; RVA: Cardinal): Cardinal;

implementation

function OffsetPointer(Ptr: Pointer; Delta: integer): Pointer;
begin
  result := Pointer(integer(Ptr) + Delta);
end;
{
function RVAToOffset(PEPtr: Pointer; RVA: Cardinal): Cardinal;
var
  pDosHeader: PImageDosHeader;
  pFileHeader: PImageFileHeader;
  pOptionalHeader32: PImageOptionalHeader32;  
  SHPtr: PImageSectionHeader;
  i: integer;
  f: Boolean;
begin            
  result := RVA;
  pDosHeader := PEPtr;
  pFileHeader := OffsetPointer(pDosHeader , pDosHeader^.e_lfanew + 4);
  pOptionalHeader32 := OffsetPointer(pFileHeader, IMAGE_SIZEOF_FILE_HEADER);

  if (RVA >= pOptionalHeader32^.ImageBase + pOptionalHeader32^.SizeOfImage) then
  begin
    Raise Exception.Create('RVAToOffset: RVA out of range!');
  end;

  SHPtr := OffsetPointer(pOptionalHeader32, pFileHeader^.SizeOfOptionalHeader);

  f := false;
  for i := 0 to pFileHeader^.NumberOfSections - 1 do
  begin
    if (RVA >= SHPtr^.VirtualAddress) and
       (RVA - SHPtr^.VirtualAddress < SHPtr^.SizeOfRawData) then
    begin
      f := true;
      break;
    end;
  end;
  if f then
  begin
    result := RVA - SHPtr^.VirtualAddress + SHPtr^.PointerToRawData;
  end
  else
    exit;
end;

}
end.
