﻿<?xml version="1.0"?>

<!-- 
	NOTE: This report is hard-coded in English since it's primary purpose is to be something that can
	be sent to me to help track down problems.
 -->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/"
	xmlns:gr="http://www.google.com/schemas/reader/atom/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>
	
<xsl:template match="eventLog">
	<html>
	<head>
		<title>FeedDemon Event Log</title>
				
		<style type="text/css">
			$INCLUDE(surfer.css)$
			$INCLUDE(commonstyles.css)$
		
			div#container {
				border: none;
				background-color: transparent;
			}
			div#actions {
				position: absolute;
				right: 40px;
				top: 10px;
				font-size: 12px;
			}
			div#actions a {
				color: white;
				text-decoration: underline;
			}
			div#noerrors, div#errnote {
				padding: 10px 20px;
				font-size: 88%;
				color: InfoText;
				background-color: InfoBackground;
			 }
			
			table { background-color: white; width: 100%; }
			th {
				font-weight: normal;
				font-size: small;
				background-color: $COLOR-GROUP-HEADER$;
				padding-top: 0;
				padding-bottom: 0;				
			}
			th { border-bottom: 1px solid $COLOR-GROUP-HEADER-BORDER$;	}
			td { border-bottom: 1px dotted $COLOR-GROUP-HEADER-BORDER$;	}
			td { vertical-align: top; padding: 8px 16px; }
			.error { color: red; font-weight: bold; }
			
			.col-type { width: 75px; text-align: center; }
			.col-time, .col-session { width: 150px; text-align: center; }
			.col-text { text-align: left; }
			
			.evenrow { background-color: $COLOR-EVEN-ROW$ !important; }
			.oddrow { background-color: $COLOR-ODD-ROW$ !important;	}			
		</style>	
	</head>
	<body>
		<div id="pagehead">
			<div id="newspapertitle">
				<img src="$IMAGEDIR$eventlog.png" align="absmiddle" />
				FeedDemon Event Log (Errors Only)
				<div id="actions">
					<a href="fdaction:?action=cleareventlog">Clear Event Log</a>
					&#160;|&#160;
					<a href="fdaction:?action=exporteventlog">Export Event Log...</a>
				</div>
			</div>
		</div>
		<div id="container">
			<xsl:variable name="nds_errors" select="session/event[@type='error']"/>

			<!-- output error events -->
			<xsl:choose>
				<xsl:when test="count($nds_errors)!=0">
					<div id="errnote">
						Please note that the errors listed below may not indicate a problem with FeedDemon.
						In many cases, these are temporary server-related issues which soon resolve themselves.
					</div>
					<table cellspacing="0" align="center">
						
						<tr>
							<th class="col-type">Type</th>
							<th class="col-session">Session</th>
							<th class="col-time">Timestamp</th>
							<th class="col-text">Text</th>
						</tr>				
						<xsl:for-each select="$nds_errors">
							<xsl:call-template name="event"/>
						</xsl:for-each>
					</table>
				</xsl:when>
				
				<xsl:otherwise>
					<div id="noerrors">No errors exist in the event log.</div>
				</xsl:otherwise>
			</xsl:choose>

			<!-- non-error events are not output (too much data) -->
			<!-- <xsl:variable name="nds_nonerrors" select="session/event[@type!='error']"/>
			<xsl:if test="count($nds_nonerrors)!=0">
				<table cellspacing="0" cellpadding="5" align="center">
					<tr>
						<th class="col-type">Type</th>
						<th class="col-session">Session</th>
						<th class="col-time">Timestamp</th>
						<th class="col-text">Text</th>
					</tr>				
					<xsl:for-each select="$nds_nonerrors">
						<xsl:call-template name="event"/>
					</xsl:for-each>
				</table>
			</xsl:if> -->
		</div>
	</body>
	</html>	
</xsl:template>

<xsl:template name="event">
	<xsl:variable name="rownum" select="position()"/>
	<xsl:variable name="rowclass">
		<xsl:choose>
			<xsl:when test="$rownum mod 2 = 1">oddrow</xsl:when>
			<xsl:otherwise>evenrow</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
				
	<tr class="event {$rowclass}">
		<td class="col-type {@type}">
			<xsl:value-of select="@type"/>
			<xsl:if test="@errCode">&#160;(<xsl:value-of select="@errCode"/>)</xsl:if>			
		</td>
		<td class="col-session">
			<xsl:choose>
				<xsl:when test="@isCurrentSession">
					Active
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="@sessionId"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>			
		<td class="col-time">
			<xsl:value-of select="@timestamp"/>
		</td>
		<td class="col-text">
			<xsl:value-of select="@text" />
			<xsl:if test=". != ''"> (<xsl:value-of select="." />)</xsl:if>
			<xsl:if test="@url">&#160;<xsl:value-of select="@url"/></xsl:if>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>