<?xml version="1.0"?>

<xsl:stylesheet version="1.0"	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<xsl:template match="rss/channel">
	<html>
	<head>
		<title>$TITLE$</title>
		<style type="text/css">
			body { 
				background-color: white; 
				color: black; 
				font-size: $FONT-SIZE-NEWSPAPER$;
				font-family: "$FONT-NAME-NEWSPAPER$", "Segoe UI", "Trebuchet MS", Tahoma, Verdana, sans-serif;
				margin: 24px 30px;
			}
	
			h1, h2, h3, h4, h5, h6 { font-weight: bold; }
			h1 { font-size: 135%; }
			h2 { font-size: 115%; }
			h3 { font-size: 105% }
			h4, h5, h6 { font-size: 100%; }
			kbd, code, pre { font-size: 100%; }
			
			#newspapertitle { font-size: x-large; margin-bottom: 24px; font-weight: bold; }
			.newsitem { margin-bottom: 24px; padding-bottom: 20px; border-bottom: 1px dotted $COLOR-GROUP-HEADER-BORDER$; }
			.newsitemtitle { font-size: larger; font-weight: bold; margin-bottom: 12px; }
			.newsitemdateline { color: gray; font-style: italic; margin-bottom: 10px; }
			div.newsitemcontent { overflow: hidden; }
			.sep { margin-left: 4px; margin-right: 4px; }	
		</style>
	</head>
	<body>
		<h1 id="newspapertitle"><xsl:value-of select="title" disable-output-escaping="yes"/></h1>
	
		<xsl:for-each select="item">
			<div class="newsitem">
			   <div class="newsitemtitle"><a href="{link}" title="{link}"><xsl:value-of select="title" disable-output-escaping="yes"/></a></div>
				<div class="newsitemdateline">
					<xsl:value-of select="pubDate"/>
					<xsl:if test="author"><span class="sep">|</span> <xsl:value-of select="author" /></xsl:if>
					<xsl:if test="source"><span class="sep">|</span><a href="{source/@url}"><xsl:value-of select="source" /></a></xsl:if>
				</div>
				<xsl:if test="description"><div class="newsitemcontent"><xsl:value-of select="description" disable-output-escaping="yes"/></div></xsl:if>
			</div>
		</xsl:for-each>
		
	</body>
	</html>	
</xsl:template>

</xsl:stylesheet>