<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<xsl:key name="key-group" match="/feeds/feed" use="@dateGroup" />
<xsl:variable name="feed-count" select="count(/feeds/feed)"/>

<xsl:template match="feeds">
<html>
<head>
	<title>$LANG_CONST(S_FeedHistoryRptTitle)$</title>
	<style type="text/css">
		$INCLUDE(surfer.css)$
		#titlelinks {
			float: right;
			font-size: small;
			font-weight: bold;
			margin-right: 20px;
		}
		#titlelinks a, a.feedtitle { text-decoration: none;	}
		#titlelinks a:hover, a.feedtitle:hover { text-decoration: underline; }
		a.feedtitle { 
			margin-right: 4px;
			color: #1F1F1F;
		}
		ul {
			margin-left: 20px;
			margin-right: 12px;
		}	
		li {
			list-style-type: none;
			margin-bottom: 4px;
		}
		img.icon { margin-right: 3px; }
		li.odd {	background-color: $COLOR-SIDEBAR$; }
	</style>
</head>
<body>
	<div id="pagehead">		
		<div id="newspapertitle">
			<div id="titlelinks">
				<xsl:choose>
					<xsl:when test="@isDisabled">
						<a href="fdaction:?action=enablefeedhistory&amp;value=1">$LANG_CONST(S_NewsLblEnableFeedHistory)$</a>
					</xsl:when>
					<xsl:otherwise>
						<a href="fdaction:?action=enablefeedhistory&amp;value=0">$LANG_CONST(S_NewsLblDisableFeedHistory)$</a>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			<img src="$IMAGEDIR$history-lg.gif" align="absmiddle" /> $LANG_CONST(S_FeedHistoryRptPageTitle)$
		</div>
	</div>

	<div id="container">
		<xsl:choose>
			<xsl:when test="@isDisabled"><ul><li class="none">$LANG_CONST(S_NewsLblFeedHistoryDisabled)$</li></ul></xsl:when>
			<xsl:when test="$feed-count=0"><ul><li class="none">$LANG_CONST(S_Empty)$</li></ul></xsl:when>	
			<xsl:otherwise>	
				<!-- note that feeds are output sorted by date added, so no extra per-group sorting is needed -->
				<xsl:for-each select="feed[count(. | key('key-group', @dateGroup)[1]) = 1]">
					<xsl:call-template name="groupheader">
						<xsl:with-param name="group-id" select="@dateGroup"/>
					</xsl:call-template>
					<ul class="groupitems" id="group_{@dateGroup}">
						<xsl:for-each select="key('key-group', @dateGroup)">	
							<xsl:sort select="@title"/>
								<xsl:variable name="li-class">
									<xsl:choose>
										<xsl:when test="position() mod 2 = 1">odd</xsl:when>
										<xsl:otherwise>even</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<!-- each item is identified by its historyId so it can be hidden without reloading the report -->
								<li class="{$li-class}" id="{@historyId}">
									<a class="icon" href="feed://{@url}" title="$LANG_CONST(S_NewsHintSubscribe)$"><img src="$IMAGEDIR$subscribe.gif" class="icon" align="absmiddle" /></a>
									<a class="feedtitle" href="feed://{@url}" title="{@url}"><xsl:value-of select="@title" disable-output-escaping="yes"/></a>							
									<a class="icon" href="fdaction:?action=previewfeed&amp;feedurl={@url}" title="$LANG_CONST(S_NewsHintPreview)$"><img src="$IMAGEDIR$preview.gif" class="icon" align="absmiddle" /></a>
									<a class="icon" href="fdaction:?action=deletehistory&amp;historyid={@historyId}" title="$LANG_CONST(S_NewsHintDeleteHistory)$"><img src="$IMAGEDIR$unsubscribe.png" class="icon" align="absmiddle" /></a>
								</li>
						</xsl:for-each>
					</ul>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</div>
	<br />
</body>
</html>
</xsl:template>

<xsl:template name="groupheader">
	<xsl:param name="group-id"/>
	
	<div class="groupheader collapsible" id="header_{$group-id}">
		<a href="fdaction:?action=togglecollapse&amp;id={$group-id}"><img src="$IMAGEDIR$arrowdown.gif" id="img_expand_{$group-id}" border="0" align="right" class="button" /></a>
		<span class="groupcaption"><a href="fdaction:?action=togglecollapse&amp;id={$group-id}"><xsl:value-of select="$group-id" disable-output-escaping="yes"/></a></span>
	</div>
</xsl:template>

</xsl:stylesheet>