<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<!-- report type:
	   0 = frptDinosaurs
      1 = frptHttpErrors
      2 = frptFeedAttention 
-->
<xsl:variable name="rpt-type" select="opml/@reportType"/>

<!-- each report has a different number of columns -->
<xsl:variable name="num-cols">
	<xsl:choose>
		<xsl:when test="$rpt-type=0">4</xsl:when>
		<xsl:when test="$rpt-type=1">5</xsl:when>
		<xsl:when test="$rpt-type=2">5</xsl:when>
	</xsl:choose>
</xsl:variable>

<xsl:template match="opml">
<html>
<head>
	$INCLUDE(metacontent-ie7.inc)$
		
	<title><xsl:value-of select="head/title"/></title>

	<style type="text/css">
		$INCLUDE(surfer.css)$
		$INCLUDE(commonstyles.css)$
		
		table {
			/*border: 1px solid $COLOR-GROUP-HEADER-BORDER$;*/
			table-layout: fixed; /* http://msdn2.microsoft.com/en-us/library/ms533020.aspx#Use_Fixed-Size_Tables */
		}
		th {
			font-weight: normal;
			font-size: small;
			background-color: $COLOR-GROUP-HEADER$;
			padding-top: 0;
			padding-bottom: 0;
		}
		th, td { border-bottom: 1px solid $COLOR-GROUP-HEADER-BORDER$;	}
	
		/* for dinosaur and poptopics menu links */
		div#pagehead a { text-decoration: underline; }
		div#pagehead a:hover { color: $COLOR-PAGEHEAD-LIGHT$ !important; }
	
		.col-counter { width: 28px; text-align: right;}
		.col-feedtitle { width: 60%; text-align: left; }
		.col-lastpostdate { text-align: center; }
		.col-icon { text-align: left; width: 32px; }
		
		.groupheader {
			text-align: left;
			background-color: $COLOR-PAGEHEAD-LIGHT$;
			color: $COLOR-PAGEHEAD-FONT$;
		}
		tr.odd {	background-color: $COLOR-SIDEBAR$;}
		span.feed-title { margin-right: 6px; }
		div.none { margin: 24px;  }

		img.indicator {			
			height:14px;
			border:1px solid $COLOR-GROUP-HEADER-BORDER$; 
			filter:progid:DXImageTransform.Microsoft.dropshadow(OffX=2,OffY=2,Color=$COLOR-GROUP-HEADER$);
		}
		
		img.favicon {
			height: 10px;
			width: 10px;
		}
		
		div#page-actions {
			float: right;
			margin-right: 24px;
			font-size: smaller;
		}
		/* extra top/bottom padding to enlarge clickable space */
		div#page-actions img { margin: 0; padding: 4px 0;}
		div#page-actions a img { margin-right: 6px;  }
		
		div.note {
			padding: 10px 20px;
			font-size: 88%;
			color: InfoText;
			background-color: InfoBackground;		
		}
	</style>
</head>
<body>
	<div id="pagehead">
		<div id="newspapertitle">
			<div id="page-actions">
				<!-- show "Export" link for attention report -->
				<xsl:if test="$rpt-type=2">
					<a href="fdaction:?action=exporttopfeeds">$LANG_CONST(S_Export)$...</a>
				</xsl:if>
				<!-- update all feeds with HTTP errors -->
				<xsl:if test="($rpt-type=1) and (count(body/outline)!=0)">
					<a href="fdaction:?action=updatehttperrfeeds"><img src="$IMAGEDIR$refresh-lg.png" align="absmiddle" />$LANG_CONST(S_UpdateAll)$</a>
				</xsl:if>
			</div>
			<!-- report image -->
			<xsl:choose>
				<xsl:when test="$rpt-type=0"><img src="$IMAGEDIR$dinosaur-lg.png" align="absmiddle" /></xsl:when>
				<xsl:when test="$rpt-type=1"><img src="$IMAGEDIR$httperror-lg.png" align="absmiddle" /></xsl:when>
				<xsl:when test="$rpt-type=2"><img src="$IMAGEDIR$attention-lg.png" align="absmiddle" /></xsl:when>
			</xsl:choose>
			<!-- report title -->
			<xsl:value-of select="head/pageTitle" disable-output-escaping="yes"/>
		</div>
	</div>

	<div id="container">
		<xsl:choose>
			<xsl:when test="count(body/outline)=0">
				<div class="none">$LANG_CONST(S_None)$</div>
			</xsl:when>
			<xsl:otherwise>
				<table cellspacing="0" cellpadding="5" align="center">
				<tr>
					<th class="col-counter feedreport">&#160;<!-- number column --></th>
					<th class="col-feedtitle feedreport">$LANG_CONST(S_NewsLblFeedTitle)$</th>
					<th class="col-lastpostdate feedreport">$LANG_CONST(S_StatLastPostDate)$</th>
					<!-- show HTTP status for error report -->
					<xsl:if test="$rpt-type=1">
						<th align="center" class="feedreport">$LANG_CONST(S_StatLastHttpStatus)$</th>
					</xsl:if>
					<!-- show attention rank for attention report -->
					<xsl:if test="$rpt-type=2">
						<th align="right" class="feedreport">$LANG_CONST(S_StatAttention)$</th>
					</xsl:if>
					<!-- icon column -->
					<th class="col-icon feedreport">					
						<xsl:choose>
							<xsl:when test="$rpt-type=2">
								<a class="icon" style="margin-left: 12px" href="fdaction:?action=resetattentionall" title="$LANG_CONST(S_NewsResetAttentionAll)$">
									<img class="icon" src="$IMAGEDIR$resetattn.gif" align="absmiddle" />									
								</a>
							</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>							
					</th>
				</tr>

				<xsl:for-each select="body/outline">
					<xsl:call-template name="outline">
						<xsl:with-param name="row-num" select="position()"/>
					</xsl:call-template>						
				</xsl:for-each>
			</table>
			
			<xsl:if test="note">
				<div class="note"><xsl:value-of select="note" disable-output-escaping="yes"/></div>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
	</div>
	<br />
</body>
</html>
</xsl:template>

<!-- feed template -->
<xsl:template name="outline">
	<xsl:param name="row-num"/>
	<xsl:variable name="feedId" select="@feedId"/>
	<xsl:variable name="tr-class">
		<xsl:choose>
			<xsl:when test="$row-num mod 2 = 1">even</xsl:when>
			<xsl:otherwise>odd</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="feed-class">
		<xsl:choose>
			<xsl:when test="@numFlagged&gt;0">flagged</xsl:when>
			<xsl:otherwise>normal</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>						

	<xsl:variable name="show-favicons" select="$SHOW-FAVICONS$"/>
	
	<tr class="{$tr-class}">
		<td class="col-counter">
			<xsl:value-of select="$row-num"/>.
		</td>
		<!-- feed title and icons -->
		<td class="col-feedtitle">
			<!-- feed favicon -->
			<xsl:if test="$show-favicons=1">$FAVICON(<xsl:value-of select="$feedId"/>)$</xsl:if>
			<a class="{$feed-class}" href="fdaction:?action=gotofeed&amp;feedid={$feedId}" title="$LANG_CONST(S_NewsHintGotoFeed)$">
				<span class="feed-title"><xsl:value-of select="@title" disable-output-escaping="yes"/></span>
			</a>
			<!-- open feed home page in new tab -->
			<a class="icon" href="{@htmlUrl}" target="_blank" title="$LANG_CONST(S_NewsHintOpenInNewTab)$">
				<img class="newtab icon" src="$IMAGEDIR$linknew.gif" align="absmiddle" />
			</a>
			<!-- feed menu -->
			<a class="icon" href="fdaction:?action=showfeedmenu&amp;feedid={$feedId}" title="$LANG_CONST(S_NewsHintFeedOptions)$">
				<img class="icon" src="$IMAGEDIR$dropdownmenu.png" align="absmiddle" />
			</a>
		</td>
		<!-- last post date -->
		<td class="col-lastpostdate">
			<xsl:choose>
				<xsl:when test="@lastPostDateDisplay">
					<xsl:value-of select="@lastPostDateDisplay"/>
				</xsl:when>
				<xsl:otherwise>$LANG_CONST(S_None)$</xsl:otherwise>
			</xsl:choose>
		</td>
		<!-- http status -->
		<xsl:if test="$rpt-type=1">
			<td align="center">
				<xsl:choose>
					<xsl:when test="@httpLastStatusCode">
						<a style="cursor:help" title="{@httpErrorText}"><span id="status_{$feedId}"><xsl:value-of select="@httpLastStatusCode"/></span></a>
						(<a href="fdaction:?action=pingfeed&amp;feedid={$feedId}">$LANG_CONST(S_NewsLblPingFeed)$</a>)
					</xsl:when>
					<xsl:otherwise>?</xsl:otherwise>
				</xsl:choose>
			</td>
		</xsl:if>
		<!-- feed attention -->
		<xsl:if test="$rpt-type=2">
			<xsl:variable name="attn-percent">
				<xsl:choose>
					<xsl:when test="@attentionPercent&gt;98">98</xsl:when>
					<xsl:when test="@attentionPercent=0">0</xsl:when>
					<xsl:when test="@attentionPercent&lt;1">1</xsl:when>
					<xsl:otherwise><xsl:value-of select="@attentionPercent"/></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<td align="right">
				<img class="indicator" style="width:{$attn-percent}%;" src="$IMAGEDIR$progress-green.gif" alt="$LANG_CONST(S_StatAttention)$={@attentionRank}" />
			</td>
		</xsl:if>
		<!-- icon column -->	
		<td class="col-icon">
			<xsl:if test="$rpt-type=2">
				<!-- reset attention -->								
				<a class="icon" style="margin-left: 12px" href="fdaction:?action=resetattention&amp;feedid={$feedId}" title="$LANG_CONST(S_NewsResetAttention)$">
					<img class="icon" src="$IMAGEDIR$resetattn.gif" align="absmiddle" />									
				</a>
			</xsl:if>							
			<xsl:if test="$rpt-type=0 or $rpt-type=1">
				<!-- unsubcribe -->
				<a class="icon" href="fdaction:?action=unsubscribe&amp;feedid={$feedId}" title="$LANG_CONST(S_NewsHintUnsubscribe)$">
					<img class="icon" src="$IMAGEDIR$unsubscribe.png" align="absmiddle" />
				</a>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

<!-- group header template -->
<xsl:template name="groupheader">
	<xsl:param name="group-id"/>
	<tr>
		<th colspan="{$num-cols}" class="groupheader" id="header_{$group-id}">
			<img src="$IMAGEDIR$folder.gif" align="absmiddle" style="margin-right:6px;" /><xsl:value-of select="$group-id" disable-output-escaping="yes"/>
		</th>
	</tr>
</xsl:template>

</xsl:stylesheet>