<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<xsl:template match="friends">
<html>
<head>
	$INCLUDE(metacontent-ie7.inc)$
		
	<title><xsl:value-of select="@title" disable-output-escaping="yes"/></title>

	<style type="text/css">
		$INCLUDE(surfer.css)$
		$INCLUDE(common.css)$
		
		#pagehead {	width: 100%; }
		#container { margin: 0;	}
		
		div.friend {
			padding: 14px 20px;
			min-height: 52px;
		}
		div.friend-name { font-weight: bold; }
		div.friend-description {
			font-style: italic;
			overflow: hidden;
			display: inline-block;
			text-overflow: ellipsis;
			white-space: nowrap;
			max-width: 88%;
		}
		div.friend-actions a:active { text-decoration: underline; }
		
		div.none { margin: 24px; }
		#searchagain { 
			float: right;
			font-size: small;
			margin-top: 3px;
			margin-right: 22px;
		}
		.odd { background-color: $COLOR-SIDEBAR$; }
		.odd, .even { border-bottom: 1px solid $COLOR-SIDEBAR-BORDER$; }
		
		img.photo { 
			width: 48px;
			float: left;
			margin-top: 4px;
			margin-right: 18px;
			border: 1px solid #555555;
			filter: progid:DXImageTransform.Microsoft.dropshadow(OffX=2,OffY=2,Color=silver);	
		}
		img.photo.followed { border-color: yellow; }
		img.photo.currentuser {	border-color: blue; border-width: 2px; }
		span.currentuser {
			font-weight: bold;
			color: blue;
		}		
	</style>
</head>
<body>
	<div id="pagehead">
		<div id="newspapertitle">
			<span id="searchagain">
				<img src="$IMAGEDIR$search.png" align="absmiddle" />
				<a href="fdaction:?action=findpeople">$LANG_CONST(S_FindMorePeople)$...</a>
			</span>
			<img src="$IMAGEDIR$friends-lg.png" align="absmiddle" /> <xsl:value-of select="@title" disable-output-escaping="yes"/>
		</div>
	</div>

	<div id="container">
		<xsl:choose>
			<xsl:when test="count(friend)=0">
				<div class="none">$LANG_CONST(S_FindPeopleNoResults)$</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="friend">
					<!-- <xsl:sort select="@numSharedPosts" data-type="number" order="descending"/>
					<xsl:sort select="@displayName"/> -->
					<xsl:call-template name="friend">
						<xsl:with-param name="row-num" select="position()"/>
					</xsl:call-template>						
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</div>
	
	<br />
</body>
</html>
</xsl:template>

<!-- friend template -->
<xsl:template name="friend">
	<xsl:param name="row-num"/>
	<xsl:variable name="row-class">
		<xsl:choose>
			<xsl:when test="$row-num mod 2 = 1">odd</xsl:when>
			<xsl:otherwise>even</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<div class="friend {$row-class}" id="user_{@userId}">
		<div class="friend-name">
			<xsl:choose>
				<xsl:when test="@isCurrentUser">
					<img class="photo currentuser" src="{@photoUrl}" />
				</xsl:when>
				<xsl:when test="@isFollowing">
					<a title="{@numSharedPosts} $LANG_CONST(S_NewsHintNumSharedPosts)$" href="fdaction:?action=showusershareditems&amp;userId={@userId}"><img class="photo followed" src="{@photoUrl}" /></a>
				</xsl:when>
				<xsl:otherwise>
					<img class="photo" src="{@photoUrl}" />
				</xsl:otherwise>
			</xsl:choose>
			<xsl:value-of select="@displayName" disable-output-escaping="yes"/>
		</div>
		<xsl:if test="@description">
			<div class="friend-description">
				<xsl:value-of select="@description" disable-output-escaping="yes"/>
			</div>
		</xsl:if>
		<div class="friend-actions">
			<xsl:choose>
				<xsl:when test="@isCurrentUser">
					<span class="currentuser">$LANG_CONST(S_ThatsMe)$</span>
				</xsl:when>
				<xsl:when test="@isFollowing">
					<a id="followlink_{@userId}" title="$LANG_CONST(S_UserUnfollowHint)$" href="fdaction:?action=unfollowuser&amp;userId={@userId}&amp;profileId={@profileId}"><strong>$LANG_CONST(S_UserUnfollow)$</strong></a>
				</xsl:when>
				<xsl:otherwise>
					<a id="followlink_{@userId}" title="$LANG_CONST(S_UserFollowHint)$" href="fdaction:?action=followuser&amp;userId={@userId}&amp;profileId={@profileId}">$LANG_CONST(S_UserFollow)$</a>
				</xsl:otherwise>
			</xsl:choose>
			<span class="sep"> | </span>
			<a title="$LANG_CONST(S_UserPreviewHint)$" href="fdaction:?action=previewuser&amp;userId={@userId}&amp;profileId={@profileId}">$LANG_CONST(S_UserPreview)$</a>
			<span class="sep"> | </span>
			<a title="$LANG_CONST(S_UserViewProfileHint)$" href="fdaction:?action=viewuserprofile&amp;userId={@userId}&amp;profileId={@profileId}">$LANG_CONST(S_UserViewProfile)$</a>
		</div>
	</div>
</xsl:template>

</xsl:stylesheet>