<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/"
	xmlns:gr="http://www.google.com/schemas/reader/atom/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<xsl:variable name="show-excerpts" select="$SHOW-EXCERPTS-IN-PREVIEW$"/>
	
<xsl:template match="rss/channel">
	<html>
	<head>
		$INCLUDE(metacontent-ie7.inc)$
	
		<title>Preview</title>
		
		<style type="text/css">
			body {
				font-size: $FONT-SIZE-NEWSPAPER$;
				font-family: "$FONT-NAME-NEWSPAPER$", "Segoe UI", "Trebuchet MS", Tahoma, Verdana, sans-serif;	
				line-height: 1.4em;		
				margin: 0;
			}		

			#pagehead {
				position: fixed;
				top: 0;
				left: 0;
				z-index: 1;
				width: 100%;
				color: $COLOR-PAGEHEAD-FONT$;
				background-color: $COLOR-PAGEHEAD-DARK$;
				padding-left: 24px;
				padding-top: 8px;
				height: 32px;
			}
			#container {
				position: relative;
				top: 34px;
				height: 100%;
			}
		
			a { text-decoration: none; }
			a:hover { text-decoration: underline; }
			a img { border: none; }
	
			/* override headings used by feeds */
			h1,h2,h3,h4,h5,h6 { font-size: 100%; font-weight: bold; font-style: italic; }
	
			div#newspapertitle {
				font-size: 16px;
				white-space: nowrap;
				overflow: hidden;
				text-overflow: ellipsis;
			}
			#newspapertitle, #newspapertitle a { color: white;  }
			
			div.fdnewsitem {
				position: relative;
				padding: 20px 24px;
			}
			div.newsitemsep {
				border-bottom: 1px dotted $COLOR-GROUP-HEADER-BORDER$;
			}
			
			div.newsitemtitle { 
				font-weight: bold; 
				font-size: medium;
				margin-bottom: 6px;
			}			
			div.newsitemtitle a { color: black; }
			
			div.newsitemcontent { 	
				overflow: hidden;
				width: 100%;
			}
			div.newsitemheader { 
				font-size: small; 
				font-style: italic;
				margin-bottom: 12px;
				color: gray;
			}
			span.sep { margin: 0 5px; }
			
			img.fdpostimg {
				height: 50px;
				max-width: 75px;
				float: right;	
				margin-left: 2px;
				margin-right: 4px;
			}
			div#content-options {
				float: right;
				font-size: small;
				margin-right: 34px;				
			}
			a img.contenticon { border: 2px solid transparent; margin-right: 3px; }
			a:hover img.contenticon { border-color: $COLOR-PAGEHEAD-LIGHT$; }
			
			<xsl:choose>
				<xsl:when test="$show-excerpts=0">img#content-full</xsl:when>
				<xsl:when test="$show-excerpts=1">img#content-excerpts</xsl:when>
				<xsl:otherwise>img#content-headlines</xsl:otherwise>
			</xsl:choose>
			{ 
				border: 2px solid $COLOR-PAGEHEAD-LIGHT$;
			}
			
			/*.even { background-color: $COLOR-EVEN-ROW$; }
			.odd { background-color: $COLOR-ODD-ROW$; }*/
		</style>
	</head>
	<body>
		<div id="pagehead">
			<div id="newspapertitle">
				<div id="content-options">
					<a href="fdaction:?action=showexcerpts&amp;value=0" title="$LANG_CONST(S_NewsLblShowFullPosts)$"><img class="contenticon" id="content-full" src="$IMAGEDIR$content-full.gif" align="middle" /></a>
					<a href="fdaction:?action=showexcerpts&amp;value=1" title="$LANG_CONST(S_NewsLblShowExcerpts)$"><img class="contenticon" id="content-excerpts" src="$IMAGEDIR$content-excerpts.gif" align="middle" /></a>
					<a href="fdaction:?action=showexcerpts&amp;value=2" title="$LANG_CONST(S_NewsLblShowHeadlines)$"><img class="contenticon" id="content-headlines" src="$IMAGEDIR$content-headlines.gif" align="middle" /></a>					
				</div>
				<a href="{link}" title="{link}"><xsl:value-of select="title" disable-output-escaping="yes"/></a>
			</div>
		</div>
	
		<div id="container">
			<xsl:for-each select="item">
				<xsl:variable name="rowclass">
					<xsl:choose>
						<xsl:when test="@sortIndex mod 2 = 1">even</xsl:when>
						<xsl:otherwise>odd</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<div class="fdnewsitem {$rowclass}">
				   <div class="newsitemtitle">
						<xsl:if test="postImageUrl and ($show-excerpts=1) and excerpt">
							<a href="{postImageUrl/@href}" title="{postImageUrl/@title}"><img class="fdpostimg" src="{postImageUrl}" /></a>
						</xsl:if>				   
				     	<a href="{link}" title="{link}"><xsl:value-of select="title" disable-output-escaping="yes"/></a>
					</div>
					<div class="newsitemheader">
						<xsl:value-of select="dateDisplay"/>
						<xsl:if test="author"><span class="sep">|</span> <xsl:value-of select="author" /></xsl:if>
						<xsl:if test="enclosure"><span class="sep">|</span><a href="{enclosure/@url}" title="{enclosure/@url}"><img src="$IMAGEDIR$enclosure.gif" align="absmiddle" /></a></xsl:if>
					</div>
					
					<xsl:if test="($show-excerpts!=2)">
						<xsl:choose>
							<xsl:when test="excerpt">
								<div class="newsitemcontent">
									<xsl:value-of select="excerpt" disable-output-escaping="yes"/>
								</div>
							</xsl:when>
							<xsl:otherwise>
								<div class="newsitemcontent">
									<xsl:value-of select="description" disable-output-escaping="yes"/>
								</div>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>					
				</div>
				<div class="newsitemsep" />
			</xsl:for-each>
		</div>
	</body>
	</html>	
</xsl:template>

</xsl:stylesheet>