<!-- 
	newspaper type will be one of the following:	
  		* folder
		* channel
		* newsitem
		* search
		* newsitemarray
 -->
<xsl:variable name="newspaper-type" select="/newspaper/@type"/>

<!-- 
	'show-excerpts' is set by FeedDemon at runtime
	  0 = always show full descriptions
	  1 = show excerpts (summaries) when more than one post displayed
	  2 = headlines
-->
<xsl:variable name="show-excerpts" select="$SHOW-EXCERPTS$"/>

<!-- # of items (this page only) -->
<xsl:variable name="item-count" select="count(/newspaper/channel/item)"/>

<!-- # of unread items -->
<xsl:variable name="unread-count" select="count(/newspaper/channel/item/state[@read=0])"/>

<!-- display/grouping/sorting -->
<xsl:variable name="group-by" select="'$GROUP-BY-INTERNAL$'"/>

<!-- page information -->
<xsl:variable name="pageNum" select="/newspaper/pageInfo/@pageNum"/>
<xsl:variable name="numPages" select="/newspaper/pageInfo/@numTotalPages"/>
<xsl:variable name="numTotalPosts" select="/newspaper/pageInfo/@numTotalPosts"/>
