<!-- postactions.inc -->
<div class="postactions">
	<!-- enclosure -->
	<xsl:if test="enclosure">
		<a class="icon" title="{enclosure/@shortName} {enclosure/@url}" href="fdaction:?action=downloadenclosure&amp;feedid={$feedId}&amp;postid={$postId}&amp;url={enclosure/@url}">
			<img src="$IMAGEDIR$enclosure.gif" class="icon postactions-enclosure" align="absmiddle" alt="{enclosure/@url}" />
		</a>
	</xsl:if>	

	<!-- twitter reply -->
	<xsl:if test="twitterUser">
		<a class="icon postactions-reply" href="fdaction:?action=twitterreply&amp;feedid={$feedId}&amp;postid={$postId}&amp;user={twitterUser}&amp;statusid={twitterStatusId}" title="$LANG_CONST(S_ReplyOnTwitter)$">
			<img src="$IMAGEDIR$twitterreply.png" class="icon postactions-reply" align="absmiddle" />
		</a>
	</xsl:if>
		
	
	<!-- mark read/unread -->
	<span class="postactions-markread">
		<a class="icon" href="fdaction:?action=toggleread&amp;feedid={$feedId}&amp;postid={$postId}" title="$LANG_CONST(S_NewsHintToggleRead)$">
			<xsl:choose>
				<xsl:when test="state/@read=1">
					<img id="img_read_{$postId}" src="$IMAGEDIR$read.gif" class="icon postactions-markread" align="absmiddle" />
				</xsl:when>
				<xsl:otherwise>
					<img id="img_read_{$postId}" src="$IMAGEDIR$unread.gif" class="icon postactions-markread" align="absmiddle" />
				</xsl:otherwise>
			</xsl:choose>
		</a>
	</span>
		
	<!-- toggle flag -->
	<span class="postactions-flag">
		<a class="icon" href="fdaction:?action=toggleflag&amp;feedid={$feedId}&amp;postid={$postId}" title="$LANG_CONST(S_NewsHintToggleFlag)$">
			<xsl:choose>
				<xsl:when test="state/@flagged!=0">
					<img id="img_flag_{$postId}" src="$IMAGEDIR$star-on.png" class="icon postactions-flag" align="absmiddle" />
				</xsl:when>
				<xsl:otherwise>
					<img id="img_flag_{$postId}" src="$IMAGEDIR$star-off.png" class="icon postactions-flag" align="absmiddle" />
				</xsl:otherwise>
			</xsl:choose>
		</a>
	</span>

	<!-- share/unshare -->
	<span class="postactions-share">
		<a class="postactions-sharemenu" title="$LANG_CONST(S_NewsHintShareMenu)$" href="fdaction:?action=showsharemenu&amp;feedid={$feedId}&amp;postid={$postId}">
			<img src="$IMAGEDIR$sharemenu.png" class="icon postactions-sharemenu" align="absmiddle" />
		</a>
	</span>
		
	<!-- tags -->
	<span class="postactions-tag">
		<a class="postactions-tagmenu" href="fdaction:?action=showtagmenu&amp;feedid={$feedId}&amp;postid={$postId}" title="$LANG_CONST(S_NewsHintTagMenu)$">
			<img src="$IMAGEDIR$tagmenu.png" class="icon postactions-tagmenu" align="absmiddle" />
		</a>
		<!-- span must be output regardless of existence of taglist for new tags to be added w/o reloading newspaper - note that the entire taglist HTML is generated by FeedDemon -->
		<span class="taglist" id="taglist_{$postId}">
			<xsl:if test="taglist">
				<xsl:value-of select="taglist" disable-output-escaping="yes"/>
			</xsl:if>
		</span>
	</span>

	<!-- more actions -->
	<span class="postactions-more">
		<a class="icon postactions-more" href="fdaction:?action=showmoreactionsmenu&amp;feedid={$feedId}&amp;postid={$postId}" title="$LANG_CONST(S_NewsHintMoreMenu)$">
			<!-- $LANG_CONST(S_More)$  --><img src="$IMAGEDIR$moremenu.png" class="icon postactions-moremenu" align="absmiddle" />
		</a>
	</span>
</div>