<xsl:if test="enclosure">
	<div class="postenclosure">
		<xsl:for-each select="enclosure">
			<xsl:variable name="enclosurelink" select="@url"/>
			<xsl:variable name="enclosuretype" select="@type"/>
			<xsl:variable name="enclosureindex" select="@index"/>
			
			<xsl:if test="$enclosureindex != 0"> &#160; | &#160; </xsl:if>

			<xsl:choose>
				<!-- !! 3.0 - localFile will be set to filename of downloaded enclosure if it exists -->
				<xsl:when test="@localFile">
					<xsl:if test="@fileIcon"><img src="$IMAGEDIR$fileicons\{@fileIcon}" class="fileicon" style="margin-right: 6px; filter:progid:DXImageTransform.Microsoft.dropshadow(OffX=1,OffY=1,Color=silver)" align="absmiddle" /></xsl:if>
					<span class="postenclosurename" style="font-size:larger;">
						<a href="fdaction:?action=openenclosure&amp;feedid={$feedId}&amp;postid={$postId}&amp;localFile={@localFile}"><xsl:value-of select="@shortName"/></a>
					</span>
				</xsl:when>
				<xsl:otherwise>
					<a href="fdaction:?action=downloadenclosure&amp;feedid={$feedId}&amp;postid={$postId}&amp;url={$enclosurelink}&amp;index={$enclosureindex}"><img src="$IMAGEDIR$enclosure.gif" class="icon" align="absmiddle" /></a>
					<span class="postenclosurename"><xsl:value-of select="@shortName"/></span>
					&#160;( <a href="fdaction:?action=downloadenclosure&amp;feedid={$feedId}&amp;postid={$postId}&amp;url={$enclosurelink}&amp;index={$enclosureindex}">$LANG_CONST(S_NewsLblDownloadEnclosure)$</a> )
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</div>
</xsl:if>