<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/"
	xmlns:gr="http://www.google.com/schemas/reader/atom/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<xsl:template match="opml">

<xsl:variable name="rpt-title" select="head/title"/>

<html>
<head>
	$INCLUDE(metacontent-ie7.inc)$
	
	<title><xsl:value-of select="$rpt-title"/></title>

	<style type="text/css">
		$INCLUDE(surfer.css)$
		$INCLUDE(commonstyles.css)$

		body {
			background-color: white;
			/*background-image: url("$IMAGETHEMEDIR$bg-fade.png");
			background-attachment: fixed;
			background-position: top left;
			background-repeat: repeat-x;*/
		}
		
		#summary-items, #attention { padding: 14px 24px; }
		#attention, #tagcloud, #actionlinks { font-size: 92%; }
		#tagcloud { 
			text-align: center;
			padding: 14px 12px; 
		}
		
		#column-main, #column-sidebar {
			position: absolute;
			top: 39px;
			bottom: 0px;
		}		
		#column-main { 
			left: 0;
			right: 220px;
			min-width: 380px;
		}
		#column-sidebar {
			width: 220px;
			border-left: 1px dotted $COLOR-SIDEBAR-BORDER$;
			background-color: $COLOR-SIDEBAR$;
			z-index: 1;
			right: 0;
			height: 100%:
		}
		#actionlinks {
			font-weight: normal;
			margin-top: 10px;
			border-top: 1px dotted $COLOR-SIDEBAR-BORDER$;
			padding-top: 10px;
		}
		#actionlinks #httperrors {
			border-top: 1px dotted $COLOR-SIDEBAR-BORDER$;
			border-bottom: 1px dotted $COLOR-SIDEBAR-BORDER$;
			margin-top: 6px;
		}
		#actionlinks #gopro {
			margin-bottom: 6px;
			font-weight: bold;
		}				
		#actionlinks #gopro a {	color: $COLOR-PAGEHEAD-DARK$;	}
		.groupheader { 
			padding-left: 8px;
			padding-right: 0;
		}

		#topposts { 
			margin-left: 20px;
			margin-top: 18px; 
			margin-bottom: 20px;
			float: left;
		}
		div.toppost {
			position: relative;
			margin-right: 20px;
			margin-bottom: 16px;
			float: left;
			width: 220px;
			height: 8em;
		}
		
		/* IE shows caret rather than hand pointer w/o this! */
		div.toppost-title a:hover { cursor: pointer; }
		span.toppost-title-unread, span.toppost-title-read, span.toppost-title-flagged {
			max-width: 174px;
			overflow: hidden;
			display: inline-block;
			text-overflow: ellipsis;
			white-space: nowrap;
		}
		.toppost-title-read { font-weight: normal }
		.toppost-title-unread { font-weight: bold; }
		.toppost-title-flagged { color: $COLOR-FLAGGED$; }
		
		/* most linked post */
		div.topmostpost {
			width: auto;
			height: auto;
			border-bottom: 1px dotted $COLOR-SIDEBAR-BORDER$;
			padding-bottom: 16px;
			margin-bottom: 16px;
		}
		div.topmostpost span.toppost-title-read, div.topmostpost span.toppost-title-read, div.topmostpost  span.toppost-title-flagged {
			max-width: 75%;
		}
		/* only shown for topmostpost */
		img.fdpostimg {
			margin: 0;
			margin-left: 12px;
			max-height: 48px;
			max-width: 90px;
			padding: 3px;
			border: 1px dotted $COLOR-SIDEBAR-BORDER$;
		}
 		a:hover img.fdpostimg { background-color: $COLOR-SIDEBAR$; }		
		
		.toppost-dateline {
			font-size: 90%;
			font-style: italic;
			white-space: nowrap;
			text-overflow: ellipsis;
			overflow: hidden;
		}
		.toppost-dateline { color: gray; }
		div.toppost-text {
			height: 4em;
			overflow: hidden;
			text-overflow: ellipsis;
			padding-bottom: 4px; 
		}
		div.toppost-text a {
			/* don't allow hyperlink styles in the feed to set color/weight */
			color:  $COLOR-HYPERLINK$ !important;
			font-weight: normal !important;
		}		

		div.showall {
			float: right;
			font-size: 85%;
			margin-right: 6px;
		}
		div.showall a { text-decoration: none !important;	}
		div.showall a:hover { text-decoration: underline !important;	}

		.task-box, .task-box-important { padding: 14px; margin: 4px; }
		.task-box {
			color: InfoText;
			background-color: InfoBackground;
			border: 1px dotted InfoText;
		}
		.task-box-important {
			color: #b22222;
			background-color: #fae4e4;
			border: 1px dotted #b22222;
		}
		.task-box-important a { color: #b22222; text-decoration: underline; }
		.task-text { text-align: center; font-size: 82%; }

		img.icon { margin-left: 4px; }
		img.newtab.icon { vertical-align: top;	}

		#attention { line-height: 1.7em; }
		.feedlist img.favicon {	margin-right: 6px; }
		.feedtitle {
			overflow: hidden;
			display: inline-block;
			text-overflow: ellipsis;
			white-space: nowrap;
			max-width: 125px;
		}
		.feedlist .unreadcount { color: $COLOR-UNREAD-COUNT$; }

		span.tag { margin-right: 4px;	}
		.cloud-rank0 { font-size: smaller; }
		.cloud-rank1 {  }
		.cloud-rank2 {	font-size: larger; font-weight: bold; }
		.tagcount {	display: none;	}

		div.groupheader a { text-decoration: underline; }

		.notags, .noattention, .notopposts { 
			margin: 12px 20px; 
			max-width: 300px;
			color: #9a9a9a;
			font-size: 92%;
		}
	</style>
</head>
<body>
	<div id="pagehead">
		<div id="newspapertitle">
			<xsl:choose>
				<xsl:when test="counts/@numUnread=0"><img src="$IMAGEDIR$subscriptions-lg.png" align="absmiddle" /></xsl:when>
				<xsl:otherwise><a href="fdaction:?action=markallfeedsread" title="$LANG_CONST(S_MarkAllFeedsRead)$"><img src="$IMAGEDIR$subscriptions-unread-lg.png" align="absmiddle" /></a></xsl:otherwise>
			</xsl:choose>
			
			<xsl:value-of select="$rpt-title"/>
		</div>
	</div>
	<div id="column-sidebar">
		<!-- tasks -->
		<xsl:if test="body/tasks">
				<xsl:for-each select="body/tasks/task">
					<xsl:variable name="taskboxclass">
						<xsl:choose>
							<xsl:when test="@isImportant">task-box-important</xsl:when>
							<xsl:otherwise>task-box</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>					
					<div class="{$taskboxclass}"><div class="task-text"><xsl:value-of select="." disable-output-escaping="yes"/></div></div>
				</xsl:for-each>
		</xsl:if>
			
		<!-- summary -->
		<xsl:call-template name="showsummary"/>			
		<!-- attention -->
		<xsl:call-template name="showattention"/>
		<!-- tag cloud -->
		<xsl:call-template name="showtagcloud"/>
	</div>

	<div id="column-main">
		<!-- top posts (popular topics) -->
		<xsl:call-template name="showtopposts"/>
	</div>
	
</body>
</html>
</xsl:template>
<!-- end main template -->

<!-- ********************************************************************************************** -->
<!-- summary template -->
<!-- ********************************************************************************************** -->
<xsl:template name="showsummary">
	<div class="groupheader">&#160;</div>

	<div id="summary-items">
		<div>
			<a href="fdaction:?action=shownewspaper&amp;filter=unread"><strong>$LANG_CONST(S_FilterName_Unread)$:</strong></a>&#160; <xsl:value-of select="counts/@numUnread"/>
		</div>
		<div>
			<a href="fdaction:?action=shownewspaper&amp;filter=flagged"><strong>$LANG_CONST(S_FilterName_Flagged)$:</strong></a>&#160; <xsl:value-of select="counts/@numFlagged"/>
		</div>
		<div id="actionlinks">
			<xsl:if test="$IS-FDLITE$!=0">
				<div id="gopro">
					<img src="$IMAGEDIR$fdicon.png" align="left" />&#160;<a href="fdaction:?action=purchase">$LANG_CONST(S_Action_GoPro)$</a>
				</div>
			</xsl:if>
			
			<a href="fdaction:?action=searchsubscriptions&amp;showdialog=1">$LANG_CONST(S_Action_Search)$...</a>
			<!-- <a href="fdaction:?action=showdinosaurs">$LANG_CONST(S_Action_ShowDinosaurs)$</a> -->
			<xsl:if test="$IS-FDLITE$=0">
				<div><a href="fdaction:?action=managecontentfilters">$LANG_CONST(S_Action_ManageContentFilters)$</a></div>
			</xsl:if>
			<!--<div><a href="fdaction:?action=showrecommendations">$LANG_CONST(S_Action_ShowRecommendations)$</a></div>
			<div>
				<xsl:choose>
					<xsl:when test="$IS-OFFLINE$!=0"><a href="fdaction:?action=toggleoffline"><strong>$LANG_CONST(S_Action_WorkOnline)$</strong></a></xsl:when>
					<xsl:otherwise><a href="fdaction:?action=toggleoffline">$LANG_CONST(S_Action_WorkOffline)$</a></xsl:otherwise>
				</xsl:choose>
			</div>-->
			<!-- choose sync platform  - only shown when not synching -->
			<!--<xsl:if test="$GRSYNC-ENABLED$=0">
				<div><a href="fdaction:?action=choosesyncplatform">$LANG_CONST(S_Action_ChooseSyncPlatform)$</a></div>
			</xsl:if>-->
			<!-- add link to HTTP error report if any errors exist -->
			<xsl:if test="counts/@numHttpErrors">
				<div id="httperrors"><a href="fdaction:?action=showhttperrors">$LANG_CONST(S_Action_ShowHttpErrors)$:</a>&#160; <xsl:value-of select="counts/@numHttpErrors"/></div>
			</xsl:if>
	</div>
	</div>
</xsl:template>

<!-- ********************************************************************************************** -->
<!-- tag cloud template -->
<!-- ********************************************************************************************** -->
<xsl:template name="showtagcloud">
	<div id="tag-container">
		<div class="groupheader">
			<div class="showall"><a href="fdaction:?action=managetags">$LANG_CONST(S_NewsLblManageTags)$</a></div>
			$LANG_CONST(S_NewsLblMyTags)$
		</div>
		<xsl:choose>
			<xsl:when test="cloud/tag">
				<div id="tagcloud">
					<xsl:for-each select="cloud/tag">
						<xsl:sort select="." data-type="text"/>
						<xsl:variable name="cloud-class">
							<xsl:choose>
								<xsl:when test="@rank=0">cloud-rank0</xsl:when>
								<xsl:when test="@rank=1">cloud-rank1</xsl:when>
								<xsl:otherwise>cloud-rank2</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<span class="tag">
							<a class="{$cloud-class}" href="fdaction:?action=showpostswithtag&amp;tag={.}" title="$LANG_CONST(S_NewsHintShowTag)$ ({@count})">
								<xsl:value-of select="."/>&#160;
							</a>
							<span class="tagcount"> (<xsl:value-of select="@count"/>)</span>
						</span>							
					</xsl:for-each>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<!-- no items have been tagged yet -->
				<div class="notags">
					<img src="$IMAGEDIR$tag.png" align="absmiddle" /> $LANG_CONST(S_NewsLblNoTags)$
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</div>
</xsl:template>

<!-- ********************************************************************************************** -->
<!-- attention template -->
<!-- ********************************************************************************************** -->
<xsl:template name="showattention">
	<!-- attention report skips feeds that the user hasn't been subscribed to for at least two days -->
	<xsl:variable name="nds_attention" select="body/outline[@attentionRank and (@daysSubscribed &gt; 1)]"/>

	<div id="attention-container">	
		<xsl:choose>
			<xsl:when test="count($nds_attention)=0">
				<!-- show note about FD needing a few days to collect attention data -->
				<div class="groupheader">$LANG_CONST(S_AttentionInfoHdr)$</div>
				<div class="noattention">$LANG_CONST(S_AttentionInfo)$</div>
			</xsl:when>
			<xsl:otherwise>						
				<div class="groupheader">
					<div class="showall"><a href="fdaction:?action=showattentionreport">$LANG_CONST(S_ShowAll)$</a></div>			
					<xsl:if test="$SHOW-MOST-ATTENTION$!=0">
						$LANG_CONST(S_NewsHdrFavoriteFeeds)$
					</xsl:if>
					<xsl:if test="$SHOW-LEAST-ATTENTION$!=0">
						$LANG_CONST(S_NewsHdrLeastFavoriteFeeds)$
					</xsl:if>
				</div>
				<div class="feedlist attention" id="attention">
					<xsl:for-each select="$nds_attention">
						<xsl:call-template name="feed"/>
					</xsl:for-each>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</div>
</xsl:template>

<!-- ********************************************************************************************** -->
<!-- top posts template -->
<!-- ********************************************************************************************** -->
<xsl:template name="showtopposts">
	<div class="groupheader">
		<div class="showall"><a href="fdaction:?action=populartopics">$LANG_CONST(S_ShowAll)$</a></div>
		$LANG_CONST(S_PopularTopics_Me)$
	</div>
	<div id="topposts">
		<xsl:choose>
			<xsl:when test="topPosts">
				<!-- output top post first -->
				<xsl:for-each select="topPosts/post[@isTopMostPost='true']">
					<xsl:sort select="@dateSortKey" data-type="number" order="descending"/>
					<xsl:call-template name="post"/>				
				</xsl:for-each>
				<!-- then output the rest -->
				<xsl:for-each select="topPosts/post[@isTopMostPost!='true']">
					<xsl:sort select="@dateSortKey" data-type="number" order="descending"/>
					<xsl:call-template name="post"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<div class="notopposts">$LANG_CONST(S_NewsLblNoMemesShort)$</div>
			</xsl:otherwise>
		</xsl:choose>		
	</div>
</xsl:template>



<!-- ********************************************************************************************** -->
<!-- individual post template -->
<!-- ********************************************************************************************** -->
<xsl:template name="post">
	<xsl:variable name="titleclass">
		<xsl:choose>
			<xsl:when test="@read=0 and @flag!=0">toppost-title-unread toppost-title-flagged</xsl:when>
			<xsl:when test="@read=0">toppost-title-unread</xsl:when>
			<xsl:when test="@flag!=0">toppost-title-flagged</xsl:when>
			<xsl:when test="@read=0">toppost-title-unread</xsl:when>
			<xsl:otherwise>toppost-title-read</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="postclass">
		<xsl:choose>
			<xsl:when test="@isTopMostPost='true'">toppost topmostpost</xsl:when>
			<xsl:otherwise>toppost</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>	
	
	<div class="{$postclass}">
		<div class="toppost-title">
			$FAVICON(<xsl:value-of select="@feedId"/>)$
			<!-- post title -->
			<a href="fdaction:?action=gotopost&amp;feedid={@feedId}&amp;postid={@postId}&amp;markpostread=1" title="{@title}">
				<span class="{$titleclass}"><xsl:value-of select="@title" disable-output-escaping="yes"/></span>
			</a>
			<a href="fdaction:?action=gotopostlink&amp;newtab=1&amp;feedid={@feedId}&amp;postid={@postId}" title="$LANG_CONST(S_NewsHintOpenInNewTab)$">
				<img class="icon newtab" src="$IMAGEDIR$linknew.gif" align="middle" />
			</a>
		</div>

		<div class="toppost-text">
			<xsl:if test="@postImageUrl">
				<a href="fdaction:?action=gotopostlink&amp;feedid={@feedId}&amp;postid={@postId}"><img class="fdpostimg" src="{@postImageUrl}" /></a>
			</xsl:if>
			<xsl:value-of select="." disable-output-escaping="yes"/>
		</div>

		<div class="toppost-dateline">
			<!-- date -->
			<xsl:value-of select="@dateDisplay" disable-output-escaping="yes"/>
			<span class="sep">|</span>
			<!-- feed title -->
			<a class="feedtitle" href="fdaction:?action=gotofeed&amp;feedid={@feedId}" title="$LANG_CONST(S_NewsHintGotoFeed)$">
				<xsl:value-of select="@feedTitle" disable-output-escaping="yes"/>
			</a>
		</div>
	</div>
</xsl:template>

<!-- ********************************************************************************************** -->
<!-- individual feed template -->
<!-- ********************************************************************************************** -->
<xsl:template name="feed">
	<div>
		<xsl:variable name="feedId" select="@feedId"/>
		<xsl:variable name="numunread" select="@numUnread"/>
		<xsl:variable name="numflagged" select="@numFlagged"/>
		<xsl:variable name="show-favicons" select="$SHOW-FAVICONS$"/>

		<xsl:variable name="feedclass">
			<xsl:choose>
				<xsl:when test="$numunread &gt; 0 and $numflagged &gt; 0">unread flagged</xsl:when>
				<xsl:when test="$numunread &gt; 0">unread</xsl:when>
				<xsl:when test="$numflagged &gt; 0">flagged</xsl:when>
				<xsl:otherwise>normal</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- feed favicon -->
		<xsl:if test="$show-favicons=1">$FAVICON(<xsl:value-of select="$feedId"/>)$</xsl:if>
		
		<!-- feed title -->		
		<a class="feedtitle {$feedclass}" href="fdaction:?action=gotofeed&amp;feedid={$feedId}" title="$LANG_CONST(S_NewsHintGotoFeed)$">
			<xsl:value-of select="@title" disable-output-escaping="yes"/>
		</a>

		<!-- unread count -->
		<xsl:if test="$numunread &gt; 0">
			<span class="unreadcount"> (<xsl:value-of select="$numunread"/>)</span>
		</xsl:if>
	</div>
</xsl:template>

</xsl:stylesheet>