<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<xsl:template match="links">
<html>
<head>
	$INCLUDE(metacontent-ie7.inc)$
	
	<title>$LANG_CONST(S_MemeRptTitle)$</title>
	
	<style type="text/css">
		$INCLUDE(surfer.css)$
		$INCLUDE(commonstyles.css)$
		
		.groupheader {
			margin-bottom: 16px;			
			padding-left: 24px;
		}

		#pagehead {	width: 100%; }
		#container { margin: 0;	}

		#mylinks, #ngpostlist {
			font-size: 94%;
		}
		#mylinks {
			margin-left: 28px;
			width: 55%;
			margin-top: 20px;
		}
		div#sidebar {
			float: right;
			width: 40%;
			background-color: $COLOR-SIDEBAR$;
			border-left: 1px dotted $COLOR-SIDEBAR-BORDER$;
			border-bottom: 1px dotted $COLOR-SIDEBAR-BORDER$;
			padding: 0;
		}
		#ngpostlist {
			padding-bottom: 18px;
			padding-left: 26px;
			padding-right: 20px;			
		}
		
		.nolinks { color: $COLOR-PAGEHEAD-DARK$; margin: 20px; max-width: 500px; }
		.nolinks a { text-decoration: underline; }
		
		/* container for link and its posts */
		div.linkpost {
			padding-right: 20px;
			margin-bottom: 32px;
		}
		
		.linktitle { font-weight: bold; margin-bottom: 8px; }
		.linktitle a { text-decoration: underline; color: $COLOR-HYPERLINK$; }
		.feedtitle { margin-right: 6px; }
		
		img.icon { margin-left: 2px; }

		a#filter { font-weight: normal; }
		a#filter:hover { color: $COLOR-PAGEHEAD-LIGHT$ !important; }
		a#filter, a.post, a.feedtitle:hover { text-decoration: underline; }

		a.feedtitle { font-weight: normal; text-decoration: none; }
		
		/* posts w/o excerpt - keep on one line */
		div.post { white-space: nowrap; }
		div.post .feedtitle { max-width: 35%; }
		div.post .posttitle { max-width: 60%; }
		div.post .posttitle, div.post .feedtitle  {
			display: inline-block;
			overflow: hidden;
			text-overflow: ellipsis;
			vertical-align: top;
		}

		div#sidebar div.none { color: gray; margin-left: 2px; margin-bottom: 8px; }
		div.ngpost { }	
		span.ngtitle {
			max-width: 80%;
			display: inline-block;
			white-space: nowrap;
			overflow-x: hidden;
			text-overflow: ellipsis;			
		}	
		.ngtitle a { font-weight: bold; text-decoration: underline; color: $COLOR-HYPERLINK$; }
		.ngtitle a:hover { color: $COLOR-HYPERLINK-HOVER$; }
		.ngtitle a:visited { color: #778899; }
		div.ngexcerpt { margin-bottom: 18px; }
		div.ngexcerpt, div.excerpt { }
		div#ngprogress {
			text-transform: uppercase;
			font-size: x-small;
			margin-top: 20px;
			margin-left: 5px;
		}
		div#ngprogress img { margin-right: 6px; }
		div#page-actions {
			float: right;
			margin-right: 24px;
			vertical-align: middle;
			font-size: smaller;
		}		
	</style>
</head>
<body>
	<div id="pagehead">		
		<div id="newspapertitle">
			<!-- uncomment next line to enable exporting popular topics to HTML -->
			<!-- <div id="page-actions"><a href="fdaction:?action=exportpoptopics">$LANG_CONST(S_Export)$...</a></div> -->

			<img src="$IMAGEDIR$popular-lg.png" align="absmiddle" />
			$LANG_CONST(S_MemeRptTitle)$: 
			<a id="filter" href="fdaction:?action=choosememefilter"><xsl:value-of select="@filter"/> <!-- <img src="$IMAGEDIR$arrow-dropdown.gif" align="bottom" /> --></a>
		</div>
	</div>
	<div id="container">
		<xsl:variable name="num-links"><xsl:value-of select="count(link)"/></xsl:variable>
		
		<!-- popular topics on NGOnline - inserted dynamically -->
		<xsl:if test="@showEveryone">
			<div id="sidebar">
				<div class="groupheader">$LANG_CONST(S_PopularTopics_Everyone)$</div>
				<div id="ngpostlist">
					<div id="ngprogress"><img src="$IMAGEDIR$ani-progress.gif" align="absmiddle" /> $LANG_CONST(S_StatusLoading)$</div>
				</div>
			</div>
			<div class="groupheader">$LANG_CONST(S_PopularTopics_Me)$</div>
		</xsl:if>		

		<xsl:if test="$num-links=0">
			<div class="nolinks">
				$LANG_CONST(S_NewsLblNoMemes)$
				<!-- <br /><br />
				<a href="fdaction:?action=findfeeds">$LANG_CONST(S_NewsLblFindFeeds)$</a> -->
			</div>
		</xsl:if>

		<div id="mylinks">
			<xsl:for-each select="link">
				<!-- sort links by popularity -->
				<xsl:sort select="@numPosts" order="descending" data-type="number"/>
			 	<xsl:variable name="link-url" select="@url"/> 
			 	<xsl:variable name="link-hash" select="@urlHash"/>
				<xsl:variable name="link-image-url" select="@imageUrl"/>
				<xsl:variable name="link-image-title" select="@imageTitle"/>
				<xsl:variable name="link-image-href">
					fdaction:?action=gotopost&amp;feedid=<xsl:value-of select="@imageFeedId"/>&amp;postid=<xsl:value-of select="@imagePostId"/>&amp;markpostread=0
				</xsl:variable>
				
				<div class="linkpost" id="{$link-hash}">
					<xsl:for-each select="post">
						<xsl:sort select="@sortIndex" data-type="number"/>
						<xsl:sort select="@feedTitle" data-type="text"/>
						
						<xsl:variable name="post-title-id"><xsl:value-of select="@postId"/>_title</xsl:variable>
						<xsl:variable name="post-num"><xsl:value-of select="position()"/></xsl:variable>
						<xsl:variable name="post-link">fdaction:?action=gotopost&amp;feedid=<xsl:value-of select="@feedId"/>&amp;postid=<xsl:value-of select="@postId"/><xsl:if test="@read='false'">&amp;markpostread=1</xsl:if></xsl:variable>
						<xsl:variable name="post-link-newtab">fdaction:?action=gotopostlink&amp;newtab=1&amp;feedid=<xsl:value-of select="@feedId"/>&amp;postid=<xsl:value-of select="@postId"/><xsl:if test="@read='false'">&amp;markpostread=1</xsl:if></xsl:variable>
						<xsl:variable name="feed-link">fdaction:?action=gotofeed&amp;feedid=<xsl:value-of select="@feedId"/></xsl:variable>
						<xsl:variable name="post-excerpt"><xsl:value-of select="." disable-output-escaping="no"/></xsl:variable>

						<xsl:variable name="post-class">
							<xsl:choose>
								<xsl:when test="@read='false'">unread post</xsl:when>
								<xsl:otherwise>normal post</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
							<!-- show title from first (earliest) post -->
							<xsl:if test="$post-num=1">
								<div class="linktitle">
									<a id="{$post-title-id}" class="{$post-class}" href="{$post-link}" title="$LANG_CONST(S_NewsHintGotoPost)$">
										<xsl:value-of select="@title"/>
									</a>
								</div>
							</xsl:if>
							
							<div class="post">
								$FAVICON(<xsl:value-of select="@feedId"/>)$
								<a class="feedtitle" href="{$feed-link}" title="$LANG_CONST(S_NewsHintGotoFeed)$">
									<xsl:value-of select="@feedTitle"/>
								</a>
								<a id="{$post-title-id}" class="posttitle {$post-class}" href="{$post-link}" title="{$post-excerpt}">
									<xsl:value-of select="@title" disable-output-escaping="yes"/>
								</a>
								<a class="icon" href="{$post-link-newtab}" title="$LANG_CONST(S_NewsHintOpenInNewTab)$">
									<img src="$IMAGEDIR$linknew.gif" class="newtab icon" align="absmiddle" />
								</a>
							</div>

					</xsl:for-each> <!-- for each post -->
				</div>
			</xsl:for-each>  <!-- for each meme -->
		</div> <!-- mylinks -->
	</div> <!-- container -->	
</body>
</html>
</xsl:template>

</xsl:stylesheet>