<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<xsl:template match="links">
<html>
<head>
	<title>$LANG_CONST(S_MemeRptTitle)$</title>
	<style type="text/css">
		body {
			width: 100%;
			height: 100%;
			font-size: $FONT-SIZE-NEWSPAPER$;
			font-family: "$FONT-NAME-NEWSPAPER$", "Segoe UI", "Trebuchet MS", Tahoma, Verdana, sans-serif;
			line-height: 1.6em;
			margin: 0;
			color: #1F1F1F;
			background-color: white;
		}
		div#newspapertitle {
			font-weight: bold;
			font-size: large;	
			height: 26px;
			overflow: hidden;
			text-overflow: ellipsis;
		}
		#pagehead { 
			padding: 0px 12px;
			padding-top: 8px; 
			height: 32px;
			width: 100%; 
			color: $COLOR-PAGEHEAD-FONT$;
			background-color: $COLOR-PAGEHEAD-DARK$;
			border-bottom: 1px solid $COLOR-PAGEHEAD-DARK$;
			/*filter: progid:DXImageTransform.Microsoft.Gradient(gradientType=0,startColorStr=$COLOR-PAGEHEAD-DARK$,endColorStr=$COLOR-PAGEHEAD-LIGHT$);*/
		}
		#container { margin: 22px 24px; margin-right: 16px; }
		img.fdpostimg {
			float: right;
			width: 100px;
			max-height: 100px;
			margin-left: 10px;
			margin-bottom: 6px;
		}

		a { color: $COLOR-HYPERLINK$; text-decoration: none; }
		a:hover { color: $COLOR-HYPERLINK-HOVER$; text-decoration: underline; }
		a.posttitle { color: black; text-decoration: underline; }

		div.excerpt { margin-top: 14px; margin-bottom: 14px; margin-right: 18px; }
		div.linkpost {
			padding-bottom: 22px; 
			padding-right: 10px;
			margin-bottom: 22px;
			border-bottom: 1px dotted $COLOR-GROUP-HEADER-BORDER$;
			min-height: 100px;
		}

		.linktitle { font-weight: bold; font-size: 104%; display: inline; }
		.linktitle a { text-decoration: underline; color: black; }

		span.dateline { margin-right: 6px; }
		span.postdate { color: gray; }
		span.sep { color: silver; margin: 0 4px; }

		a.feedtitle { font-size: 90%; font-weight: normal; text-decoration: none; }
	</style>
</head>
<body>
	<div id="pagehead">		
		<div id="newspapertitle">$LANG_CONST(APP_NAME)$ $LANG_CONST(S_MemeRptTitle)$</div>
	</div>

	<div id="container">
		<xsl:for-each select="link">
			<xsl:sort select="@numPosts" order="descending" data-type="number"/>
			<xsl:variable name="link-image-url" select="@imageUrl"/>
			
			<div class="linkpost">
				<xsl:for-each select="post">
					<xsl:sort select="@sortIndex" data-type="number"/>
					<xsl:sort select="@feedTitle" data-type="text"/>
					
					<xsl:variable name="post-num"><xsl:value-of select="position()"/></xsl:variable>
					<xsl:variable name="post-link"><xsl:value-of select="@postUrl"/></xsl:variable>
					<xsl:variable name="feed-link"><xsl:value-of select="@feedUrl"/></xsl:variable>
					<xsl:variable name="post-excerpt"><xsl:value-of select="." disable-output-escaping="no"/></xsl:variable>

					<xsl:choose>
						<xsl:when test="$post-num=1">							
							<div class="linktitle">
								<a href="{$post-link}"><xsl:value-of select="@title"/></a>
							</div>
							<div class="excerpt">
								<xsl:if test="$link-image-url"><img class="fdpostimg" src="{$link-image-url}"/></xsl:if>
								<span class="dateline"><a class="feedtitle" href="{$feed-link}"><xsl:value-of select="@feedTitle"/></a>&#160;<span class="postdate"><xsl:value-of select="@dateDisplay"/></span>:</span>
								<xsl:value-of select="$post-excerpt"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="post">
								<a class="feedtitle" href="{$feed-link}"> <xsl:value-of select="@feedTitle"/></a>
								<span class="sep">/</span>
								<a class="posttitle" href="{$post-link}" title="{$post-excerpt}"><xsl:value-of select="@title" disable-output-escaping="yes"/></a>
							</div>
						</xsl:otherwise>
					</xsl:choose>
					
				</xsl:for-each>
			</div>
		</xsl:for-each>
	</div>
</body>
</html>
</xsl:template>

</xsl:stylesheet>