<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fd="http://www.bradsoft.com/feeddemon/xmlns/1.0/">

<xsl:output method="html"
	doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<xsl:template match="opml">
<html>
<head>
	$INCLUDE(metacontent-ie7.inc)$
		
	<title><xsl:value-of select="head/title"/></title>

	<style type="text/css">
		$INCLUDE(surfer.css)$
		$INCLUDE(common.css)$
		
		.groupheader { margin-bottom: 16px; padding-left: 24px; }
		#pagehead {	width: 100%; }
		#container { margin: 0;	}
		
		div.none { margin: 24px; }
		span.sep { color: silver; margin: 0 5px;}		
		img.icon { margin-left: 4px; }
		
		div.feed { margin: 16px 24px; }
		.feed-title { font-weight: bold; }
		.feed-description { font-style: italic; }		
		.feed-title, .feed-description {
			overflow: hidden;
			display: inline-block;
			text-overflow: ellipsis;
			white-space: nowrap;			
		}
		
		div#recposts { }
		div#recfeeds {
			float: right;
			width: 35%;
			color: $COLOR-SIDEBAR-FONT$;
			background-color: $COLOR-SIDEBAR$;
			border-left: 1px dotted $COLOR-SIDEBAR-BORDER$;
			border-bottom: 1px dotted $COLOR-SIDEBAR-BORDER$;
		}
		
		div#recfeeds a:active {	text-decoration: underline; }
		
		div.post { width: 60%; margin-bottom: 18px; margin-left: 24px; }
		div.post-title { font-weight: bold; }
		div.post-excerpt { }
		.post-dateline { color: gray; }
		img.post-img {
			float: right;
			max-height: 48px;
			max-width: 64px;
			margin-left: 8px;
		}
	</style>
</head>
<body>
	<div id="pagehead">
		<div id="newspapertitle">
			<img src="$IMAGEDIR$recommendations-lg.png" align="absmiddle" /><xsl:value-of select="head/title"/>
		</div>
	</div>

	<div id="container">
		<!-- recommended feeds -->
		<div id="recfeeds">
			<div class="groupheader">$LANG_CONST(S_RecommendedFeeds)$</div>
			<xsl:choose>
				<xsl:when test="count(body/outline)=0">
					<div class="none">$LANG_CONST(S_NoFeedRecommendations)$</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="body/outline">
						<xsl:call-template name="outline">
							<xsl:with-param name="row-num" select="position()"/>
						</xsl:call-template>						
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	
		<!-- recommended posts -->
		<div id="recposts">
			<div class="groupheader">$LANG_CONST(S_RecommendedPosts)$</div>
			<xsl:choose>
				<xsl:when test="count(posts)=0">
					<div class="none">$LANG_CONST(S_NoPostRecommendations)$</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="posts/post">
						<xsl:call-template name="post" />
					</xsl:for-each>		
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</div>
	
	<br />
</body>
</html>
</xsl:template>

<!-- feed template -->
<xsl:template name="outline">
	<!-- must use url-encoded version of feed url -->
	<xsl:variable name="FeedUrl"><xsl:value-of select="@xmlUrlEncode"/></xsl:variable>
	<div class="feed">
		<div class="feed-title">
			<xsl:value-of select="@title" disable-output-escaping="yes"/>
		</div>
		<xsl:if test="@description">
			<div class="feed-description"><xsl:value-of select="@description" disable-output-escaping="yes"/></div>
		</xsl:if>
		<div class="feed-actions">
			<a title="{@xmlUrl}" href="fdaction:?action=subscribe&amp;url={$FeedUrl}&amp;source=recommendations">$LANG_CONST(S_Subscribe)$</a>
			<span class="sep">|</span>
			<a title="{@xmlUrl}" href="fdaction:?action=previewfeed&amp;feedurl={$FeedUrl}">$LANG_CONST(S_Preview)$</a>
			<span class="sep">|</span>
			<a href="fdaction:?action=dismissrecommendation&amp;url={$FeedUrl}">$LANG_CONST(S_DismissRecommendation)$</a>
		</div>
	</div>
</xsl:template>

<!-- post template -->
<xsl:template name="post">
	<xsl:variable name="post-link">fdaction:?action=grurlclick&amp;grentryid=<xsl:value-of select="@grEntryId"/>&amp;url=<xsl:value-of select="@link"/></xsl:variable>
	<div class="post">
		<div class="post-title">
			<a href="{$post-link}" title="{@link}"><xsl:value-of select="@title" disable-output-escaping="yes"/></a>
			<!-- open in new tab -->
			<a href="{$post-link}&amp;newtab=1" title="$LANG_CONST(S_NewsHintOpenInNewTab)$">
				<img src="$IMAGEDIR$linknew.gif" class="icon" align="absmiddle" />
			</a>
		</div>
		
		<div class="post-excerpt">
			<xsl:if test="@imageUrl">
				<a href="{$post-link}"><img class="post-img" src="{@imageUrl}" align="absmiddle" /></a>
			</xsl:if>
			<xsl:if test=". != ''"><xsl:value-of select="." disable-output-escaping="yes"/></xsl:if>
			<div class="post-dateline">
				<xsl:if test="@srcTitle"><xsl:value-of select="@srcTitle"/>&#160;</xsl:if>
				<em><xsl:value-of select="@dateDisplay"/></em>
			</div>
		</div>
	</div>
</xsl:template>

</xsl:stylesheet>